dnl @synopsis AX_CONFIG_BUILDDIR_DEFAULT [(dirstring-or-command)]
dnl
dnl if the current configure was run within the srcdir then 
dnl we move all configure-files into a subdir and let the configure
dnl steps continue there.
dnl
dnl this macro must be called before AM_INIT_AUTOMAKE
dnl btw, it did turn out that this macro is not all so useful, if you
dnl want a default subdir build then you also want a toplevel Makefile
dnl but this macro does not create one - you are on your own with that.
dnl
dnl @Author Guido Draheim

AC_DEFUN([AX_CONFIG_BUILDDIR_DEFAULT],[AC_REQUIRE([AC_CANONICAL_HOST])[]dnl
builddir="."
if test ".$ac_srcdir_defaulted" != ".no" ; then
  if test ".$srcdir" = ".." ; then
    builddir="m4_ifval([$1], [$1], $host)"
    AS_MKDIR_P([$builddir])
    echo __.$builddir.__ > $builddir/conftest.tmp
    cd $builddir
    if grep __.$builddir.__ conftest.tmp >/dev/null 2>/dev/null ; then
       rm conftest.tmp
       AC_MSG_RESULT([continue configure in default builddir ./$builddir])
    else
       AC_MSG_ERROR([could not change to default builddir ./$builddir])
    fi 
    srcdir=`echo "$builddir" |
             sed -e 's,^\./,,;s,[[^/]]$,&/,;s,[[^/]]*/,../,g;s,[[/]]$,,;'`
    test ".$ac_aux_dir" != "."      &&    ac_aux_dir="$srcdir/$ac_aux_dir"
    test ".$ac_install_sh" != "."   && ac_install_sh="$srcdir/$ac_install_sh"
    ac_config_guess="$SHELL $ac_aux_dir/config.guess"
    ac_config_sub="$SHELL $ac_aux_dir/config.sub"
    ac_configure="$SHELL $ac_aux_dir/configure" # Cygnus configure

    test -f $srcdir/config.log   && mv $srcdir/config.log   .
    test -f $srcdir/confdefs.h   && mv $srcdir/confdefs.h   .
    test -f $srcdir/conftest.log && mv $srcdir/conftest.log .
    test -f $srcdir/$cache_file  && mv $srcdir/$cache_file  .	

    test -f $srcdir/Makefile.top && cp $srcdir/Makefile.top $srcdir/Makefile
  fi
fi
AC_CONFIG_COMMANDS([buildir],[dnl
    builddir=`grep "continue configure in default builddir " config.log |
        sed -e "s/.*continue configure in default builddir //"`
    if test ".$builddir" != "." ; then
        AC_MSG_NOTICE([build in $builddir (automatic subdir build)])
    fi
  ])
])
