dnl @synopsis AX_CFLAGS_NO_WRITABLE_STRINGS [(shellvar)]
dnl
dnl Try to find a compiler option that makes all stringliteral readonly.
dnl
dnl The sanity check is done by looking at string.h which has a set
dnl of strcpy definitions that should be defined with const-modifiers
dnl to not emit a warning in all so many places.
dnl
dnl For the GNU CC compiler it will be -fno-writable-strings -Wwrite-strings
dnl The result is added to the shellvar being CFLAGS by default.
dnl
dnl @version $Id: ax_cflags_no_writable_strings.m4,v 1.1 2003/01/06 00:51 ac-archive-0.5.39 $
dnl @author Guido Draheim <guidod@gmx.de>
dnl
AC_DEFUN([AX_CFLAGS_NO_WRITABLE_STRINGS], 
[AC_MSG_CHECKING(m4_ifval($1,$1,CFLAGS) making strings readonly)
AC_CACHE_VAL(ac_cv_cflags_no_writable_strings,
[ac_cv_cflags_no_writable_strings="no, unknown"
 AC_LANG_SAVE
 AC_LANG_C
 ac_save_CFLAGS="$CFLAGS"
# IRIX C compiler:
#      -use_readonly_const is the default for IRIX C,
#       puts them into .rodata, but they are copied later.
#       need to be "-G0 -rdatashared" for strictmode but
#       I am not sure what effect that has really.         - guidod
for ac_arg dnl
in "-Wall     % -fno-writable-strings -Wwrite-strings" dnl   GCC
   "-v -Xc    % -xstrconst" dnl Solaris C - strings go into readonly segment
   "+w1 -Aa   % +ESlit"      dnl HP-UX C - strings go into readonly segment
   "-w0 -std1 % -readonly_strings" dnl Digital Unix - again readonly segment
   "-fullwarn -use_readonly_const %% no, not needed" dnl IRIX C its the default
   # 
do CFLAGS="$ac_save_CFLAGS "`echo $ac_arg | sed -e 's,%%.*,,' -e 's,%,,'`
   AC_TRY_COMPILE([],[return 0;],
   [ac_cv_cflags_no_writable_strings=`echo $ac_arg | sed -e 's,.*% *,,'`
   break])
done
case "$ac_cv_cflags_no_writable_strings" in
   no,*) ;;
   *)
AC_TRY_COMPILE(
[#include <string.h>],[
    char test[16];
    if (strcpy (test, "test")) return 1;],[],
[ac_cv_cflags_no_writable_strings="no, suppressed, string.h"
 cp conftest.c testtest.c
]) ;;
esac
 CFLAGS="$ac_save_CFLAGS"
 AC_LANG_RESTORE
])
case ".$ac_cv_cflags_no_writable_strings" in
   .|.no,*) AC_MSG_RESULT($ac_cv_cflags_no_writable_strings) ;;
   *) m4_ifval($1,$1,CFLAGS)="$m4_ifval($1,$1,CFLAGS) dnl
$ac_cv_cflags_no_writable_strings"
      AC_MSG_RESULT($ac_cv_cflags_no_writable_strings) ;;
esac])

dnl the only difference - the LANG selection... and the default FLAGS

AC_DEFUN([AX_CXXFLAGS_NO_WRITABLE_STRINGS], 
[AC_MSG_CHECKING(m4_ifval($1,$1,CXXFLAGS) making strings readonly)
AC_CACHE_VAL(ac_cv_cxxflags_no_writable_strings,
[ac_cv_cxxflags_no_writable_strings="no, unknown"
 AC_LANG_SAVE
 AC_LANG_CXX
 ac_save_CXXFLAGS="$CXXFLAGS"
# IRIX C compiler:
#      -use_readonly_const is the default for IRIX C,
#       puts them into .rodata, but they are copied later.
#       need to be "-G0 -rdatashared" for strictmode but
#       I am not sure what effect that has really.         - guidod
for ac_arg dnl
in "-Wall     % -fno-writable-strings -Wwrite-strings" dnl   GCC
   "-v -Xc    % -xstrconst" dnl Solaris C - strings go into readonly segment
   "+w1 -Aa   % +ESlit"      dnl HP-UX C - strings go into readonly segment
   "-w0 -std1 % -readonly_strings" dnl Digital Unix - again readonly segment
   "-fullwarn -use_readonly_const %% no, not needed" dnl IRIX C its the default
   # 
do CXXFLAGS="$ac_save_CXXFLAGS "`echo $ac_arg | sed -e 's,%%.*,,' -e 's,%,,'`
   AC_TRY_COMPILE([],[return 0;],
   [ac_cv_cxxflags_no_writable_strings=`echo $ac_arg | sed -e 's,.*% *,,'`
   break])
done
case "$ac_cv_cxxflags_no_writable_strings" in
   no,*) ;;
   *)
AC_TRY_COMPILE(
[#include <string.h>],[
    char test[16];
    if (strcpy (test, "test")) return 1;],[],
[ac_cv_cxxflags_no_writable_strings="no, suppressed, string.h"
 cp conftest.c testtest.c
]) ;;
esac
 CXXFLAGS="$ac_save_CXXFLAGS"
 AC_LANG_RESTORE
])
case ".$ac_cv_cxxflags_no_writable_strings" in
   .|.no,*) AC_MSG_RESULT($ac_cv_cxxflags_no_writable_strings) ;;
   *) m4_ifval($1,$1,CXXFLAGS)="$m4_ifval($1,$1,CXXFLAGS) dnl
$ac_cv_cxxflags_no_writable_strings"
      AC_MSG_RESULT($ac_cv_cxxflags_no_writable_strings) ;;
esac])
