<?php
  /**
   * The atkparserAttribute class represents an attribute of a node
   * ......
   * @author	 : Ivo Jansch <ivo@achievo.com>
   * @version	 : 0.5
   *
   * $Id: class.atkparserattribute.inc,v 1.3 2001/02/23 11:17:30 sandy Exp $
   * $Log: class.atkparserattribute.inc,v $
   * Revision 1.3  2001/02/23 11:17:30  sandy
   * - Updated the layout class with new template engine
   * - New Dummy attribute
   * - New skel directory
   * - and some small new config vars
   *
   * Revision 1.2  2001/02/22 22:46:18  peter
   * changed edit/search API, new member vars, clean-up of code
   *
   * Revision 1.1.1.1  2001/01/10 13:57:58  sandy
   * Achievo Tool Kit
   *
   */
  class atkParserAttribute extends atkAttribute
  {
    var $m_text;

    /**
     * Constructor
     * @param $name Name of the attribute
     * @param $text text field
     * @param $flags Flags for this attribute
     */
    function atkParserAttribute($name, $text, $flags=0)
    {
      $this->atkAttribute($name,$flags); // base class constructor
      $this->m_text = $text;
    }

    /**
     * Parses a record
     * @param $record Array with fields
     * @return Parsed string
     */
    function edit($record="")
    {
      return stringparse($this->m_text,$record);
    }

    /**
     * VOID implementation.. parserAttribute has no data associated with it, so you can't search it.
     * @param $record Array with fields
     */
    function search($record="")
    {
      return "&nbsp;";
    }

    /**
     * Parses a record
     * @param $record  Array with fields
     * @return Parsed string
     */
    function display($record)
    {
      return stringparse($this->m_text,$record);
    }

    /**
     * No function, but is neccesary
     */
    function store($a, $b)
    {
    }

    /**
     * No function, but is neccesary
     */
    function addToQuery(&$query, $tablename="", $fieldaliasprefix="", $rec, $level, $mode)
    {
    }
  }
?>