<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 */
?>

<?php
  include("acid_conf.php");
  include("acid_db_common.php");
  include("acid_common.php");
?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Analysis Console for Incident Databases (ACID) <?php echo $ACID_VERSION; ?> -->
<HTML>
  <HEAD>
    <META name="Author" content="Roman Danyliw">
    <TITLE>ACID: Alert Group (AG) Maintenance</TITLE>
    <LINK rel="stylesheet" type="text/css" href="acid_style.css">
</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_hdr1.html");
     ?>
  </TD>
  <TD class="mainheadertitle">Alert Group Maintenance</TD>
  <TD class="mainheader" ALIGN=RIGHT>
     <?php
       include("acid_hdr2.html");
     ?>
  </TD>
</TR>
</TABLE>
<P><P>

<?php
  /* Connect to the Alert database */
  $db=acid_mysql_connect($alert_host, $alert_port, $alert_user, $alert_password, $alert_dbname);
  mysql_select_db($alert_dbname, $db);

  if ( $num_result_rows == "" )
  {
     $num_result_rows = -1;
     $current_view = -1;
  }
  else if ( $num_result_rows > 0 && 
            ord($submit) >= ord("0") && ord($submit) <= ord("9") )
  {
    $current_view = $submit;
    $action = "view";
  }
?>

<CENTER>
 <A HREF="acid_ag_main.php?action=list">list all</A> | 
 <A HREF="acid_ag_main.php?action=create">create</A> |
 <A HREF="acid_ag_main.php?action=view">view</A> |
 <A HREF="acid_ag_main.php?action=edit">edit</A> |
 <A HREF="acid_ag_main.php?action=delete">delete</A> |
 <A HREF="acid_ag_main.php?action=clear">clear</A>
</CENTER>
<HR>

<FORM METHOD="POST" ACTION="acid_ag_main.php">

<?
  if ( $debug_mode == 1 )
     echo '<TABLE BORDER=1>
             <TR><TD>action</TD><TD>submit</TD></TR>
             <TR><TD>'.$action.'</TD><TD>'.$submit.'</TD></TR>
           </TABLE>';

  if ( $submit == "Clear Selected" )
  {
     $del_cnt = 0;
     for ( $i = 0; $i < $show_rows; $i++)
     {
         if ( $ag_del[$i] != "" )
         {
            GetQueryResultID($ag_del[$i], $seq, $sid, $cid);

            /* Delete the alert list associated with the AG */
            $sql = "DELETE FROM acid_ag_alert ".
                   "WHERE ag_id=".$ag_id." AND ag_sid=".$sid." AND ag_cid=".$cid;
            if ( $debug_mode == 1 )    echo $sql.'<BR>';

            mysql_query($sql, $db);
            if ( mysql_errno($db) > 0 )
              FatalError("Error deleting packet list for the AG".$sql);
            else
              ++$del_cnt;
         } 
     }
     
     if ( $del_cnt > 0 )
     {
        ErrorMessage("Successfully cleared ".$del_cnt." alerts");
        $num_result_rows -= $del_cnt;   
     }

     $action = "view";
  }

  if ( $submit == "Clear ALL of AG")
  { 
     /* Delete the alert list associated with the AG */
     $sql = "DELETE FROM acid_ag_alert ".
            "WHERE ag_id=".$ag_id;
     if ( $debug_mode == 1 )    echo $sql.'<BR>';

     mysql_query($sql, $db);
     if ( mysql_errno($db) > 0 )
        FatalError("Error clearing alert list for the AG".$sql);
     else
     {
        ErrorMessage("Successfully cleared entire alert group");
        $num_result_rows = 0;   
     }

     $action = "view";
  }

  if ( $action == "create" )                                    echo '<H3>Create group</H3>';
  else if ($action == "view" )                                  echo '<H3>View group</H3>';
  else if ($action == "edit" || $action == "save" )             echo '<H3>Edit group</H3>';
  else if ($action == "delete" || $action == "delete_confirm" ) echo '<H3>Delete group</H3>';
  else if ($action == "clear" || $action == "clear_confirm" )   echo '<H3>Clear group</H3>';
  else if ($action == "list" )                                  echo '<H3>List groups</H3>';

  if ( $submit != "" )
  {
     if ( $action == "create" )
     {
        $sql = "INSERT INTO acid_ag (ag_name, ag_desc) VALUES ('".$ag_name."','".$ag_desc."');";
        mysql_query($sql, $db);

        if ( mysql_errno($db) > 0 )
           FatalError("Error Inserting new AG");

        $ag_id = mysql_insert_id($db);
        $action = "view";
     }
     else if ( $action == "save" )
     {
        $sql = "UPDATE acid_ag SET ag_name='".$ag_name."', ag_desc='".$ag_desc."' ".
               "WHERE ag_id=".$ag_id;

        mysql_query($sql, $db);
        if ( mysql_errno($db) > 0 )
           FatalError("Error updating the AG");

        $action = "view";
     }
     else if ( $action == "delete_confirm" )
     {
        /* Delete the packet list associated with the AG */
        $sql = "DELETE FROM acid_ag_alert WHERE ag_id=".$ag_id;
        mysql_query($sql, $db);
        if ( mysql_errno($db) > 0 )
           FatalError("Error deleting packet list for the AG".$sql);

        /* Delete the AG */
        $sql = "DELETE FROM acid_ag WHERE ag_id=".$ag_id;
        mysql_query($sql, $db);
        if ( mysql_errno($db) > 0 )
           FatalError("Error deleting the AG".$sql);
     }
     else if ( $action == "clear_confirm" )
     {
        /* Delete the packet list associated with the AG */
        $sql = "DELETE FROM acid_ag_alert WHERE ag_id=".$ag_id;
        mysql_query($sql, $db);
        if ( mysql_errno($db) > 0 )
           FatalError("Error deleting packet list for the AG".$sql);
        
        $action = "view";
     }

     if ( $action == "delete_confirm" )
     {
        ErrorMessage("<B>DELETED successfully</B>");
        $action = "view";
        $ag_name = $ag_desc = "<I>information deleted</I>";
     }
     else
     {
     /* Re-Query the information to print the AG info out */
     if ( $ag_id > 0)
        $sql = "SELECT ag_id, ag_name, ag_desc FROM acid_ag WHERE ag_id=".$ag_id;
     else
        $sql = "SELECT ag_id, ag_name, ag_desc FROM acid_ag WHERE ag_name='".$ag_name."'";

     $result = mysql_query($sql, $db);
     if ( mysql_errno($db) > 0 )
     {
        ErrorMessage("The entered search criteria is invalid.  Try again!");
        $submit = "";
     }
     else if ( mysql_num_rows($result) < 1 )
     {
        ErrorMessage("No AG found with that criteria.".$sql);
        $submit = "";
     }
     else
     {
        $myrow = mysql_fetch_row($result);
        $ag_id = $myrow[0];
        $ag_name = $myrow[1];
        $ag_desc = $myrow[2]; 
     }
     }
  }

  if ( $action == "list" )
  {
     $sql = "SELECT ag_id, ag_name, ag_desc FROM acid_ag";

     $result = mysql_query($sql, $db);
     $num = mysql_num_rows($result);
     if ( $num < 1 )
     {
        echo "<CENTER><B>There are no Alert Groups</B></CENTER>";
     }
     else
     {
       echo '<TABLE BORDER=1 CELLSPACING=0 PADDING=0 WIDTH="100%">
              <TR>
               <TD CLASS="plfieldhdr">ID</TD>
               <TD CLASS="plfieldhdr">Name</TD>
               <TD CLASS="plfieldhdr">Description</TD>
               <TD CLASS="plfieldhdr">Actions</TD>
              </TR>';
        for ( $i = 0; $i < $num; $i++)
        {
           $myrow = mysql_fetch_row($result);
           echo '<TR><TD CLASS="plfield">
                     <A HREF="acid_ag_main.php?action=view&ag_id='.$myrow[0].'&submit=x">'.$myrow[0].'</A></TD>
                     <TD CLASS="plfield">'.$myrow[1].'</TD>
                     <TD CLASS="plfield">'.$myrow[2].'</TD>
                     <TD CLASS="plfield"> 
                       <A HREF="acid_ag_main.php?action=edit&ag_id='.$myrow[0].'&submit=x">edit</A> |
                       <A HREF="acid_ag_main.php?action=delete&ag_id='.$myrow[0].'&submit=x">delete</A> |
                       <A HREF="acid_ag_main.php?action=clear&ag_id='.$myrow[0].'&submit=x">clear</A>
                     </TD>
                 </TR>';
        }
        echo '</TABLE>';
        mysql_free_result($result);
     }
  }

  if ( $action != "list" )
  {
     echo '<TABLE WIDTH="100%" BORDER=2 BGCOLOR="#CCCC99">
           <TR>
            <TD WIDTH="10%"><B>ID #</B></TD>
            <TD>';

            if ( $action == "create" && $submit == "")
               echo '&nbsp;<I> not assigned yet </I>&nbsp';
            else if ( $submit == "" )
               echo '<INPUT TYPE="text" NAME="ag_id" VALUE="'.$ag_id.'">';
            else if ( ($action == "view" || $action == "edit" || $action == "delete" || $action == "clear") &&
                      $submit != "" )
            {
               echo '<INPUT TYPE="hidden" NAME="ag_id" VALUE="'.$ag_id.'">';
               echo $ag_id;
            }

     echo ' </TD>
           <TR>
            <TD VALIGN=TOP><B>Name</B></TD>
            <TD>';

            if ( $action == "create" && $submit == "")
               echo '<INPUT TYPE="text" NAME="ag_name" SIZE=40 VALUE="'.$ag_name.'">';
            else if ( $submit == "" )
            {
               echo '<SELECT NAME="ag_name">
                       <OPTION VALUE="">{ AG Name }';
               $sql = "SELECT ag_name FROM acid_ag;";
               $result = mysql_query($sql, $db);
               if ( $result  )
               {
                  $num = mysql_num_rows($result);

                  for ( $i = 0; $i < $num; $i++ )
                  {
                      $myrow = mysql_fetch_row($result);
                      echo '<OPTION VALUE="'.$myrow[0].'">'.$myrow[0];
                  }                  

                  mysql_free_result($result);
               }

               echo '</SELECT>';
            }
            else if ( $action == "edit" && $submit != "" )
               echo '<INPUT TYPE="text" NAME="ag_name" SIZE=40" VALUE="'.$ag_name.'">';
            else if ( ($action == "view" || $action == "delete" || $action = "clear") && $submit != "" )
               echo $ag_name;

     echo ' </TD>';
     
     if ( ($action == "create" && $submit == "") ||
          (($action == "view" || $action == "edit" || $action == "delete" || $action == "clear") && 
          $submit != "" ) )
     {
       echo '
          <TR>
           <TD VALIGN=TOP><B>Description</B></TD>
           <TD>';

            if ( $action == "create" && $submit == "" )
               echo '<TEXTAREA NAME="ag_desc" COLS=70 ROWS=4>'.$ag_desc.'</TEXTAREA>';
            else if ( $action == "edit" && $submit != "" )
               echo '<TEXTAREA NAME="ag_desc" COLS=70 ROWS=4>'.$ag_desc.'</TEXTAREA>';
            else if ( ($action == "view" || $action == "delete" || $action == "clear") && $submit != "" )
               echo $ag_desc;

       echo '
           </TD>
          </TR>';
     }


     echo '</TABLE>';
 
   /* Print the Appropriate button */
   if ( $submit == "" || $action == "edit" || $action == "delete" || $action == "clear" )
   {
     echo '<CENTER> <FONT>';

     if ( $action == "create" )      $button_text = "Create Alert Group";
     else if ( $action == "view" )   $button_text = "View Alert Group";
     else if ( $action == "edit" && $submit == "" )   $button_text = "Edit Alert Group";
     else if ( $action == "edit" && $submit != "" )  
     {  $button_text = "Save Changes";  $action = "save"; }
     else if ( $action == "delete" && $submit == "" )  $button_text = "Delete Alert Group";
     else if ( $action == "delete" && $submit != "" ) 
     {  $button_text = "Confirm Delete"; $action = "delete_confirm";  }
     else if ( $action == "clear" && $submit == "" )  $button_text = "Clear Alerts from Group";
     else if ( $action == "clear" && $submit != "" ) 
     {  $button_text = "Confirm Clear"; $action = "clear_confirm";  }

     echo '<INPUT TYPE="submit" NAME="submit" VALUE="'.$button_text.'">';

     echo '</FONT> </CENTER>';
   }

  echo '<INPUT TYPE="hidden" NAME="action" VALUE="'.$action.'">';

  if ( $action == "view" && $submit != "" )
  {
     /* Calculate the Unique Alerts */
     $sql = "SELECT ag_sid, ag_cid FROM acid_ag_alert WHERE ag_id=".$ag_id;

     /* Run the query to determine the number of rows (No LIMIT)*/
     if ( $num_result_rows == -1 )
     {
        $current_view = 0;
        $result = mysql_query($sql, $db);
        if ( $result  )
        {
           $num_result_rows = mysql_num_rows($result);
           mysql_free_result($result);
        }
        else
           $num_result_rows = 0;
      }

      /* Run the Query again for the actual data (with the LIMIT */
      $limit_tmp = " LIMIT ".($current_view * $show_rows).",".$show_rows;

      if ( $debug_mode == 1 )
         echo $sql.$limit_tmp;

      $result = mysql_query($sql.$limit_tmp, $db);

      echo '<P><HR>';
      /* Print the current view number and # of rows */
      if ( $num_result_rows != 0 )
      {
         printf("<FONT><CENTER>Displaying alerts %d-%d of %d total<BR></CENTER></FONT><BR>\n", 
                ($current_view * $show_rows)+1, 
                (($current_view * $show_rows) + $show_rows-1) < $num_result_rows ? 
                (($current_view * $show_rows) + $show_rows) : $num_result_rows, 
                $num_result_rows);

         echo '<TABLE BORDER=1 CELLSPACING=0 PADDING=0 WIDTH="100%">
                <TR>
                 <TD></TD>
                 <TD CLASS="plfieldhdr">ID</TD>
                 <TD CLASS="plfieldhdr">Signature</TD>
                 <TD CLASS="plfieldhdr">TimeStamp</TD>
                 <TD CLASS="plfieldhdr">Source<BR>Address</TD>
                 <TD CLASS="plfieldhdr">Dest.<BR>Address</TD>
                 <TD CLASS="plfieldhdr">Layer 4<BR>Protocol</TD>';

      }
      else
         printf("<P><CENTER><B>0 Alerts are currently in this group</B></CENTER><P>\n");

     $i = 0;
     while ( $myrow = mysql_fetch_row ($result) )
     {
        echo '<TR BGCOLOR="'.((($i % 2) == 0) ? "DDDDDD" : "FFFFFF").'">';
        $tmp_rowid = "#".(($current_view * $show_rows)+$i)."-(".$myrow[0]."-".$myrow[1].")";
        echo ' <TD><INPUT TYPE="checkbox" NAME="ag_del['.$i.']" VALUE="'.$tmp_rowid.'"></TD>';
        
        $sql2 = "SELECT event.sid, event.cid, signature, timestamp, ip_src0, ip_src1, ip_src2, ip_src3, ".
                "ip_dst0, ip_dst1, ip_dst2, ip_dst3, ip_proto FROM event, iphdr ".
                "WHERE event.sid=".$myrow[0]." AND event.cid=".$myrow[1]." AND ".
                "iphdr.sid=".$myrow[0]." AND iphdr.cid=".$myrow[1];

        $result2 = mysql_query($sql2, $db);
        $myrow2 = mysql_fetch_row($result2);
        echo ' <TD>
                <FONT><CENTER>
                    <A HREF="acid_pkt_main.php?submit='.rawurlencode($tmp_rowid).
                            '&save_sql='.rawurlencode($sql).'">'.$tmp_rowid.'</A>
                </CENTER></FONT></TD>
               <TD ALIGN=CENTER>'.$myrow2[2].'
               <TD ALIGN=CENTER><FONT>'.$myrow2[3].'</FONT>';

        $tmp_iplookup = 'acid_pkt_main.php?sig%5B0%5D=%3D'.
                          '&num_result_rows=-1'.
                          '&time%5B0%5D%5B0%5D=+&time%5B0%5D%5B1%5D=+'.
                          '&submit=Query+DB&current_view=-1&ip_addr_cnt=2';
      if ( $myrow2[4] != "" )
         echo '  <TD ALIGN=CENTER>
               <A HREF="'.$tmp_iplookup.BuildIPFormVars($myrow2[4], $myrow2[5], $myrow2[6], $myrow2[7]).'">'.
                                $myrow2[4].".".$myrow2[5].".".$myrow2[6].".".$myrow2[7].'</A>';
      else
         echo '   <A HREF="acid_app_faq.php#1">unknown</A>';

      if ( $myrow2[8] != "" )
         echo '  <TD ALIGN=CENTER>
               <A HREF="'.$tmp_iplookup.BuildIPFormVars($myrow2[8], $myrow2[9], $myrow2[10], $myrow2[11]).'">'.
                                $myrow2[8].".".$myrow2[9].".".$myrow2[10].".".$myrow2[11].'</A>';
      else
         echo '   <A HREF="acid_app_faq.php#1">unknown</A>';

        echo '    <TD ALIGN=CENTER><FONT>'.IPProto2str($myrow2[12]).'</FONT>';

        mysql_free_result($result2);        
        ++$i;
     }

     echo '</TABLE>';
     mysql_free_result($result);     

     echo '<INPUT TYPE="hidden" NAME="num_result_rows" VALUE="'.$num_result_rows.'">';
     echo '<INPUT TYPE="hidden" NAME="current_view" VALUE="'.$current_view.'">';

     /* ****** Print out Browsing Buttons ********************************************/
     PrintBrowseButtons($num_result_rows, $show_rows, $max_scroll_buttons, $current_view);

     /* Print out the AG browse information */  
     if ( $num_result_rows > 0 )
        echo '<CENTER><FONT>
              <INPUT TYPE="submit" NAME="submit" VALUE="Clear Selected">
              <INPUT TYPE="submit" NAME="submit" VALUE="Clear ALL of AG">
              </FONT></CENTER>';
  }
  }
?>

</FORM>

<P>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_footer.html");
     ?>
  </TD>
</TR>
</TABLE>

</BODY>

</HTML>




