/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.bytearray;

import com.adobe.acrobat.bytearray.ContiguousByteRange;
import java.util.Vector;

public class ByteRange
extends Vector {
    private static ByteRange gEmptyByteRange = new ByteRange(0);
    private static ByteRange gUniversalByteRange = new ByteRange(0, 0x7FFFFFFE);

    private ByteRange(int n) {
        super(n);
    }

    public ByteRange(int n, int n2) {
        this(1);
        this.addRange(n, n2);
    }

    private ByteRange(ByteRange byteRange) {
        this(byteRange.elementCount);
        int n = 0;
        while (n < byteRange.elementCount) {
            this.addElement(byteRange.elementData[n]);
            ++n;
        }
    }

    public ByteRange(ContiguousByteRange contiguousByteRange) {
        this(1);
        this.addRange(contiguousByteRange);
    }

    public ByteRange(String string) {
        this(10);
        if (!string.startsWith("bytes=")) {
            throw new RuntimeException("Can't parse ByteRange string");
        }
        string = string.substring("bytes=".length());
        while (string.length() != 0) {
            int n = string.indexOf("-");
            int n2 = string.indexOf(",");
            if (n2 == -1) {
                n2 = string.length();
            }
            int n3 = Integer.parseInt(string.substring(0, n));
            int n4 = Integer.parseInt(string.substring(n + 1, n2));
            this.addRange(n3, n4);
            if (n2 == string.length()) break;
            string = string.substring(n2 + 1);
        }
    }

    private void addRange(int n, int n2) {
        this.addRange(new ContiguousByteRange(n, n2));
    }

    private synchronized void addRange(ContiguousByteRange contiguousByteRange) {
        if (contiguousByteRange == null) {
            return;
        }
        if (this.elementCount == 0 || contiguousByteRange.getStart() > this.getEnd() + 1) {
            this.addElement(contiguousByteRange);
            return;
        }
        int n = 0;
        while (n < this.elementCount) {
            ContiguousByteRange contiguousByteRange2 = this.getNthContiguousByteRange(n);
            if (contiguousByteRange2.intersectsOrAbuts(contiguousByteRange)) {
                contiguousByteRange = contiguousByteRange.union(contiguousByteRange2);
                this.setElementAt(contiguousByteRange, n);
                while (n < this.elementCount - 1) {
                    ContiguousByteRange contiguousByteRange3 = this.getNthContiguousByteRange(n + 1);
                    if (!contiguousByteRange3.intersectsOrAbuts(contiguousByteRange)) break;
                    contiguousByteRange = contiguousByteRange.union(contiguousByteRange3);
                    this.setElementAt(contiguousByteRange, n);
                    this.removeElementAt(n + 1);
                }
                return;
            }
            if (contiguousByteRange.getEnd() < contiguousByteRange2.getStart()) {
                this.insertElementAt(contiguousByteRange, n);
                return;
            }
            ++n;
        }
    }

    public int byteIndex(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.elementCount) {
            ContiguousByteRange contiguousByteRange = this.getNthContiguousByteRange(n3);
            if (n < contiguousByteRange.getStart()) break;
            if (n < contiguousByteRange.getEnd()) {
                n2 += n + 1 - contiguousByteRange.getStart();
                break;
            }
            n2 += contiguousByteRange.getLength();
            ++n3;
        }
        return n2;
    }

    public boolean contains(int n) {
        int n2 = 0;
        while (n2 < this.elementCount) {
            ContiguousByteRange contiguousByteRange = this.getNthContiguousByteRange(n2);
            if (contiguousByteRange.getStart() <= n && n <= contiguousByteRange.getEnd()) {
                return true;
            }
            if (n < contiguousByteRange.getStart()) {
                return false;
            }
            ++n2;
        }
        return false;
    }

    public boolean contains(ByteRange byteRange) {
        int n = 0;
        while (n < byteRange.elementCount) {
            ContiguousByteRange contiguousByteRange = byteRange.getNthContiguousByteRange(n);
            if (!this.contains(contiguousByteRange)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean contains(ContiguousByteRange contiguousByteRange) {
        if (contiguousByteRange == null) {
            return true;
        }
        int n = contiguousByteRange.getStart();
        int n2 = contiguousByteRange.getEnd();
        int n3 = 0;
        while (n3 < this.elementCount) {
            ContiguousByteRange contiguousByteRange2 = this.getNthContiguousByteRange(n3);
            if (contiguousByteRange2.getStart() <= n && contiguousByteRange2.getEnd() >= n2) {
                return true;
            }
            if (contiguousByteRange2.getEnd() >= n) {
                return false;
            }
            ++n3;
        }
        return false;
    }

    public ByteRange decapitate(int n) {
        if (this.elementCount == 0 || this.getStart() >= n) {
            return this;
        }
        ByteRange byteRange = new ByteRange(this.elementCount);
        int n2 = 0;
        while (n2 < this.elementCount) {
            ContiguousByteRange contiguousByteRange = this.getNthContiguousByteRange(n2);
            if (contiguousByteRange.getEnd() >= n) {
                if (contiguousByteRange.getStart() < n) {
                    byteRange.addRange(n, contiguousByteRange.getEnd());
                } else {
                    byteRange.addRange(contiguousByteRange);
                }
            }
            ++n2;
        }
        return byteRange;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ByteRange)) {
            return false;
        }
        ByteRange byteRange = (ByteRange)object;
        if (this.elementCount != byteRange.elementCount) {
            return false;
        }
        int n = 0;
        while (n < this.elementCount) {
            ContiguousByteRange contiguousByteRange;
            ContiguousByteRange contiguousByteRange2 = this.getNthContiguousByteRange(n);
            if (!contiguousByteRange2.equals(contiguousByteRange = byteRange.getNthContiguousByteRange(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static ByteRange getEmptyByteRange() {
        return gEmptyByteRange;
    }

    public ContiguousByteRange getEnclosingRange() {
        switch (this.elementCount) {
            case 0: {
                return null;
            }
            case 1: {
                return this.getNthContiguousByteRange(0);
            }
        }
        return new ContiguousByteRange(this.getStart(), this.getEnd());
    }

    public int getEnd() {
        return this.getNthContiguousByteRange(this.elementCount - 1).getEnd();
    }

    public ContiguousByteRange getFirstIntersection(ContiguousByteRange contiguousByteRange) {
        ContiguousByteRange contiguousByteRange2 = null;
        int n = 0;
        while (n < this.elementCount) {
            ContiguousByteRange contiguousByteRange3 = this.getNthContiguousByteRange(n);
            contiguousByteRange2 = contiguousByteRange3.intersection(contiguousByteRange);
            if (contiguousByteRange2 != null) break;
            ++n;
        }
        return contiguousByteRange2;
    }

    public int getLength() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.elementCount) {
            ContiguousByteRange contiguousByteRange = this.getNthContiguousByteRange(n2);
            n += contiguousByteRange.getLength();
            ++n2;
        }
        return n;
    }

    public ContiguousByteRange getNthContiguousByteRange(int n) {
        return (ContiguousByteRange)this.elementAt(n);
    }

    public int getStart() {
        return this.getNthContiguousByteRange(0).getStart();
    }

    public static ByteRange getUniversalByteRange() {
        return gUniversalByteRange;
    }

    public ByteRange intersect(ByteRange byteRange) {
        ByteRange byteRange2 = new ByteRange(Math.max(this.elementCount, byteRange.elementCount));
        ByteRange byteRange3 = this;
        int n = 0;
        int n2 = 0;
        while (n < byteRange3.elementCount && n2 < byteRange.elementCount) {
            ContiguousByteRange contiguousByteRange = byteRange3.getNthContiguousByteRange(n);
            ContiguousByteRange contiguousByteRange2 = byteRange.getNthContiguousByteRange(n2);
            if (contiguousByteRange.getStart() > contiguousByteRange2.getStart()) {
                ByteRange byteRange4 = byteRange3;
                byteRange3 = byteRange;
                byteRange = byteRange4;
                int n3 = n;
                n = n2;
                n2 = n3;
                ContiguousByteRange contiguousByteRange3 = contiguousByteRange;
                contiguousByteRange = contiguousByteRange2;
                contiguousByteRange2 = contiguousByteRange3;
            }
            if (contiguousByteRange.getEnd() < contiguousByteRange2.getStart()) {
                ++n;
                continue;
            }
            if (contiguousByteRange.getEnd() >= contiguousByteRange2.getEnd()) {
                byteRange2.addElement(contiguousByteRange2);
                ++n2;
                continue;
            }
            byteRange2.addElement(new ContiguousByteRange(contiguousByteRange2.getStart(), contiguousByteRange.getEnd()));
            ++n;
        }
        return byteRange2;
    }

    public boolean intersects(ByteRange byteRange) {
        return this.intersect(byteRange).getLength() != 0;
    }

    public boolean isUniversal() {
        return this.elementCount == 1 && this.getStart() == 0 && this.getEnd() == 0x7FFFFFFE;
    }

    public int numRanges() {
        return this.elementCount;
    }

    public ByteRange subtract(ByteRange byteRange) {
        ByteRange byteRange2 = new ByteRange(this);
        int n = 0;
        while (n < byteRange.elementCount) {
            ContiguousByteRange contiguousByteRange = byteRange.getNthContiguousByteRange(n);
            byteRange2.subtractRange(contiguousByteRange);
            ++n;
        }
        return byteRange2;
    }

    public ByteRange subtract(ContiguousByteRange contiguousByteRange) {
        ByteRange byteRange = new ByteRange(this);
        byteRange.subtractRange(contiguousByteRange);
        return byteRange;
    }

    private void subtractRange(int n, int n2) {
        if (this.elementCount == 0 || n2 < this.getStart() || n > this.getEnd()) {
            return;
        }
        int n3 = this.elementCount;
        while (n3-- > 0) {
            ContiguousByteRange contiguousByteRange = this.getNthContiguousByteRange(n3);
            int n4 = contiguousByteRange.getStart();
            int n5 = contiguousByteRange.getEnd();
            if (n > n5 || n2 < n4) continue;
            if (n <= n4) {
                if (n2 >= n5) {
                    this.removeElementAt(n3);
                    continue;
                }
                this.setElementAt(new ContiguousByteRange(n2 + 1, n5), n3);
                continue;
            }
            if (n2 >= n5) {
                this.setElementAt(new ContiguousByteRange(n4, n - 1), n3);
                continue;
            }
            this.setElementAt(new ContiguousByteRange(n2 + 1, n5), n3);
            this.insertElementAt(new ContiguousByteRange(n4, n - 1), n3);
        }
    }

    private void subtractRange(ContiguousByteRange contiguousByteRange) {
        if (contiguousByteRange != null) {
            this.subtractRange(contiguousByteRange.getStart(), contiguousByteRange.getEnd());
        }
    }

    public String toRangeString() {
        String string = "bytes=";
        int n = 0;
        while (n < this.elementCount) {
            ContiguousByteRange contiguousByteRange = this.getNthContiguousByteRange(n);
            if (n != 0) {
                string = String.valueOf(string) + ",";
            }
            string = String.valueOf(string) + contiguousByteRange.toString();
            ++n;
        }
        return string;
    }

    public ByteRange truncate(int n) {
        if (this.elementCount == 0 || n < 0 || this.getEnd() < n) {
            return this;
        }
        ByteRange byteRange = new ByteRange(this.elementCount);
        int n2 = 0;
        while (n2 < this.elementCount) {
            ContiguousByteRange contiguousByteRange = this.getNthContiguousByteRange(n2);
            if (contiguousByteRange.getStart() >= n) break;
            if (contiguousByteRange.getEnd() >= n) {
                byteRange.addRange(contiguousByteRange.getStart(), n - 1);
                break;
            }
            byteRange.addRange(contiguousByteRange);
            ++n2;
        }
        return byteRange;
    }

    public ByteRange union(ByteRange byteRange) {
        if (byteRange == null) {
            return this;
        }
        ByteRange byteRange2 = this;
        if (this.elementCount < byteRange.elementCount) {
            byteRange2 = byteRange;
            byteRange = this;
        }
        ByteRange byteRange3 = new ByteRange(byteRange2);
        int n = 0;
        while (n < byteRange.elementCount) {
            byteRange3.addRange(byteRange.getNthContiguousByteRange(n));
            ++n;
        }
        return byteRange3;
    }

    public ByteRange union(ContiguousByteRange contiguousByteRange) {
        if (contiguousByteRange == null) {
            return this;
        }
        ByteRange byteRange = new ByteRange(this);
        byteRange.addRange(contiguousByteRange);
        return byteRange;
    }
}

