/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.debug;

import com.adobe.acrobat.debug.ContentSelectorGrid;
import com.adobe.acrobat.pdf.ColorValue;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

class ColorSwatchCanvas
extends Canvas {
    private static final int kInset = 2;
    private static final String kNoSelectionString = "<< no selection >>";
    private static final int kSwatchHeight = 18;
    private ColorValue cv;

    ColorSwatchCanvas() {
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.getSize().width, 18);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getSize().width, 18);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        if (this.cv != null) {
            graphics.setColor(this.cv.getRGBColor());
            graphics.fillRect(2, 2, rectangle.width - 4, rectangle.height - 4);
        } else {
            graphics.setFont(ContentSelectorGrid.unknownDescFont);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.stringWidth(kNoSelectionString);
            graphics.drawString(kNoSelectionString, (rectangle.width - n) / 2, rectangle.height - 2 - fontMetrics.getMaxDescent());
        }
    }

    public void setColor(ColorValue colorValue) {
        this.cv = colorValue;
        this.repaint();
    }
}

