/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.debug;

import com.adobe.acrobat.debug.CTMView;
import com.adobe.acrobat.debug.ColorSwatchCanvas;
import com.adobe.acrobat.debug.PDFObjStoreInspector;
import com.adobe.acrobat.page.Content;
import com.adobe.acrobat.page.GState;
import com.adobe.acrobat.page.VContent;
import com.adobe.acrobat.page.VContentArray;
import com.adobe.acrobat.pdf.PDFFont;
import com.adobe.acrobat.pdf.VPDFFont;
import com.adobe.acrobat.pdfobjstore.VPDFReference;
import com.adobe.acrobat.util.Log;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import java.awt.Button;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class GStateView
extends Panel
implements VObserver,
ActionListener,
StrobeContainer {
    static Font labelFont = new Font("Helvetica", 2, 11);
    static Font valueFont = new Font("Helvetica", 0, 11);
    private VContent vContent;
    private VContentArray vContentArray;
    private ColorSwatchCanvas strokeColorSwatch;
    private ColorSwatchCanvas fillColorSwatch;
    private Label strokeColorModelLabel;
    private Label fillColorModelLabel;
    private CTMView ctmView;
    private Label fontLabel;
    private Button inspectFontButton;
    private Label strokeTypeLabel;
    private Label strokePropsLabel;
    private Label spacingLabel;
    private VStrobe strobe;

    GStateView(VContent vContent, VContentArray vContentArray) throws Exception {
        this.vContent = vContent;
        this.vContentArray = vContentArray;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        Label label = new Label("Stroke");
        label.setFont(labelFont);
        label.setAlignment(1);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        label = new Label("Fill");
        label.setFont(labelFont);
        label.setAlignment(1);
        gridBagConstraints.gridx = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        this.strokeColorSwatch = new ColorSwatchCanvas();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.strokeColorSwatch, gridBagConstraints);
        this.add(this.strokeColorSwatch);
        this.fillColorSwatch = new ColorSwatchCanvas();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.fillColorSwatch, gridBagConstraints);
        this.add(this.fillColorSwatch);
        label = new Label("Color Model:");
        label.setFont(labelFont);
        label.setAlignment(2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        this.strokeColorModelLabel = new Label("");
        this.strokeColorModelLabel.setFont(valueFont);
        this.strokeColorModelLabel.setAlignment(1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.strokeColorModelLabel, gridBagConstraints);
        this.add(this.strokeColorModelLabel);
        this.fillColorModelLabel = new Label("");
        this.fillColorModelLabel.setFont(valueFont);
        this.fillColorModelLabel.setAlignment(1);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.fillColorModelLabel, gridBagConstraints);
        this.add(this.fillColorModelLabel);
        label = new Label("CTM:");
        label.setFont(labelFont);
        label.setAlignment(2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        this.ctmView = new CTMView();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.ctmView, gridBagConstraints);
        this.add(this.ctmView);
        this.inspectFontButton = new Button("Font:");
        this.inspectFontButton.setFont(labelFont);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.inspectFontButton, gridBagConstraints);
        this.add(this.inspectFontButton);
        this.inspectFontButton.addActionListener(this);
        this.fontLabel = new Label("");
        this.fontLabel.setFont(valueFont);
        this.fontLabel.setAlignment(0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.fontLabel, gridBagConstraints);
        this.add(this.fontLabel);
        label = new Label("Stroke Type:");
        label.setFont(labelFont);
        label.setAlignment(2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        this.strokeTypeLabel = new Label("");
        this.strokeTypeLabel.setAlignment(0);
        this.strokeTypeLabel.setFont(valueFont);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.strokeTypeLabel, gridBagConstraints);
        this.add(this.strokeTypeLabel);
        label = new Label("Width:");
        label.setFont(labelFont);
        label.setAlignment(2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        this.strokePropsLabel = new Label("");
        this.strokePropsLabel.setAlignment(0);
        this.strokePropsLabel.setFont(valueFont);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.strokePropsLabel, gridBagConstraints);
        this.add(this.strokePropsLabel);
        label = new Label("Spacing:");
        label.setFont(labelFont);
        label.setAlignment(2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        this.spacingLabel = new Label("");
        this.spacingLabel.setAlignment(0);
        this.spacingLabel.setFont(valueFont);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.spacingLabel, gridBagConstraints);
        this.add(this.spacingLabel);
        this.strobe = new VStrobe(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            GState gState;
            VPDFFont vPDFFont;
            Content content;
            if (actionEvent.getSource() == this.inspectFontButton && (content = this.vContent.contentValue(null)) != null && (vPDFFont = (gState = content.getGState()).getVFont()) != null) {
                PDFFont pDFFont = vPDFFont.pdfFontValue(null);
                PDFObjStoreInspector pDFObjStoreInspector = new PDFObjStoreInspector(new VPDFReference(pDFFont.getFontRef()), new VPDFReference(this.vContentArray.contentArrayValue(null).getResources()));
                pDFObjStoreInspector.show();
            }
        }
        catch (Exception exception) {
            Log.clog("GStateView.actionPerformed: " + exception.toString());
        }
    }

    public void change(Requester requester) {
        try {
            Content content = this.vContent.contentValue(requester);
            if (content != null) {
                GState gState = content.getGState();
                this.strokeColorSwatch.setColor(gState.getStrokeColor());
                this.fillColorSwatch.setColor(gState.getFillColor());
                this.strokeColorModelLabel.setText(gState.getStrokeColor().getColorModel().toString());
                this.fillColorModelLabel.setText(gState.getFillColor().getColorModel().toString());
                this.ctmView.setCTM(gState.getCTM());
                this.strokeTypeLabel.setText(this.getStrokeTypeString(gState));
                this.strokePropsLabel.setText(this.getStrokePropsString(gState));
                this.spacingLabel.setText(this.getSpacingString(gState));
                VPDFFont vPDFFont = gState.getVFont();
                if (vPDFFont == null) {
                    this.fontLabel.setFont(labelFont);
                    this.fontLabel.setText("No font set");
                    this.inspectFontButton.setEnabled(false);
                } else {
                    PDFFont pDFFont = vPDFFont.pdfFontValue(requester);
                    this.fontLabel.setFont(valueFont);
                    this.fontLabel.setText(String.valueOf(pDFFont.getBaseName()) + " " + (double)Math.round(100.0 * gState.getFontSize()) / 100.0 + " (" + pDFFont.getSubType() + ")");
                    this.inspectFontButton.setEnabled(true);
                }
            } else {
                this.strokeColorSwatch.setColor(null);
                this.fillColorSwatch.setColor(null);
                this.strokeColorModelLabel.setText("");
                this.fillColorModelLabel.setText("");
                this.ctmView.setCTM(null);
                this.fontLabel.setText("");
                this.strokeTypeLabel.setText("");
                this.strokePropsLabel.setText("");
                this.spacingLabel.setText("");
            }
        }
        catch (Exception exception) {
            Log.clog("GStateView.change: " + exception.toString());
        }
    }

    private String getSpacingString(GState gState) {
        return "Char " + (double)Math.round(gState.getCharSpacing() * 100.0) / 100.0 + ", Word " + (double)Math.round(gState.getWordSpacing() * 100.0) / 100.0;
    }

    private String getStrokePropsString(GState gState) {
        String string = "Width " + (double)Math.round(gState.getLineWidth() * 100.0) / 100.0;
        string = String.valueOf(string) + ", Flat " + (double)Math.round(gState.getFlatness() * 100.0) / 100.0;
        string = String.valueOf(string) + ", Miter lim " + (double)Math.round(gState.getFlatness() * 100.0) / 100.0;
        return string;
    }

    private String getStrokeTypeString(GState gState) {
        String string;
        switch (gState.getLineCap()) {
            case 0: {
                string = "Butt cap, ";
                break;
            }
            case 1: {
                string = "Round cap, ";
                break;
            }
            case 2: {
                string = "Square cap, ";
                break;
            }
            default: {
                string = "??? cap, ";
            }
        }
        switch (gState.getLineJoin()) {
            case 0: {
                string = String.valueOf(string) + "Miter join";
                break;
            }
            case 1: {
                string = String.valueOf(string) + "Round join";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "Bevel join";
                break;
            }
            default: {
                string = String.valueOf(string) + "??? join";
            }
        }
        return string;
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }
}

