/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.debug;

import com.adobe.acrobat.Viewer;
import com.adobe.acrobat.bytearray.ByteRangeInputStream;
import com.adobe.acrobat.bytearray.ContiguousByteRange;
import com.adobe.acrobat.debug.ContentSelectorGrid;
import com.adobe.acrobat.debug.ContentView;
import com.adobe.acrobat.debug.GStateView;
import com.adobe.acrobat.debug.PDFStreamInspector;
import com.adobe.acrobat.page.Content;
import com.adobe.acrobat.page.VContent;
import com.adobe.acrobat.page.VContentArray;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.vtypes.VAffineTransform;
import com.adobe.acrobat.vtypes.VFloatRect;
import com.adobe.pe.awt.PEFrame;
import com.adobe.pe.awt.ScrollerLogic;
import com.adobe.pe.awt.VScrollPane;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.util.StreamFactory;
import com.adobe.pe.vtypes.VInt;
import com.adobe.pe.vtypes.VStreamFactory;
import com.adobe.util.ImageUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;

public class PDFContentInspector
extends PEFrame {
    private PDFReference ref;
    private VContentArray vContent;
    private ContentSelectorGrid contentSelector;
    private GStateView gStateView;
    private ContentView contentView;
    private VInt vSelectionIndex;
    private VContent vContentObj;
    private VStreamFactory vStreamFactory;
    private static final String Page_K = "Page";
    private static final String XObject_K = "XObject";
    private static final String Form_K = "Form";

    public PDFContentInspector(VContentArray vContentArray, VFloatRect vFloatRect, VAffineTransform vAffineTransform, VStreamFactory vStreamFactory) throws Exception {
        super("Contents Inspector", true);
        this.ref = this.ref;
        this.vContent = vContentArray;
        this.vStreamFactory = vStreamFactory;
        this.setLayout(new GridLayout(2, 2));
        ((Component)this).setBounds(0, 0, 500, 500);
        ((Component)this).setLocation(10, 300);
        ((Component)this).setVisible(true);
        this.vSelectionIndex = new VInt(-1);
        this.vContentObj = new VInspectedContent();
        this.contentSelector = new ContentSelectorGrid(vContentArray, this.vSelectionIndex);
        ScrollerLogic scrollerLogic = new ScrollerLogic(null, this.contentSelector.vHeight, -1, -1);
        VScrollPane vScrollPane = new VScrollPane(scrollerLogic, this.contentSelector);
        vScrollPane.setBackground(Color.white);
        this.add(vScrollPane);
        this.contentView = new ContentView(vFloatRect, vAffineTransform, vContentArray, this.vSelectionIndex);
        this.add(this.contentView);
        this.gStateView = new GStateView(this.vContentObj, vContentArray);
        this.add(this.gStateView);
        PDFStreamInspector pDFStreamInspector = new PDFStreamInspector(new VContentStream(), null);
        this.add(pDFStreamInspector);
        Viewer.registerViewerWindow(this);
        ImageUtil.registerRootComponent(this);
        this.addWindowListener(new MyWindowAdapter());
    }

    class VContentStream
    extends VStreamFactory {
        VContentStream() {
        }

        protected final StreamFactory computeStreamFactory(Requester requester) throws Exception {
            Content content = PDFContentInspector.this.vContentObj.contentValue(requester);
            if (content == null) {
                return null;
            }
            StreamFactory streamFactory = PDFContentInspector.this.vStreamFactory.streamFactoryValue(requester);
            SubstreamFactory substreamFactory = new SubstreamFactory(streamFactory, content.streamStart, content.streamEnd);
            return substreamFactory;
        }

        class SubstreamFactory
        extends StreamFactory {
            private ContiguousByteRange br;
            private StreamFactory completeStream;

            SubstreamFactory(StreamFactory streamFactory, int n, int n2) {
                this.br = new ContiguousByteRange(n, n2);
                this.completeStream = streamFactory;
            }

            public InputStream getInputStream() throws Exception {
                InputStream inputStream = this.completeStream.getInputStream();
                long l = this.br.getStart();
                while (l > 0L) {
                    long l2 = inputStream.skip(l);
                    if (l2 <= 0L) break;
                    l -= l2;
                }
                return new ByteRangeInputStream(inputStream, this.br);
            }
        }
    }

    class VInspectedContent
    extends VContent {
        VInspectedContent() {
        }

        protected final Content computeContent(Requester requester) throws Exception {
            int n = PDFContentInspector.this.vSelectionIndex.intValue(requester);
            if (n == -1) {
                return null;
            }
            return PDFContentInspector.this.vContent.contentArrayValue(requester).nthContent(n);
        }
    }

    class MyWindowAdapter
    extends WindowAdapter {
        MyWindowAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ImageUtil.unregisterRootComponent(PDFContentInspector.this);
            Viewer.unregisterViewerWindow(PDFContentInspector.this);
        }
    }
}

