/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.debug;

import com.adobe.acrobat.pdfobjstore.PDFIndirectObj;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.VPDFObj;
import com.adobe.acrobat.util.Log;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;

class PDFReferenceInfoPanel
extends Panel
implements VObserver,
StrobeContainer {
    private Label idLabel;
    private Label genLabel;
    private Label typeLabel;
    private VStrobe strobe;
    private VPDFObj vObj;

    PDFReferenceInfoPanel(VPDFObj vPDFObj) throws Exception {
        this.vObj = vPDFObj;
        this.setLayout(new GridLayout(1, 3));
        Font font = new Font("Helvetica", 1, 11);
        this.idLabel = new Label();
        this.idLabel.setVisible(false);
        this.idLabel.setFont(font);
        this.add(this.idLabel);
        this.genLabel = new Label();
        this.genLabel.setVisible(false);
        this.genLabel.setFont(font);
        this.add(this.genLabel);
        Font font2 = new Font("Helvetica", 2, 9);
        this.typeLabel = new Label();
        this.typeLabel.setFont(font2);
        this.add(this.typeLabel);
        this.strobe = new VStrobe(this);
    }

    public void change(Requester requester) {
        try {
            PDFObj pDFObj = this.vObj.pdfObjValue(requester);
            if (pDFObj instanceof PDFIndirectObj) {
                PDFIndirectObj pDFIndirectObj = (PDFIndirectObj)pDFObj;
                this.idLabel.setText("ID: " + pDFIndirectObj.getID());
                this.genLabel.setText("Gen: " + pDFIndirectObj.getGeneration());
                this.idLabel.setVisible(true);
                this.genLabel.setVisible(true);
            } else {
                this.idLabel.setVisible(false);
                this.genLabel.setVisible(false);
            }
            int n = pDFObj.type(requester);
            this.typeLabel.setText(PDFReferenceInfoPanel.typeToString(n));
            this.validate();
        }
        catch (Exception exception) {
            Log.clog("PDFReferenceInfoPanel.change " + exception.toString());
        }
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }

    static String typeToString(int n) {
        switch (n) {
            case 2: {
                return "Integer";
            }
            case 3: {
                return "Real";
            }
            case 4: {
                return "String";
            }
            case 5: {
                return "Name";
            }
            case 0: {
                return "Null";
            }
            case 1: {
                return "Boolean";
            }
            case 6: {
                return "Dictionary";
            }
            case 7: {
                return "Array";
            }
        }
        return "???";
    }
}

