/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.file;

import com.adobe.acrobat.file.ByteArraySource;
import com.adobe.acrobat.file.ByteArraySourceSpace;
import com.adobe.acrobat.file.FileByteArraySource;
import com.adobe.acrobat.gui.ReaderPrefs;
import java.io.File;

public class FileByteArraySourceSpace
extends ByteArraySourceSpace {
    public static final String Mac_K = "Mac";
    private static final String MAC_K = "MAC";
    public static final String DOS_K = "DOS";
    private static final String WIN_K = "WIN";
    public static final String Unix_K = "Unix";
    private String spaceName;

    public FileByteArraySourceSpace(String string) {
        this.spaceName = string;
    }

    public static ByteArraySource createFileByteArraySource(File file) {
        return new FileByteArraySource(file);
    }

    public static ByteArraySource createFileByteArraySource(String string) {
        return new FileByteArraySource(new File(string));
    }

    public ByteArraySource getByteArraySourceAbsolute(String string) throws Exception {
        return FileByteArraySourceSpace.createFileByteArraySource(String.valueOf(File.separator) + ByteArraySourceSpace.toPlatformString(string, File.separatorChar));
    }

    public ByteArraySource getByteArraySourceRelative(String string, String string2) throws Exception {
        if (string == null || string2.length() > 0 && string2.charAt(0) == '/') {
            return this.getByteArraySourceAbsolute(string2);
        }
        int n = string.lastIndexOf(File.separatorChar);
        string = n < 0 ? "" : string.substring(0, n + 1);
        while (string2.length() >= 3 && string2.substring(0, 3).equals("../")) {
            string2 = string2.substring(3);
            n = string.lastIndexOf(File.separatorChar, string.length() - 1);
            string = n < 0 ? "" : string.substring(0, n + 1);
        }
        return FileByteArraySourceSpace.createFileByteArraySource(String.valueOf(string) + ByteArraySourceSpace.toPlatformString(string2, File.separatorChar));
    }

    public String getFileSpace() {
        return this.spaceName;
    }

    public static void init() {
        String string = Unix_K;
        if (ReaderPrefs.fSystemOSName != null && ReaderPrefs.fSystemOSName.length() >= 3 && ReaderPrefs.fSystemOSName.substring(0, 3).toUpperCase().equals(MAC_K)) {
            string = Mac_K;
        } else if (File.separatorChar == '\\' || ReaderPrefs.fSystemOSName != null && ReaderPrefs.fSystemOSName.length() >= 3 && ReaderPrefs.fSystemOSName.substring(0, 3).toUpperCase().equals(WIN_K)) {
            string = DOS_K;
        }
        ByteArraySourceSpace.defaultSourceSpace = new FileByteArraySourceSpace(string);
        ByteArraySourceSpace.registerByteArraySourceSpace(string, ByteArraySourceSpace.defaultSourceSpace);
    }
}

