/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.filters;

import com.adobe.acrobat.filters.DecodeInputStream;
import com.adobe.acrobat.filters.FilterDataFormatException;
import com.adobe.acrobat.filters.FilterParams;
import java.io.InputStream;

public class ASCII85InputStream
extends DecodeInputStream {
    private static final int WS = 85;
    private static final int ZZ = 86;
    private static final int ED = 87;
    private static final int IL = 88;
    private static byte[] asc85DecodeTable = new byte[128];
    private static long[] M085;
    private static int[] M185;
    private static int[] M285;
    private static short[] M385;
    private int[] digit = new int[5];
    private int value;
    private int valIndex;
    private int d0;
    private int d1;
    private int d2;
    private int d3;
    private int d4;
    private boolean localEOF;

    static {
        int n = 0;
        while (n < 128) {
            switch ((char)n) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    ASCII85InputStream.asc85DecodeTable[n] = 85;
                    break;
                }
                case 'z': {
                    ASCII85InputStream.asc85DecodeTable[n] = 86;
                    break;
                }
                case '~': {
                    ASCII85InputStream.asc85DecodeTable[n] = 87;
                    break;
                }
                default: {
                    ASCII85InputStream.asc85DecodeTable[n] = n >= 33 && n <= 117 ? (int)(n - 33) : 88;
                    break;
                }
            }
            ++n;
        }
        M085 = new long[85];
        M185 = new int[85];
        M285 = new int[85];
        M385 = new short[85];
        short s = 0;
        int n2 = 85;
        int n3 = 0;
        int n4 = n2 * 85;
        int n5 = 0;
        int n6 = n4 * 85;
        long l = 0L;
        long l2 = (long)n6 * 85L;
        int n7 = 0;
        while (n7 < 85) {
            ASCII85InputStream.M085[n7] = l;
            l += l2;
            ASCII85InputStream.M185[n7] = n5;
            n5 += n6;
            ASCII85InputStream.M285[n7] = n3;
            n3 += n4;
            ASCII85InputStream.M385[n7] = s;
            s = (short)(s + n2);
            ++n7;
        }
    }

    public ASCII85InputStream(InputStream inputStream) {
        this(inputStream, null);
    }

    public ASCII85InputStream(InputStream inputStream, int n, int n2, FilterParams filterParams) {
        super(inputStream, n, n2, 4, filterParams);
    }

    public ASCII85InputStream(InputStream inputStream, FilterParams filterParams) {
        super(inputStream, 4, filterParams);
    }

    public void fill() {
        block12: while (this.outCount <= this.outBuf.length - 4 && !this.pendingEOF && this.pendingException == null) {
            this.digit[4] = 0;
            this.digit[3] = 0;
            this.digit[2] = 0;
            this.digit[1] = 0;
            this.digit[0] = 0;
            int n = 0;
            block13: while (n < 5) {
                int n2;
                int n3;
                if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
                    this.pendingException = new FilterDataFormatException("Asc85 missing EOF");
                    break block12;
                }
                if ((n3 = asc85DecodeTable[n2 = this.inBuf[this.inPos++] & 0x7F]) < 85) {
                    this.digit[n++] = n3;
                    continue;
                }
                switch (n3) {
                    case 86: {
                        if (n != 0) {
                            this.pendingException = new FilterDataFormatException("Asc85 misaligned 'z'");
                            break block13;
                        }
                        n = 5;
                        break block13;
                    }
                    case 87: {
                        if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
                            this.pendingException = new FilterDataFormatException("Asc85 missing final '>'");
                            break block13;
                        }
                        if ((n2 = this.inBuf[this.inPos++] & 0xFF) != 62) {
                            this.pendingException = new FilterDataFormatException("Asc85 missing final '>'");
                        }
                        this.pendingEOF = true;
                        break block13;
                    }
                    default: {
                        this.pendingException = new FilterDataFormatException("Asc85 illegal char");
                        break block13;
                    }
                    case 85: {
                        continue block13;
                    }
                }
            }
            long l = M085[this.digit[0]] + (long)M185[this.digit[1]] + (long)M285[this.digit[2]] + (long)M385[this.digit[3]] + (long)this.digit[4];
            if (l > 0xFFFFFFFFL) {
                this.pendingException = new FilterDataFormatException("Asc85 pentet overflow");
                n = 0;
            }
            switch (n) {
                case 5: {
                    this.outBuf[this.outCount++] = (byte)(l >>> 24);
                    this.outBuf[this.outCount++] = (byte)(l >>> 16);
                    this.outBuf[this.outCount++] = (byte)(l >>> 8);
                    this.outBuf[this.outCount++] = (byte)l;
                    break;
                }
                case 4: {
                    this.outBuf[this.outCount++] = (byte)((l += 255L) >>> 24);
                    this.outBuf[this.outCount++] = (byte)(l >>> 16);
                    this.outBuf[this.outCount++] = (byte)(l >>> 8);
                    break;
                }
                case 3: {
                    this.outBuf[this.outCount++] = (byte)((l += 65535L) >>> 24);
                    this.outBuf[this.outCount++] = (byte)(l >>> 16);
                    break;
                }
                case 1: {
                    this.pendingException = new FilterDataFormatException("Asc85 short pentet");
                }
                case 2: {
                    this.outBuf[this.outCount++] = (byte)((l += 0xFFFFFFL) >>> 24);
                    break;
                }
            }
        }
    }
}

