/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.filters;

import com.adobe.acrobat.filters.DecodeInputStream;
import com.adobe.acrobat.filters.FilterDataFormatException;
import com.adobe.acrobat.filters.FilterParams;
import java.io.InputStream;

public class ASCIIHexInputStream
extends DecodeInputStream {
    private static final byte WS = 85;
    private static final byte ED = 87;
    private static final byte IL = 88;
    private static byte[] ascHxDecodeTable = new byte[128];

    static {
        int n = 0;
        while (n < 128) {
            switch ((char)n) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    ASCIIHexInputStream.ascHxDecodeTable[n] = 85;
                    break;
                }
                case '>': {
                    ASCIIHexInputStream.ascHxDecodeTable[n] = 87;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ASCIIHexInputStream.ascHxDecodeTable[n] = (byte)(n - 48);
                    break;
                }
                case 'A': 
                case 'a': {
                    ASCIIHexInputStream.ascHxDecodeTable[n] = 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    ASCIIHexInputStream.ascHxDecodeTable[n] = 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    ASCIIHexInputStream.ascHxDecodeTable[n] = 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    ASCIIHexInputStream.ascHxDecodeTable[n] = 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    ASCIIHexInputStream.ascHxDecodeTable[n] = 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    ASCIIHexInputStream.ascHxDecodeTable[n] = 15;
                    break;
                }
                default: {
                    ASCIIHexInputStream.ascHxDecodeTable[n] = 88;
                    break;
                }
            }
            ++n;
        }
    }

    public ASCIIHexInputStream(InputStream inputStream) {
        this(inputStream, null);
    }

    public ASCIIHexInputStream(InputStream inputStream, int n, int n2, FilterParams filterParams) {
        super(inputStream, n, n2, 1, filterParams);
    }

    public ASCIIHexInputStream(InputStream inputStream, FilterParams filterParams) {
        super(inputStream, 1, filterParams);
    }

    public void fill() {
        block4: while (this.outCount <= this.outBuf.length - 1 && !this.pendingEOF && this.pendingException == null) {
            int n = 0;
            int n2 = 4;
            block5: while (n2 >= 0) {
                int n3;
                byte by;
                if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
                    this.pendingException = new FilterDataFormatException("AscHx missing EOF");
                    break block4;
                }
                if ((by = ascHxDecodeTable[n3 = this.inBuf[this.inPos++] & 0x7F]) < 16) {
                    n += by << n2;
                    n2 -= 4;
                    continue;
                }
                switch (by) {
                    case 87: {
                        if (n2 != 0) {
                            this.pendingException = new FilterDataFormatException("AscHx odd number of nybbles");
                        }
                        this.pendingEOF = true;
                        break block5;
                    }
                    default: {
                        this.pendingException = new FilterDataFormatException("AscHx illegal char");
                        break block5;
                    }
                    case 85: {
                        continue block5;
                    }
                }
            }
            this.outBuf[this.outCount++] = (byte)n;
        }
    }
}

