/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.BasicDialog;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.util.QuickSort;
import com.adobe.acrobat.util.Session;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.BaseDialog;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import netscape.security.PrivilegeManager;

public class AboutDialog
extends BaseDialog {
    Panel p = new Panel();
    Font f0 = new Font("SanSerif", 0, 12);
    FontMetrics fm0 = Toolkit.getDefaultToolkit().getFontMetrics(this.f0);
    Font f1 = new Font("SanSerif", 0, 17);
    FontMetrics fm1 = Toolkit.getDefaultToolkit().getFontMetrics(this.f1);
    Font f2 = new Font("SanSerif", 1, 21);
    FontMetrics fm2 = Toolkit.getDefaultToolkit().getFontMetrics(this.f2);
    int LM = 80;
    Label c = new Label("Credits...", 0);
    Image image;
    final int ENG = 0;
    final int QA = 1;
    final int MARKET = 2;
    final int MANAGE = 3;
    int credits = -1;
    boolean international = false;
    private Button system;
    private Frame frame;
    private SystemInfo systemInfo;

    public AboutDialog(Frame frame) {
        super(frame, "About Adobe\u00ae Acrobat\u00ae Viewer", true);
        this.frame = frame;
        this.setLayout(null);
        this.international = Util.hasInternationalFonts();
        this.add(this.ok);
        this.add(this.c);
        this.c.setForeground(Color.blue);
        this.c.addMouseListener(this);
        this.c.addKeyListener(this);
        this.addKeyListener(this);
        this.image = Util.getMyImage("icons/default/icon32.gif");
        Util.waitForImage(this, this.image);
        this.system = new Button("System Info");
        this.system.addActionListener(this);
        this.system.addKeyListener(this);
        this.add(this.system);
        this.systemInfo = new SystemInfo();
        this.setResizable(false);
        ((Component)this).setSize(517, 467);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.system) {
            this.systemInfo.setVisible(true);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void doLayout() {
        this.ok.setBounds(395, 385, 90, 30);
        this.system.setBounds(395, 415, 90, 30);
        this.c.setBounds(this.LM, 295, this.fm0.stringWidth("Credits...") + 20, this.fm0.getHeight() + 10);
    }

    private void draw3DString(Graphics graphics, String string, int n, int n2) {
        graphics.setColor(((Component)this).getBackground().brighter());
        graphics.drawString(string, n, n2);
        graphics.setColor(((Component)this).getBackground().darker());
        graphics.drawString(string, n - 1, n2 - 1);
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (keyEvent.getSource() == this.system) {
            if (n == 10 || n == 32) {
                this.systemInfo.setVisible(true);
                keyEvent.consume();
            }
        } else {
            super.keyReleased(keyEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.c) {
            this.credits = this.credits > 3 ? 0 : this.credits + 1;
            this.c.setText(this.credits >= 0 && this.credits <= 3 ? "Next..." : "Credits...");
            this.repaint();
        } else {
            super.mouseClicked(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.c) {
            this.c.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            super.mouseEntered(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.c) {
            this.c.setCursor(Cursor.getDefaultCursor());
        } else {
            super.mouseExited(mouseEvent);
        }
    }

    protected void ok() {
        this.cancel();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.setFont(this.f1);
        this.draw3DString(graphics, "Adobe Systems, Inc.", this.LM + 20, 120);
        graphics.setColor(Color.black);
        graphics.setFont(this.f2);
        graphics.drawString("Adobe\u00ae Acrobat\u00ae Viewer", this.LM, 130 + this.fm2.getHeight());
        graphics.setFont(this.f0);
        int n = this.fm0.getHeight();
        graphics.drawString("Version: " + "1,0,0,1999-12-1".replace(',', '.'), this.LM, 230);
        graphics.drawString("Date:Thu Dec 02 09:20:29 PST 1999", this.LM, 230 + n);
        graphics.setColor(((Component)this).getBackground());
        graphics.drawImage(this.image, this.LM - 30, 90, 32, 32, null);
        graphics.setColor(Color.black);
        int n2 = 310;
        if (this.credits == 0) {
            graphics.drawString("Authors:", this.LM + 80, n2);
            graphics.setColor(((Component)this).getBackground().darker().darker());
            graphics.drawString("Gordon Dow", this.LM + 90, n2 + n);
            graphics.drawString("Shahram Javey", this.LM + 90, n2 + n * 2);
            graphics.drawString("Marc Kaufman", this.LM + 90, n2 + n * 3);
            graphics.drawString("Peter Merrill", this.LM + 90, n2 + n * 4);
            graphics.drawString("Seetharaman Narayanan", this.LM + 90, n2 + n * 5);
        } else if (this.credits == 1) {
            graphics.drawString("Quality Assurance:", this.LM + 80, n2);
            graphics.setColor(((Component)this).getBackground().darker().darker());
            graphics.drawString("Greg Christopher", this.LM + 90, n2 + n);
            graphics.drawString("Alex Grossman", this.LM + 90, n2 + n * 2);
            graphics.drawString("Christopher Eastwood", this.LM + 90, n2 + n * 3);
            graphics.drawString("Richard Jensen", this.LM + 90, n2 + n * 4);
            graphics.drawString("Joyce Yujun Liu", this.LM + 90, n2 + n * 5);
            graphics.drawString("K.L. Seh", this.LM + 90, n2 + n * 6);
            graphics.drawString("Ngoc Sy Tran", this.LM + 90, n2 + n * 7);
            graphics.drawString("Emily Tsao", this.LM + 90, n2 + n * 8);
        } else if (this.credits == 2) {
            graphics.drawString("Marketing:", this.LM + 80, n2);
            graphics.setColor(((Component)this).getBackground().darker().darker());
            graphics.drawString("David Baskerville", this.LM + 90, n2 + n);
            graphics.drawString("Brian Lawley", this.LM + 90, n2 + n * 2);
            graphics.drawString("David Lehr", this.LM + 90, n2 + n * 3);
        } else if (this.credits == 3) {
            graphics.drawString("Management:", this.LM + 80, n2);
            graphics.setColor(((Component)this).getBackground().darker().darker());
            graphics.drawString("Ken Anderson", this.LM + 90, n2 + n);
            graphics.drawString("Greg Hansen", this.LM + 90, n2 + n * 2);
            graphics.drawString("Bob Wulff", this.LM + 90, n2 + n * 3);
        }
    }

    public class SystemInfo
    extends BasicDialog {
        private TextArea list;
        private Properties props;

        public SystemInfo() {
            super(AboutDialog.this.frame, "System Information", true);
            this.setLayout(new BorderLayout(5, 5));
            this.props = new Properties();
            this.list = new TextArea(25, 55);
            Panel panel = new Panel(new BorderLayout());
            panel.add((Component)this.list, "Center");
            this.add((Component)panel, "North");
            this.add((Component)this.okCancelPanel, "South");
            this.cancel.setVisible(false);
            this.populate();
            this.addToList();
            this.pack();
        }

        private void addToList() {
            String[] stringArray = new String[((Hashtable)this.props).size()];
            int n = 0;
            Enumeration enumeration = ((Hashtable)this.props).keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = this.props.getProperty(string);
                stringArray[n++] = String.valueOf(string) + "=" + string2;
            }
            try {
                QuickSort.sort(stringArray, 0, stringArray.length - 1);
            }
            catch (Exception exception) {}
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.list.append(String.valueOf(stringArray[n2]) + "\n");
                ++n2;
            }
            this.list.setEditable(false);
        }

        private void populate() {
            Session session = Session.getTheSession();
            if (session.isIE()) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            } else if (session.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
            }
            Properties properties = System.getProperties();
            Runtime runtime = Runtime.getRuntime();
            String string = "Not Known";
            ((Hashtable)this.props).put("java.version", properties.getProperty("java.version", string));
            ((Hashtable)this.props).put("java.vendor", properties.getProperty("java.vendor", string));
            ((Hashtable)this.props).put("java.vendor.url", properties.getProperty("java.vendor.url", string));
            ((Hashtable)this.props).put("java.class.version", properties.getProperty("java.class.version", string));
            ((Hashtable)this.props).put("java.class.path", properties.getProperty("java.class.path", string));
            ((Hashtable)this.props).put("java.home", properties.getProperty("java.home", string));
            ((Hashtable)this.props).put("java.compiler", properties.getProperty("java.compiler", string));
            ((Hashtable)this.props).put("java.freeMemory", String.valueOf(String.valueOf(runtime.freeMemory())) + " bytes");
            ((Hashtable)this.props).put("java.totalMemory", String.valueOf(String.valueOf(runtime.totalMemory())) + " bytes");
            ((Hashtable)this.props).put("user.home - location of acrobat.properties", properties.getProperty("user.home", string));
            ((Hashtable)this.props).put("user.dir", properties.getProperty("user.dir", string));
            ((Hashtable)this.props).put("user.language", properties.getProperty("user.language", string));
            ((Hashtable)this.props).put("user.region", properties.getProperty("user.region", string));
            ((Hashtable)this.props).put("user.timezone", properties.getProperty("user.timezone", string));
            ((Hashtable)this.props).put("ftpProxyHost", ReaderPrefs.fFtpProxyHost_system);
            ((Hashtable)this.props).put("ftpProxyPort", ReaderPrefs.fFtpProxyPort_system);
            ((Hashtable)this.props).put("ftpProxySet", ReaderPrefs.fFtpProxySet_system ? "true" : "false");
            ((Hashtable)this.props).put("http.nonProxyHosts", ReaderPrefs.fHttpNonProxyHosts_system);
            ((Hashtable)this.props).put("http.proxyHost", ReaderPrefs.fHttpProxyHost_system);
            ((Hashtable)this.props).put("http.proxyPort", ReaderPrefs.fHttpProxyPort_system);
            ((Hashtable)this.props).put("os.name", properties.getProperty("os.name", string));
            ((Hashtable)this.props).put("os.arch", properties.getProperty("os.arch", string));
            ((Hashtable)this.props).put("os.version", properties.getProperty("os.version", string));
        }

        public void setVisible(boolean bl) {
            if (bl) {
                AboutDialog.this.setVisible(bl ^ true);
            }
            super.setVisible(bl);
        }
    }
}

