/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AnnotBorderPainting;
import com.adobe.acrobat.gui.HilitePainting;
import com.adobe.acrobat.gui.Ornament;
import com.adobe.acrobat.gui.OrnamentSizingStrategy;
import com.adobe.acrobat.gui.VisiblePage;
import com.adobe.acrobat.pdf.AnnotBorderProps;
import com.adobe.acrobat.pdf.AppearancePainting;
import com.adobe.acrobat.pdf.VAnnotBorderProps;
import com.adobe.acrobat.pdf.VAnnotBoundingBox;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatPoint;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.pe.awt.VRectangle;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.VValue;
import com.adobe.pe.painting.Painting;
import com.adobe.pe.painting.PaintingChain;
import com.adobe.pe.painting.TranslatedPainting;
import com.adobe.pe.painting.VPainting;
import com.adobe.pe.vtypes.VInt;
import java.awt.Rectangle;
import java.util.Dictionary;

public abstract class AnnotView
extends Ornament
implements OrnamentSizingStrategy {
    public static final int INVISIBLE = 1;
    public static final int HIDDEN = 2;
    public static final int PRINT = 4;
    public static final int NOZOOM = 8;
    public static final int NOROTATE = 16;
    public static final int NOVIEW = 32;
    public static final int READONLY = 64;
    public static final String F_K = "F";
    protected boolean hasAppearances = false;
    protected boolean hasRollOverAppearance = false;
    protected VRectangle vBounds;
    protected VAnnotRectangle vAnnotRect;
    protected VPainting vPainting = null;
    public static final String AS_K = "AS";
    public static final String AP_K = "AP";
    public static final String R_K = "R";
    public static final String N_K = "N";
    public static final String D_K = "D";
    public static final String H_K = "H";
    public static final String O_K = "O";
    public static final String I_K = "I";
    public static final String P_K = "P";
    private String lastAppearanceType = "";
    private FloatRect lastBounds;
    private AffineTransform lastTransform;
    private Painting lastAppearancePainting = null;
    protected String subtype;
    protected PDFReference annotRef;
    protected VisiblePage vp;
    protected VFlags vFlags;

    public AnnotView(VisiblePage visiblePage, String string, PDFReference pDFReference, Requester requester) throws Exception {
        super(visiblePage.pv);
        this.vp = visiblePage;
        this.subtype = string;
        this.annotRef = pDFReference;
        this.vAnnotRect = new VAnnotRectangle();
        PDFDict pDFDict = pDFReference.dictValue(requester);
        this.hasAppearances = pDFDict.hasKey(AP_K);
        if (this.hasAppearances) {
            PDFDict pDFDict2 = pDFDict.get(AP_K).dictValue(requester);
            this.hasRollOverAppearance = pDFDict2.hasKey(R_K);
        }
    }

    protected Rectangle annotBoundsDeviceSpace(Requester requester) throws Exception {
        return this.vAnnotRect.annotBoundsDeviceSpace(requester);
    }

    protected FloatRect annotBoundsUserSpace(Requester requester) throws Exception {
        return this.vAnnotRect.annotBoundsUserSpace(requester);
    }

    protected AffineTransform annotTransform(Requester requester) throws Exception {
        return this.vAnnotRect.annotTransform(requester);
    }

    protected Dictionary createActionParamsDictionary(Requester requester) throws Exception {
        Dictionary dictionary = this.vp.createActionParamsDictionary(requester);
        dictionary.put("Annot", this.annotRef);
        return dictionary;
    }

    protected Painting createAppearancePainting(Requester requester, String string) throws Exception {
        boolean bl;
        PDFDict pDFDict = this.annotRef.dictValue(requester);
        boolean bl2 = bl = pDFDict.hasKey(AP_K) && !this.getFlag(32, requester);
        if (bl) {
            FloatRect floatRect = this.annotBoundsUserSpace(requester);
            AffineTransform affineTransform = this.annotTransform(requester);
            if (string.equals(this.lastAppearanceType) && floatRect.equals(this.lastBounds) && affineTransform.equals(this.lastTransform)) {
                return this.lastAppearancePainting;
            }
            PDFDict pDFDict2 = pDFDict.get(AP_K).dictValue(requester);
            PDFReference pDFReference = null;
            if (pDFDict2.hasKey(string)) {
                pDFReference = pDFDict2.get(string).pdfReferenceValue(requester);
            } else if (pDFDict2.hasKey(N_K)) {
                pDFReference = pDFDict2.get(N_K).pdfReferenceValue(requester);
            }
            if (pDFReference != null && pDFDict.hasKey(AS_K)) {
                String string2 = pDFDict.get(AS_K).nameValue(requester);
                pDFDict2 = pDFReference.dictValue(requester);
                if (!pDFDict2.hasKey(string2)) {
                    return null;
                }
                pDFReference = pDFDict2.get(string2).pdfReferenceValue(requester);
            }
            if (pDFReference != null) {
                this.lastAppearanceType = string;
                this.lastBounds = floatRect;
                this.lastTransform = affineTransform;
                this.lastAppearancePainting = new AppearancePainting(affineTransform, floatRect, pDFReference, requester);
                return this.lastAppearancePainting;
            }
        }
        return null;
    }

    protected Painting createBorderPainting(Requester requester, boolean bl) throws Exception {
        FloatRect floatRect = this.annotBoundsUserSpace(requester);
        AffineTransform affineTransform = this.annotTransform(requester);
        VAnnotBorderProps vAnnotBorderProps = VAnnotBorderProps.getVAnnotBorderProps(this.annotRef);
        AnnotBorderProps annotBorderProps = vAnnotBorderProps.annotBorderPropsValue(requester);
        if (affineTransform == null || annotBorderProps == null || annotBorderProps.borderWidth == 0.0) {
            return null;
        }
        AnnotBorderPainting annotBorderPainting = new AnnotBorderPainting(affineTransform, floatRect, annotBorderProps, bl);
        return annotBorderPainting;
    }

    protected Painting createPainting(Requester requester, boolean bl) throws Exception {
        if (this.getFlag(2, requester)) {
            return null;
        }
        Painting painting = null;
        if (bl) {
            PDFDict pDFDict = this.annotRef.dictValue(requester);
            String string = I_K;
            if (pDFDict.hasKey(H_K)) {
                string = pDFDict.get(H_K).nameValue(requester);
            }
            if (string.equals(P_K)) {
                PDFDict pDFDict2;
                boolean bl2;
                boolean bl3 = bl2 = pDFDict.hasKey(AP_K) && !this.getFlag(32, requester);
                if (bl2 && (pDFDict2 = pDFDict.get(AP_K).dictValue(requester)).hasKey(D_K)) {
                    return this.createAppearancePainting(requester, D_K);
                }
                painting = this.createUnhilitPainting(requester);
                if (painting != null) {
                    return new TranslatedPainting(painting, 5, 5);
                }
                return null;
            }
            if (string.equals(N_K)) {
                return this.createUnhilitPainting(requester);
            }
            if (string.equals(O_K)) {
                return this.createBorderPainting(requester, true);
            }
            painting = this.createUnhilitPainting(requester);
            FloatRect floatRect = this.annotBoundsUserSpace(requester);
            AffineTransform affineTransform = this.annotTransform(requester);
            HilitePainting hilitePainting = new HilitePainting(affineTransform, floatRect);
            if (painting != null) {
                return new PaintingChain(hilitePainting, painting);
            }
            return hilitePainting;
        }
        return this.createUnhilitPainting(requester);
    }

    protected Painting createUnhilitPainting(Requester requester) throws Exception {
        Object object;
        String string = N_K;
        if (this.hasRollOverAppearance && (object = this.pv.getHoveredOverOrnament(requester)) == this) {
            string = R_K;
        }
        if ((object = this.createAppearancePainting(requester, string)) == null) {
            object = this.createBorderPainting(requester, false);
        }
        return object;
    }

    public int getAnchor(Requester requester) throws Exception {
        return 0;
    }

    protected boolean getFlag(int n, Requester requester) throws Exception {
        if (this.vFlags == null) {
            this.vFlags = new VFlags();
        }
        return (this.vFlags.intValue(requester) & n) != 0;
    }

    public FloatPoint getOrnamentPosition(Requester requester) throws Exception {
        FloatRect floatRect = this.getOrnamentRect(requester);
        return new FloatPoint(floatRect.getxMin(), floatRect.getyMax());
    }

    public FloatRect getOrnamentRect(Requester requester) throws Exception {
        FloatRect floatRect = this.sizeInUserSpace(requester) ? this.annotBoundsUserSpace(requester) : new FloatRect(this.getVBounds().rectangleValue(requester));
        return floatRect;
    }

    public FloatPoint getOrnamentSize(Requester requester) throws Exception {
        FloatRect floatRect = this.getOrnamentRect(requester);
        return new FloatPoint(floatRect.width(), floatRect.height());
    }

    public VRectangle getVBounds() {
        if (this.vBounds == null) {
            this.vBounds = new VAnnotDeviceRect();
        }
        return this.vBounds;
    }

    public VPainting getVPainting() {
        if (this.vPainting == null) {
            this.vPainting = new VAnnotViewPainting();
        }
        return this.vPainting;
    }

    public boolean partOfContents(Requester requester) throws Exception {
        return true;
    }

    public boolean sizeInUserSpace(Requester requester) throws Exception {
        return true;
    }

    class VAnnotDeviceRect
    extends VRectangle {
        VAnnotDeviceRect() {
        }

        protected final Rectangle computeRectangle(Requester requester) throws Exception {
            return AnnotView.this.annotBoundsDeviceSpace(requester);
        }
    }

    class VAnnotRectangle
    extends VValue {
        private FloatRect rawBounds;
        private Rectangle deviceBounds;
        AffineTransform transform;

        VAnnotRectangle() {
        }

        public Rectangle annotBoundsDeviceSpace(Requester requester) throws Exception {
            this.handleRequest(requester);
            return this.deviceBounds;
        }

        public FloatRect annotBoundsUserSpace(Requester requester) throws Exception {
            this.handleRequest(requester);
            return this.rawBounds;
        }

        public AffineTransform annotTransform(Requester requester) throws Exception {
            this.handleRequest(requester);
            return this.transform;
        }

        protected final void compute(Requester requester) throws Exception {
            this.rawBounds = VAnnotBoundingBox.getVAnnotBoundingBox(AnnotView.this.annotRef).floatRectValue(requester);
            this.transform = AnnotView.this.vp.vGalleyTransform.affineTransformValue(requester);
            FloatRect floatRect = this.rawBounds.transformRect(this.transform);
            if (AnnotView.this.getFlag(24, requester)) {
                double d = 0.0;
                double d2 = 0.0;
                int n = AnnotView.this.getAnchor(requester);
                switch (n) {
                    case 0: {
                        d = floatRect.getxMin();
                        d2 = floatRect.getyMin();
                        break;
                    }
                    case 1: {
                        d = (floatRect.getxMin() + floatRect.getxMax()) / 2.0;
                        d2 = floatRect.getyMin();
                        break;
                    }
                    case 2: {
                        d = floatRect.getxMax();
                        d2 = floatRect.getyMin();
                        break;
                    }
                    case 3: {
                        d = floatRect.getxMin();
                        d2 = (floatRect.getyMin() + floatRect.getyMax()) / 2.0;
                        break;
                    }
                    case 4: {
                        d = (floatRect.getxMin() + floatRect.getxMax()) / 2.0;
                        d2 = (floatRect.getyMin() + floatRect.getyMax()) / 2.0;
                        break;
                    }
                    case 5: {
                        d = floatRect.getxMax();
                        d2 = (floatRect.getyMin() + floatRect.getyMax()) / 2.0;
                        break;
                    }
                    case 6: {
                        d = floatRect.getxMin();
                        d2 = floatRect.getyMax();
                        break;
                    }
                    case 7: {
                        d = (floatRect.getxMin() + floatRect.getxMax()) / 2.0;
                        d2 = floatRect.getyMax();
                        break;
                    }
                    case 8: {
                        d = floatRect.getxMax();
                        d2 = floatRect.getyMax();
                        break;
                    }
                }
                FloatPoint floatPoint = new FloatPoint(d, d2);
                AffineTransform affineTransform = this.transform.getInverse();
                FloatPoint floatPoint2 = new FloatPoint(floatPoint);
                affineTransform.transformPoint(floatPoint2);
                double d3 = this.rawBounds.width();
                double d4 = this.rawBounds.height();
                switch (n) {
                    case 0: {
                        d = floatPoint2.x;
                        d2 = floatPoint2.y;
                        break;
                    }
                    case 1: {
                        d = floatPoint2.x - d3 / 2.0;
                        d2 = floatPoint2.y;
                        break;
                    }
                    case 2: {
                        d = floatPoint2.x - d3;
                        d2 = floatPoint2.y;
                        break;
                    }
                    case 3: {
                        d = floatPoint2.x;
                        d2 = floatPoint2.y - d4 / 2.0;
                        break;
                    }
                    case 4: {
                        d = floatPoint2.x - d3 / 2.0;
                        d2 = floatPoint2.y - d4 / 2.0;
                        break;
                    }
                    case 5: {
                        d = floatPoint2.x - d3;
                        d2 = floatPoint2.y - d4 / 2.0;
                        break;
                    }
                    case 6: {
                        d = floatPoint2.x;
                        d2 = floatPoint2.y - d4;
                        break;
                    }
                    case 7: {
                        d = floatPoint2.x - d3 / 2.0;
                        d2 = floatPoint2.y - d4;
                        break;
                    }
                    case 8: {
                        d = floatPoint2.x - d3;
                        d2 = floatPoint2.y - d4;
                        break;
                    }
                }
                this.rawBounds = new FloatRect(d, d2, d + d3, d2 + d4);
                if (AnnotView.this.getFlag(8, requester)) {
                    if (AnnotView.this.getFlag(16, requester)) {
                        this.transform = new AffineTransform(1.0, 0.0, 0.0, -1.0, floatPoint.x - floatPoint2.x, floatPoint.y - floatPoint2.y + 2.0 * d2 + d4);
                    } else {
                        double d5 = this.transform.geta();
                        double d6 = this.transform.getc();
                        double d7 = Math.sqrt(d5 * d5 + d6 * d6);
                        this.transform = this.transform.translate(-floatPoint2.x, -floatPoint2.y);
                        this.transform = this.transform.scale(d7);
                        this.transform = this.transform.translate(floatPoint.x, floatPoint.y);
                    }
                } else {
                    double d8 = this.transform.geta();
                    double d9 = this.transform.getc();
                    double d10 = Math.sqrt(d8 * d8 + d9 * d9);
                    this.transform = this.transform.translate(-floatPoint.x, -floatPoint.y);
                    this.transform = this.transform.scale(1.0 / d10);
                    this.transform = this.transform.translate(floatPoint.x, floatPoint.y);
                }
                floatRect = this.rawBounds.transformRect(this.transform);
            }
            this.deviceBounds = floatRect.toEnclosingRect();
        }
    }

    class VAnnotViewPainting
    extends VPainting {
        VAnnotViewPainting() {
        }

        public Painting computePainting(Requester requester) throws Exception {
            if (AnnotView.this.getFlag(1, requester)) {
                return null;
            }
            return AnnotView.this.createPainting(requester, false);
        }
    }

    class VFlags
    extends VInt {
        VFlags() {
        }

        protected final int computeInt(Requester requester) throws Exception {
            int n = 0;
            PDFDict pDFDict = AnnotView.this.annotRef.dictValue(requester);
            if (pDFDict.hasKey(AnnotView.F_K)) {
                n = pDFDict.get(AnnotView.F_K).integerValue(requester);
            }
            return n;
        }
    }
}

