/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.filters.Base64Engine;
import com.adobe.acrobat.gui.AuthenticateDialog;
import com.adobe.acrobat.gui.ConnectionStatusDialog;
import com.adobe.acrobat.gui.ErrorDialog;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Session;
import com.adobe.acrobat.util.Util;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.awt.Frame;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import netscape.security.PrivilegeManager;

public class Authenticator
implements Runnable {
    private URL url;
    private Frame parent;
    private String userName;
    private String password;
    private boolean connectionNotPossible = false;
    private boolean checkDone;
    private AuthenticateDialog authDialog;
    private String base64Auth;
    private int numberOfAuthAttempts = 0;
    private ConnectionStatusDialog statusDialog;
    private Thread worker;
    private int rc = -1;
    private boolean userCanceled = false;
    private boolean acceptRanges = false;
    private int contentLength = -1;
    private static final int kMaxRetry = 5;

    public Authenticator(URL uRL, Frame frame) throws Exception {
        this.url = uRL;
        this.parent = frame;
        this.checkDone = false;
        this.computeAuthorization();
    }

    public boolean canDoByteRanges() {
        try {
            if (this.worker != null) {
                this.worker.join();
            }
        }
        catch (InterruptedException interruptedException) {}
        if (this.userName != null) {
            return false;
        }
        return this.acceptRanges;
    }

    void cancel() {
        this.worker.stop();
        this.userCanceled = true;
    }

    private void checkAuthorization() {
        String string = this.url.getProtocol();
        if (string.equals("http")) {
            this.httpValidation();
        }
    }

    public void computeAuthorization() throws Exception {
        this.userCanceled = false;
        if (!ReaderPrefs.getEnableProxySettings()) {
            return;
        }
        if (!this.checkDone) {
            this.restoreAuthorization();
            this.checkAuthorization();
            if (this.connectionNotPossible) {
                throw new NoRouteToHostException(Util.getErrorString("Error:HTTP:NoRouteToHost"));
            }
            if (this.authDialog != null) {
                this.authDialog.dispose();
            }
        }
    }

    private void createDialog() {
        if (this.authDialog == null) {
            this.authDialog = new AuthenticateDialog(this.parent, this.url, Util.getDialogString("Authenticate:HTTPBox"));
            if (this.base64Auth != null) {
                this.authDialog.preFill(this.userName, this.password);
            }
        }
    }

    public boolean didUserCancel() {
        return this.userCanceled || this.authDialog != null && this.authDialog.didUserCancel();
    }

    public String getBASICAuthorization() {
        if (this.userName == null) {
            return null;
        }
        String string = String.valueOf(this.userName) + ":" + this.password;
        string = "BASIC " + Base64Engine.encode(string);
        return string;
    }

    public int getContentLength() {
        try {
            if (this.worker != null) {
                this.worker.join();
            }
        }
        catch (InterruptedException interruptedException) {}
        return this.contentLength;
    }

    public Authenticator getNewAuthenticator(URL uRL) throws Exception {
        return new Authenticator(uRL, this.parent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getResponseToHeadRequest() {
        this.rc = -1;
        try {
            Session session = Session.getTheSession();
            if (session.isIE()) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            } else if (session.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalConnect");
            }
            int n = 0;
            while (n < 5) {
                try {
                    URLConnection uRLConnection = this.url.openConnection();
                    if (uRLConnection instanceof HttpURLConnection) {
                        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                        httpURLConnection.setRequestMethod("HEAD");
                        if (this.base64Auth != null) {
                            httpURLConnection.setRequestProperty("Authorization", this.base64Auth);
                        }
                        httpURLConnection.connect();
                        this.rc = httpURLConnection.getResponseCode();
                        Log.clog("*** rc = " + this.rc);
                        String string = httpURLConnection.getHeaderField("Accept-Ranges");
                        this.acceptRanges = string != null && string.equals("bytes");
                        this.contentLength = httpURLConnection.getContentLength();
                        httpURLConnection.disconnect();
                    }
                    break;
                }
                catch (NoRouteToHostException noRouteToHostException) {
                    this.connectionNotPossible = true;
                    break;
                }
                catch (UnknownHostException unknownHostException) {
                    this.connectionNotPossible = true;
                    break;
                }
                catch (Exception exception) {
                    Log.clog("*** exception  = " + exception);
                    if (n == 4) {
                        this.connectionNotPossible = true;
                        new ErrorDialog(this.parent, exception);
                    }
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            Object var2_8 = null;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
            this.statusDialog.setVisible(false);
            this.statusDialog.dispose();
            throw throwable;
        }
        Object var2_7 = null;
        try {}
        catch (Exception exception) {}
        Thread.sleep(1000L);
        this.statusDialog.setVisible(false);
        this.statusDialog.dispose();
    }

    public URL getURL() {
        return this.url;
    }

    private void httpValidation() {
        if (this.base64Auth != null) {
            this.seekAuthorizationFromUser();
            if (this.authDialog != null && this.authDialog.didUserCancel()) {
                this.userName = null;
                this.password = null;
                this.checkDone = false;
                return;
            }
        }
        this.statusDialog = new ConnectionStatusDialog(this.parent, this);
        this.rc = -1;
        do {
            this.worker = new Thread((Runnable)this, "Authenticator");
            this.worker.start();
            try {
                try {
                    this.statusDialog.setVisible(true);
                    if (this.didUserCancel()) {
                        break;
                    }
                }
                catch (Exception exception) {}
                if (this.worker.isAlive()) {
                    this.worker.join();
                }
            }
            catch (InterruptedException interruptedException) {}
            if (this.rc == 401) {
                if (this.numberOfAuthAttempts > 0) {
                    ErrorDialog errorDialog = new ErrorDialog(this.parent, Util.getErrorString("Error:HTTP:Unauthorized"));
                }
                Session.getTheSession().removeDomain(this.url);
                this.seekAuthorizationFromUser();
                continue;
            }
            if (this.rc == 200 && this.base64Auth != null) {
                Session.getTheSession().addDomain(this.url, this.base64Auth);
                if (this.authDialog == null) continue;
                if (this.authDialog.getSaveState()) {
                    ReaderPrefs.addAuthorization(this.url, this.base64Auth);
                    continue;
                }
                ReaderPrefs.removeAuthorization(this.url);
                continue;
            }
            if (this.rc == 200) continue;
            this.connectionNotPossible = true;
            break;
        } while (this.rc != 200 && this.authDialog != null && !this.didUserCancel());
        if (this.authDialog != null) {
            if (this.didUserCancel()) {
                this.userName = null;
                this.password = null;
                this.checkDone = false;
            } else {
                this.userName = this.authDialog.getUserName();
                this.password = this.authDialog.getPassword();
                this.checkDone = true;
            }
        }
    }

    private void restoreAuthorization() {
        this.base64Auth = Session.getTheSession().getDomainAuth(this.url);
        if (this.base64Auth == null) {
            this.base64Auth = ReaderPrefs.getAuthorization(this.url);
        }
        if (this.base64Auth != null) {
            String string = Base64Engine.decode(this.base64Auth.substring(this.base64Auth.indexOf(32)));
            int n = string.indexOf(58);
            this.userName = string.substring(0, n);
            this.password = string.substring(n + 1);
        }
    }

    public void run() {
        this.getResponseToHeadRequest();
    }

    private void seekAuthorizationFromUser() {
        if (Session.getTheSession().isANewDomain(this.url) || this.numberOfAuthAttempts > 1) {
            this.createDialog();
            this.authDialog.setVisible(true);
            this.userName = this.authDialog.getUserName();
            this.password = this.authDialog.getPassword();
            this.base64Auth = this.getBASICAuthorization();
        }
        ++this.numberOfAuthAttempts;
    }
}

