/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.BasicPanel;
import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.util.Log;
import com.adobe.pe.awt.MouseTransactionClient;
import com.adobe.pe.awt.ScrollerLogic;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.awt.VCursorObserver;
import com.adobe.pe.awt.VPaintingCanvas;
import com.adobe.pe.awt.VScrollbar;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.TransactionExecutionContext;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.notify.VSynchronizer;
import com.adobe.pe.painting.VPainting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class GalleyScroller
extends BasicPanel
implements StrobeContainer,
ComponentListener,
MouseListener,
MouseMotionListener,
TransactionExecutionContext {
    VSynchronizer vGalleySynchronizer = new VSynchronizer();
    boolean listeningToMotion = false;
    VSynchronizer vMouseEntrySynchronizer = new VSynchronizer();
    Transaction mouseTransaction = null;
    MouseTransactionClient mouseClient = null;
    int W;
    int H;
    VPaintingCanvas galleyView;
    PageView pv;
    ScrollerLogic logic;
    VScrollbar hbar;
    VScrollbar vbar;
    VCursorObserver vCursorObserver;

    public GalleyScroller(PageView pageView) throws Exception {
        super(pageView.getAcroViewContext());
        this.setLayout(new BorderLayout());
        this.pv = pageView;
        this.logic = pageView.getScrollerLogic();
        VPainting vPainting = pageView.getVPainting();
        this.galleyView = new VPaintingCanvas(vPainting);
        pageView.setDisplayComponent(this.galleyView);
        this.vCursorObserver = new VCursorObserver(this.galleyView, pageView.getVCursor());
        this.hbar = this.logic.vHscrollbar;
        this.vbar = this.logic.vVscrollbar;
        this.add((Component)this.galleyView, "Center");
        this.add((Component)this.hbar, "South");
        this.add((Component)this.vbar, "East");
        this.addComponentListener(this);
        this.galleyView.addMouseListener(this);
        this.validate();
    }

    public void abortTransaction(Transaction transaction) {
    }

    public void beginTransaction(Transaction transaction) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (componentEvent.getSource() == this) {
            this.invalidate();
            ResizeTransactor resizeTransactor = new ResizeTransactor();
            this.vGalleySynchronizer.setTransactor(null, resizeTransactor);
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    void dispatchMousePressed(MouseEvent mouseEvent) {
        try {
            Point point = mouseEvent.getPoint();
            this.pv.setMouseHoverPosition(this.mouseTransaction, point);
            this.mouseClient = this.pv.createMouseTransactionClient(this.mouseTransaction, mouseEvent);
            if (this.mouseClient != null) {
                this.mouseClient.mousePressed(this.mouseTransaction, mouseEvent);
            }
            this.mouseTransaction.notifyStrobes();
        }
        catch (Throwable throwable) {
            this.setNoCurrentMouseTransaction(throwable);
        }
    }

    void dispatchMouseReleased(MouseEvent mouseEvent) {
        try {
            try {
                if (this.mouseClient != null) {
                    Point point = mouseEvent.getPoint();
                    this.pv.setMouseHoverPosition(this.mouseTransaction, point);
                    this.mouseClient.mouseReleased(this.mouseTransaction, point);
                }
            }
            catch (Throwable throwable) {
                this.setNoCurrentMouseTransaction(throwable);
            }
            Object var3_4 = null;
            this.setNoCurrentMouseTransaction(null);
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.setNoCurrentMouseTransaction(null);
            throw throwable;
        }
    }

    public synchronized void endTransaction(Transaction transaction) {
        if (this.mouseTransaction == transaction) {
            this.mouseClient = null;
            this.mouseTransaction = null;
            this.notifyAll();
        }
    }

    public VPaintingCanvas getGalleyView() {
        return this.galleyView;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        try {
            if (this.mouseTransaction == null) {
                return;
            }
            mouseEvent.consume();
            if (this.mouseClient != null) {
                Point point = this.pv.getScrollPosition(this.mouseTransaction);
                mouseEvent.translatePoint(point.x, point.y);
                this.mouseClient.mouseDragged(this.mouseTransaction, mouseEvent.getPoint());
            }
        }
        catch (Throwable throwable) {
            this.setNoCurrentMouseTransaction(throwable);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        mouseEvent.consume();
        if (!this.listeningToMotion) {
            this.galleyView.addMouseMotionListener(this);
            this.listeningToMotion = true;
        }
        StatusTextTransactor statusTextTransactor = new StatusTextTransactor(false);
        this.pv.mouseSynchronizer.setTransactor(this.pv.getAcroViewContext(), statusTextTransactor);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        mouseEvent.consume();
        if (this.listeningToMotion) {
            this.galleyView.removeMouseMotionListener(this);
            this.listeningToMotion = false;
        }
        StatusTextTransactor statusTextTransactor = new StatusTextTransactor(true);
        this.pv.mouseSynchronizer.setTransactor(this.pv.getAcroViewContext(), statusTextTransactor);
    }

    public void mouseMoved(final MouseEvent mouseEvent) {
        mouseEvent.consume();
        Transactor transactor = new Transactor(){

            protected final void buildChanges(Transaction transaction) throws Exception {
                Point point = pv.getScrollPosition(transaction);
                mouseEvent.translatePoint(point.x, point.y);
                pv.setMouseHoverPosition(transaction, mouseEvent.getPoint());
            }
        };
        this.pv.mouseSynchronizer.setTransactor(null, transactor);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (BasicPanel.isPopupEvent(mouseEvent)) {
            super.mousePressed(mouseEvent);
        } else {
            mouseEvent.consume();
            MouseTransaction mouseTransaction = new MouseTransaction();
            try {
                this.setCurrentMouseTransaction(mouseTransaction);
                Point point = this.pv.getScrollPosition(mouseTransaction);
                mouseEvent.translatePoint(point.x, point.y);
            }
            catch (Throwable throwable) {
                this.setNoCurrentMouseTransaction(throwable);
                return;
            }
            this.dispatchMousePressed(mouseEvent);
        }
        super.requestFocus();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (this.mouseTransaction == null) {
            return;
        }
        try {
            Point point = this.pv.getScrollPosition(this.mouseTransaction);
            mouseEvent.translatePoint(point.x, point.y);
        }
        catch (Throwable throwable) {
            this.setNoCurrentMouseTransaction(throwable);
        }
        this.dispatchMouseReleased(mouseEvent);
    }

    public void reportError(Transaction transaction, Throwable throwable, boolean bl) {
        this.pv.getAcroViewContext().reportError(transaction, throwable, bl);
    }

    synchronized void setCurrentMouseTransaction(Transaction transaction) throws InterruptedException {
        if (this.mouseTransaction != null) {
            this.setNoCurrentMouseTransaction(null);
        }
        while (this.mouseTransaction != null) {
            this.wait();
        }
        this.mouseTransaction = transaction;
        this.mouseTransaction.begin(this);
    }

    synchronized void setNoCurrentMouseTransaction(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        if (this.mouseTransaction != null) {
            if (throwable != null) {
                if (this.mouseClient != null) {
                    try {
                        this.mouseClient.mouseAborted(this.mouseTransaction);
                    }
                    catch (Exception exception) {
                        Log.clog("GalleyScroller.setNoCurrentMouseTransaction: " + exception.toString());
                    }
                }
                this.mouseTransaction.abort(throwable);
            } else {
                this.mouseTransaction.finish();
            }
            this.mouseClient = null;
            this.mouseTransaction = null;
            this.notifyAll();
        }
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        super.setStrobeActive(transaction, bl);
        this.vCursorObserver.setStrobeActive(transaction, bl);
    }

    class ResizeTransactor
    extends Transactor {
        ResizeTransactor() {
        }

        protected final void buildChanges(Transaction transaction) throws Exception {
            GalleyScroller.this.logic.vScrollPaneInsets.setInsetsValue(transaction, GalleyScroller.this.getInsets());
            GalleyScroller.this.logic.vScrollPaneSize.setDimensionValue(transaction, GalleyScroller.this.getSize());
        }
    }

    class MouseTransaction
    extends Transaction {
        MouseTransaction() {
        }

        public void requestInterrupt() {
            this.abort(new InterruptedException());
        }
    }

    class StatusTextTransactor
    extends Transactor {
        boolean retiring;

        StatusTextTransactor(boolean bl) {
            this.retiring = bl;
        }

        protected final void buildChanges(Transaction transaction) throws Exception {
            PageView pageView = GalleyScroller.this.pv;
            AcroViewContext acroViewContext = pageView.getAcroViewContext();
            if (this.retiring) {
                acroViewContext.retireStatusTextProvider(transaction, pageView);
            } else {
                acroViewContext.setStatusTextProvider(transaction, pageView);
            }
        }
    }
}

