/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.BasicDialog;
import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.MessageDialog;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.util.PEUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.KeyEvent;

public class GoToPageDialog {
    private Frame fParent;
    private AcroViewContext context;
    private PageView pv;
    private PageDialog fPageDialog = null;

    public GoToPageDialog(AcroViewContext acroViewContext) {
        this.context = acroViewContext;
        this.pv = acroViewContext.getPageView();
        this.fParent = PEUtil.getFrame(acroViewContext.getRootComponent());
        this.showTheDialog();
        this.fParent.toFront();
    }

    private void showTheDialog() {
        try {
            int n = this.pv.getCurrentPage(null);
            int n2 = this.pv.getNumPages(null);
            this.fPageDialog = new PageDialog(PEUtil.getFrame(this.fParent), n, n2);
            this.fPageDialog.setVisible(true);
            if (!this.fPageDialog.didUserCancel()) {
                try {
                    Transactor transactor = new Transactor(){

                        public void buildChanges(Transaction transaction) throws Exception {
                            int n = GoToPageDialog.this.fPageDialog.getSelectedPage();
                            GoToPageDialog.this.pv.goToPage(transaction, n);
                        }
                    };
                    this.context.getVNavigationSynchronizer().setTransactor(this.context, transactor);
                }
                catch (Exception exception) {
                    Log.clog("PageButton.dialogDismissed: " + exception.toString());
                }
            }
        }
        catch (Exception exception) {}
    }

    class PageDialog
    extends BasicDialog {
        private int fCurPage;
        private int fSelectedPage;
        private int fMaxPages;
        private TextField pText;

        public PageDialog(Frame frame, int n, int n2) {
            super(frame, Util.getDialogString("GoToPage:Title"), true);
            this.fCurPage = n;
            this.fMaxPages = n2;
            this.setLayout(new BorderLayout(5, 5));
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout(0, 5, 5));
            panel.add(new Label(Util.getDialogString("GoToPage:Page"), 2));
            this.pText = new TextField(String.valueOf(this.fCurPage + 1), 6);
            this.pText.addActionListener(this);
            this.pText.addKeyListener(this);
            this.pText.selectAll();
            panel.add(this.pText);
            String string = Util.getDialogString("GoToPage:OfPages", new Integer(this.fMaxPages));
            panel.add(new Label(string, 0));
            this.add((Component)panel, "North");
            this.add((Component)this.okCancelPanel, "South");
            this.pack();
            this.setResizable(false);
        }

        private void doErrorDialog(String string) {
            MessageDialog messageDialog = new MessageDialog(PEUtil.getFrame(this), Util.getDialogString("Dialog:InvalidEntry"), Util.getDialogString("Dialog:NotValidFromTo", string, new Integer(1), new Integer(this.fMaxPages)));
            messageDialog.runDialog();
        }

        public int getSelectedPage() {
            int n;
            String string = this.pText.getText();
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = 0;
            }
            if (n < 1 || n > this.fMaxPages) {
                n = 0;
                this.doErrorDialog(string);
                this.pText.setText(String.valueOf(this.fCurPage + 1));
                this.pText.selectAll();
                this.pText.requestFocus();
            }
            return n - 1;
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getComponent() == this.pText) {
                this.ok.setEnabled(this.pText.getText().length() > 0);
                if (keyEvent.getKeyCode() == 10) {
                    this.ok();
                }
            } else {
                super.keyReleased(keyEvent);
            }
        }

        public void ok() {
            this.fSelectedPage = this.getSelectedPage();
            if (this.fSelectedPage < 0) {
                return;
            }
            super.ok();
        }
    }
}

