/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.HighlightOrnament;
import com.adobe.acrobat.gui.Ornament;
import com.adobe.acrobat.gui.VisiblePage;
import com.adobe.acrobat.pdf.ColorValue;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.sidecar.AWTGraphics;
import com.adobe.acrobat.sidecar.BezierPath;
import com.adobe.acrobat.sidecar.FloatRect;

public class Highlight {
    private Highlight superHighlight;
    private PDFReference page;
    private BezierPath path;

    public Highlight(Highlight highlight, BezierPath bezierPath, PDFReference pDFReference) {
        this.superHighlight = highlight;
        this.path = bezierPath;
        this.page = pDFReference;
    }

    public Highlight(BezierPath bezierPath, PDFReference pDFReference) {
        this.path = bezierPath;
        this.page = pDFReference;
    }

    public Ornament createOrnament(VisiblePage visiblePage) {
        return new HighlightOrnament(visiblePage, this);
    }

    public void draw(PDFReference pDFReference, AWTGraphics aWTGraphics) {
        aWTGraphics.save();
        aWTGraphics.setXORMode(true);
        aWTGraphics.setFillColor(ColorValue.green);
        Highlight highlight = this;
        while (highlight != null) {
            if (pDFReference == highlight.page) {
                aWTGraphics.fillPath(highlight.path);
            }
            highlight = highlight.superHighlight;
        }
        aWTGraphics.restore();
    }

    public FloatRect getBounds(PDFReference pDFReference) {
        Highlight highlight = this;
        FloatRect floatRect = null;
        while (highlight != null) {
            if (highlight.page == pDFReference) {
                floatRect = floatRect == null ? highlight.path.getBoundingBox() : floatRect.union(highlight.path.getBoundingBox());
            }
            highlight = highlight.superHighlight;
        }
        return floatRect;
    }

    public boolean includesPage(PDFReference pDFReference) {
        return this.page == pDFReference || this.superHighlight != null && this.superHighlight.includesPage(pDFReference);
    }
}

