/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.ViewerCommand;
import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.CommandRegistry;
import com.adobe.acrobat.gui.SimpleUIVerb;
import com.adobe.pe.awt.UIVerb;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.vtypes.VBoolean;

class PageLayoutUIVerb
extends UIVerb
implements ViewerCommand {
    AcroViewContext context;
    String layoutMode;

    PageLayoutUIVerb(AcroViewContext acroViewContext, String string) {
        this.context = acroViewContext;
        this.layoutMode = string;
        PageLayoutTransactor pageLayoutTransactor = new PageLayoutTransactor();
        VBoolean vBoolean = string.equals("SinglePage") ? SimpleUIVerb.getVDocIsOpenBoolean(acroViewContext) : new VPageLayoutIsEnabledBoolean();
        VPageLayoutIsSelectedBoolean vPageLayoutIsSelectedBoolean = new VPageLayoutIsSelectedBoolean();
        this.setAttributes(pageLayoutTransactor, vBoolean, vPageLayoutIsSelectedBoolean);
    }

    public static void registerCommands(AcroViewContext acroViewContext) {
        CommandRegistry.addCommand(new PageLayoutUIVerb(acroViewContext, "SinglePage"), acroViewContext, "SinglePage");
        CommandRegistry.addCommand(new PageLayoutUIVerb(acroViewContext, "OneColumn"), acroViewContext, "OneColumn");
        CommandRegistry.addCommand(new PageLayoutUIVerb(acroViewContext, "TwoColumn"), acroViewContext, "TwoColumn");
        CommandRegistry.addCommand(new PageLayoutUIVerb(acroViewContext, "TwoColumnLeft"), acroViewContext, "TwoColumnLeft");
        CommandRegistry.addCommand(new PageLayoutUIVerb(acroViewContext, "TwoColumnRight"), acroViewContext, "TwoColumnRight");
    }

    class PageLayoutTransactor
    extends Transactor {
        PageLayoutTransactor() {
        }

        public void buildChanges(Transaction transaction) throws Exception {
            PageLayoutUIVerb.this.context.getPageView().setPageLayout(transaction, PageLayoutUIVerb.this.layoutMode);
        }
    }

    class VPageLayoutIsSelectedBoolean
    extends VBoolean {
        VPageLayoutIsSelectedBoolean() {
        }

        protected final boolean computeBoolean(Requester requester) throws Exception {
            if (!SimpleUIVerb.getVDocIsOpenBoolean(PageLayoutUIVerb.this.context).booleanValue(requester)) {
                return false;
            }
            return PageLayoutUIVerb.this.context.getPageView().getPageLayout(requester).equals(PageLayoutUIVerb.this.layoutMode);
        }
    }

    class VPageLayoutIsEnabledBoolean
    extends VBoolean {
        VPageLayoutIsEnabledBoolean() {
        }

        protected final boolean computeBoolean(Requester requester) throws Exception {
            if (!SimpleUIVerb.getVDocIsOpenBoolean(PageLayoutUIVerb.this.context).booleanValue(requester)) {
                return false;
            }
            return PageLayoutUIVerb.this.context.getPageView().getNumPages(requester) > 1;
        }
    }
}

