/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.ViewerPanel;
import com.adobe.acrobat.util.Log;
import com.adobe.pe.awt.LightWeightPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class SplitPane
extends LightWeightPanel
implements MouseListener {
    private Container leftPanel;
    private Component right;
    private Component left;
    private Divider divider;
    private int leftWidth = -1;
    private boolean leftHasFocus;
    private int leftWidthPercent;
    private int leftWidthMaxPercent;

    public SplitPane(int n, int n2) {
        this.setLayout(null);
        this.divider = new Divider(this);
        this.leftPanel = new Panel(new CardLayout());
        this.add((Component)this.leftPanel, 0);
        this.add((Component)this.divider, 1);
        this.leftWidthPercent = n;
        this.leftWidthMaxPercent = n2;
        this.setBackground(ViewerPanel.getDesktopColor());
        this.addMouseListener(this);
    }

    public void closeLeftPane() {
        this.leftWidth = 0;
        this.invalidate();
        this.validate();
        this.setKeyboardFocus(this.right);
    }

    public void doLayout() {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (n != 0 && this.leftWidth == -1) {
            this.leftWidth = n * this.leftWidthPercent / 100;
        }
        this.leftWidth = Math.min(this.leftWidth, n * this.leftWidthMaxPercent / 100);
        this.leftWidth = Math.max(this.leftWidth, 0);
        if (this.leftWidth == 0) {
            this.leftPanel.setBounds(0, 0, 0, 0);
            this.divider.setBounds(0, 0, 0, 0);
            this.right.setBounds(0, 0, n, n2);
        } else {
            int n3 = 3;
            this.leftPanel.setBounds(0, 0, this.leftWidth, n2);
            this.divider.setBounds(this.leftWidth, 0, n3, n2);
            this.right.setBounds(this.leftWidth + n3, 0, n - this.leftWidth - n3, n2);
        }
    }

    public Container getLeftPanel() {
        return this.leftPanel;
    }

    public Dimension getPreferredSize() {
        return this.getParent().getSize();
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        frame.setLayout(new BorderLayout());
        SplitPane splitPane = new SplitPane(20, 90);
        Label label = new Label("LEFT");
        Label label2 = new Label("RIGHT");
        splitPane.setLeftComponent(label, label);
        splitPane.setRightComponent(label2);
        frame.add((Component)splitPane, "Center");
        ((Component)frame).setSize(500, 500);
        frame.pack();
        frame.show();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Log.clog("SplitPane.mouseClicked");
        this.right.requestFocus();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void moveDivider(int n) {
        this.leftWidth += n;
        this.invalidate();
        this.validate();
        this.setKeyboardFocus(this.right);
    }

    public void resetDivider() {
        this.leftWidth = -1;
        this.invalidate();
        this.validate();
        this.setKeyboardFocus(this.right);
    }

    private void setKeyboardFocus(Component component) {
        if (component != null) {
            this.leftHasFocus = component != this.right;
            component.requestFocus();
        }
    }

    public void setLeftComponent(Component component, Component component2) {
        this.leftPanel.add(component, "Bookmark");
        this.left = component2;
    }

    public void setRightComponent(Component component) {
        if (this.right != null) {
            this.remove(this.right);
            this.right = null;
        }
        if (component != null) {
            this.add(component, 2);
            this.right = component;
        }
    }

    public void transferFocus() {
        if (this.leftHasFocus) {
            this.setKeyboardFocus(this.right);
        } else {
            this.setKeyboardFocus(this.left);
        }
    }

    public class Divider
    extends Component
    implements MouseListener,
    MouseMotionListener {
        private SplitPane parent;

        public Divider(SplitPane splitPane2) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.parent = splitPane2;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.parent.moveDivider(mouseEvent.getPoint().x);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.setCursor(Cursor.getPredefinedCursor(11));
            mouseEvent.consume();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.setCursor(Cursor.getPredefinedCursor(10));
            mouseEvent.consume();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(this.getBackground().darker());
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }
}

