/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.ComboButton;
import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.SimpleUIVerb;
import com.adobe.acrobat.gui.ZoomToDialog;
import com.adobe.acrobat.gui.ZoomValueSpec;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.vtypes.VBoolean;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ZoomLevelButton
extends ComboButton
implements VObserver,
ActionListener,
StrobeContainer {
    private Component fParent;
    private AcroViewContext context;
    PageView pv;
    private VStrobe strobe;
    private PopupMenu popup;
    private boolean fAddedPopup = false;

    public ZoomLevelButton(AcroViewContext acroViewContext) {
        super(null, "zoomlevel.gif", false);
        MenuItem menuItem;
        this.context = acroViewContext;
        this.pv = acroViewContext.getPageView();
        this.fParent = acroViewContext.getRootComponent();
        this.popup = new PopupMenu();
        int n = 0;
        while (n < ZoomValueSpec.zoomValuesTable.length) {
            ZoomValueSpec zoomValueSpec = ZoomValueSpec.zoomValuesTable[n];
            if (zoomValueSpec == null) {
                this.popup.addSeparator();
            } else {
                menuItem = new MenuItem(zoomValueSpec.getUIString(true));
                menuItem.setActionCommand(zoomValueSpec.getMenuItemString());
                this.popup.add(menuItem);
            }
            ++n;
        }
        this.popup.addSeparator();
        menuItem = new MenuItem(Util.getDialogString("Zoom:ZoomTo"));
        menuItem.setActionCommand("Zoom:ZoomTo");
        this.popup.add(menuItem);
        this.add(this.popup);
        this.popup.addActionListener(this);
        this.strobe = new VStrobe(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block3: {
            if (actionEvent.getSource() != this.popup) break block3;
            final String string = actionEvent.getActionCommand();
            try {
                if (string.equals("Zoom:ZoomTo")) {
                    new ZoomToDialog(this.context);
                    break block3;
                }
                Transactor transactor = new Transactor(){

                    public void buildChanges(Transaction transaction) throws Exception {
                        int n = 0;
                        while (n < ZoomValueSpec.zoomValuesTable.length) {
                            ZoomValueSpec zoomValueSpec = ZoomValueSpec.zoomValuesTable[n];
                            if (zoomValueSpec != null && zoomValueSpec.getMenuItemString().equals(string)) {
                                pv.setZoomValueSpec(transaction, zoomValueSpec);
                            }
                            ++n;
                        }
                    }
                };
                transactor.commit(this.context);
            }
            catch (Exception exception) {
                Log.clog("ZoomLevelButton.action: " + exception.toString());
            }
        }
    }

    public void change(Requester requester) {
        try {
            VBoolean vBoolean = SimpleUIVerb.getVDocIsOpenBoolean(this.context);
            if (vBoolean.booleanValue(requester)) {
                float f = this.pv.getScale(requester);
                this.setString(ZoomValueSpec.formatZoomLevel(f, true));
            } else {
                this.setString("");
            }
            this.invalidate();
            this.repaint();
        }
        catch (Exception exception) {
            this.setString("");
        }
    }

    public static void handleZoomDialog(AcroViewContext acroViewContext) {
        try {
            new ZoomToDialog(acroViewContext);
        }
        catch (Exception exception) {}
    }

    public boolean isEnabled() {
        boolean bl = false;
        try {
            bl = super.isEnabled() && this.pv.getNumPages(null) > 0;
        }
        catch (Exception exception) {}
        return bl;
    }

    public void performComboButtonAction() {
        this.popup.show(this, 0, 0);
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }
}

