/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.page;

import com.adobe.acrobat.page.Content;
import com.adobe.acrobat.page.ContentArray;
import com.adobe.acrobat.page.ContentOperator;
import com.adobe.acrobat.page.GState;
import com.adobe.acrobat.pdf.ContentExecuter;
import com.adobe.acrobat.pdf.PageException;
import com.adobe.acrobat.pdf.TextExecuter;
import com.adobe.acrobat.pdfobjstore.PDFArray;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFInteger;
import com.adobe.acrobat.pdfobjstore.PDFName;
import com.adobe.acrobat.pdfobjstore.PDFNumber;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFReal;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.PDFString;
import com.adobe.acrobat.pdfobjstore.UnexpectedTypeException;
import com.adobe.acrobat.sidecar.AffineException;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.BezierPath;
import com.adobe.acrobat.sidecar.FloatPoint;
import com.adobe.acrobat.tokenize.Tokenizer;
import com.adobe.pe.notify.Requester;
import com.adobe.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Stack;

public class ContentParser {
    private boolean done;
    public static final int kPageDescLevel = 0;
    public static final int kPathLevel = 1;
    public static final int kTextLevel = 2;
    public static final int kInlineImageLevel = 3;
    public static final int kXObjectLevel = 4;
    private BezierPath bz = null;
    private int clipStyle;
    private AffineTransform textBaseMatrix;
    private AffineTransform textMatrix;
    private double textMatrixHScale;
    private double textMatrixVScale;
    private AffineTransform lineMatrix;
    private FloatPoint p = new FloatPoint();
    private static final String OpenBracket_K = "[";
    private static final String OpenDoubleAngleBracket_K = "<<";
    private static final String BI_K = "BI";
    private static final String EI_K = "EI";
    Tokenizer tokenizer;
    private String currentOperator;
    private static Hashtable operators = new Hashtable();
    public int level = 0;
    private Stack stack = new Stack();
    protected ContentArray contentArray;
    private Requester requester;
    private InputStream stm;
    private PDFReference resources;
    private GState gState = GState.getInitialGState();
    private Stack gStateStack = new Stack();
    private int streamStart;

    static {
        ContentExecuter.populateOperators(operators);
        TextExecuter.populateOperators(operators);
    }

    ContentParser(ContentArray contentArray, Requester requester) throws Exception {
        this.contentArray = contentArray;
        this.requester = requester;
        this.stm = contentArray.contentStreamFactory.getInputStream();
        this.resources = contentArray.resources;
        this.tokenizer = new Tokenizer(this.stm);
        this.streamStart = this.tokenizer.numBytesConsumed();
        this.tokenizer.nextToken();
        this.gStateStack.empty();
    }

    public void addContent(Content content) throws Exception {
        this.contentArray.addContent(content);
        this.streamStart = this.tokenizer.numBytesConsumed();
    }

    public void addException(Exception exception) {
        this.contentArray.addException(exception);
    }

    public void beginText() throws PageException {
        if (this.level != 0) {
            throw new PageException(15, "BT");
        }
        this.level = 2;
        this.textMatrix = AffineTransform.getIdentityMatrix();
        this.lineMatrix = AffineTransform.getIdentityMatrix();
        this.textBaseMatrix = this.gState.getCTM();
    }

    void churn() throws Exception {
        try {
            switch (this.tokenizer.type()) {
                case 256: {
                    this.closeStream();
                    this.setDone();
                    break;
                }
                case 2: {
                    this.pushAndAdvance(new PDFInteger(this.tokenizer.integerValue()));
                    break;
                }
                case 3: {
                    this.pushAndAdvance(new PDFReal(this.tokenizer.realValue()));
                    break;
                }
                case 4: {
                    this.pushAndAdvance(new PDFName(this.tokenizer.nameValue()));
                    break;
                }
                case 1: {
                    this.pushAndAdvance(new PDFString(this.tokenizer.bytesValue()));
                    break;
                }
                case 5: {
                    this.executeLiteral(this.tokenizer.literalValue());
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            this.addException(exception);
        }
    }

    public void closePath() throws PageException {
        if (this.bz != null) {
            this.createPathIfNecessary();
            this.bz.closePath();
        }
    }

    private void closeStream() {
        try {
            this.tokenizer.close();
        }
        catch (IOException iOException) {}
    }

    private void createPathIfNecessary() throws PageException {
        if (this.level == 0) {
            Assert.notFalse(this.bz == null);
            this.bz = new BezierPath(128);
            this.clipStyle = 0;
            this.level = 1;
        } else if (this.level == 1) {
            Assert.notFalse(this.bz != null);
        } else {
            throw new PageException(44, this.currentOperator);
        }
    }

    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) throws PageException {
        this.createPathIfNecessary();
        this.bz.curveTo(d, d2, d3, d4, d5, d6);
    }

    public void curveToV(double d, double d2, double d3, double d4) throws PageException {
        this.createPathIfNecessary();
        this.bz.curveToV(d, d2, d3, d4);
    }

    public BezierPath endPath() throws PageException {
        BezierPath bezierPath = null;
        if (this.level == 1) {
            Assert.notFalse(this.bz != null);
            bezierPath = this.bz.compact();
            this.bz = null;
            this.level = 0;
        }
        return bezierPath;
    }

    public void endText() throws PageException, AffineException {
        if (this.level != 2) {
            throw new PageException(15, "ET");
        }
        this.level = 0;
        this.setGState(this.gState.setTransform(this.textBaseMatrix));
        int n = this.gState.getTextRenderMode();
        if ((n & 4) != 0) {
            this.setGState(this.gState.setTextRenderMode(0));
            this.setGState(this.gState.setTextRenderMode(n));
        }
    }

    private void executeLiteral(String string) throws Exception {
        if (string.equals(OpenBracket_K)) {
            PDFObj pDFObj = PDFObj.read(this.tokenizer, true);
            PDFArray pDFArray = pDFObj.arrayValue(this.requester);
            this.stack.push(pDFArray);
        } else if (string.equals(OpenDoubleAngleBracket_K)) {
            PDFObj pDFObj = PDFObj.read(this.tokenizer, true);
            PDFDict pDFDict = pDFObj.dictValue(this.requester);
            this.stack.push(pDFDict);
        } else if (string.equals(BI_K)) {
            PDFObj pDFObj = PDFObj.readInlineImage(this.resources.getObjStore(), this.tokenizer);
            this.stack.push(pDFObj);
            this.executeLiteral(EI_K);
            this.tokenizer.nextToken();
        } else {
            ContentOperator contentOperator = this.getContentOperator(string);
            try {
                this.currentOperator = string;
                if (contentOperator == null) {
                    throw new PageException(15, string);
                }
                contentOperator.setUp(this.requester, this);
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (Exception exception) {
                this.addException(exception);
            }
            this.tokenizer.nextToken();
        }
    }

    public int getClipStyle() {
        return this.clipStyle;
    }

    public int getContentObjEnd() {
        return this.tokenizer.numBytesConsumed();
    }

    public int getContentObjStart() {
        return this.streamStart;
    }

    protected ContentOperator getContentOperator(String string) {
        return (ContentOperator)operators.get(string);
    }

    public InputStream getContentStream() {
        return this.tokenizer;
    }

    boolean getDone() {
        return this.done;
    }

    public GState getGState() {
        return this.gState;
    }

    public Content getLastContent() {
        return this.contentArray.getLastContent();
    }

    public AffineTransform getLineMatrix() throws PageException {
        if (this.level != 2) {
            throw new PageException(15);
        }
        return this.lineMatrix;
    }

    public AffineTransform getRenderMatrix() throws PageException {
        if (this.level != 2) {
            throw new PageException(15);
        }
        AffineTransform affineTransform = new AffineTransform(this.gState.getFontSize() * this.gState.getHorizontalTextScale(), 0.0, 0.0, this.gState.getFontSize(), 0.0, this.gState.getTextRise());
        affineTransform = affineTransform.appendTransform(this.textMatrix);
        affineTransform = affineTransform.appendTransform(this.textBaseMatrix);
        return affineTransform;
    }

    public PDFReference getResources() {
        return this.resources;
    }

    public AffineTransform getTextMatrix() throws PageException {
        if (this.level != 2) {
            throw new PageException(15);
        }
        return this.textMatrix;
    }

    public void lineTo(double d, double d2) throws PageException {
        this.createPathIfNecessary();
        this.bz.lineTo(d, d2);
    }

    public void moveTo(double d, double d2) throws PageException {
        this.createPathIfNecessary();
        this.bz.moveTo(d, d2);
    }

    public PDFObj popAny() {
        return (PDFObj)this.stack.pop();
    }

    public PDFArray popArray() throws UnexpectedTypeException {
        PDFObj pDFObj = (PDFObj)this.stack.pop();
        if (pDFObj instanceof PDFArray) {
            return (PDFArray)pDFObj;
        }
        throw new UnexpectedTypeException(7);
    }

    public double popDouble() throws UnexpectedTypeException {
        PDFObj pDFObj = (PDFObj)this.stack.pop();
        if (pDFObj instanceof PDFNumber) {
            return ((PDFNumber)pDFObj).doubleValue();
        }
        throw new UnexpectedTypeException(3);
    }

    public int popInt() throws UnexpectedTypeException {
        PDFObj pDFObj = (PDFObj)this.stack.pop();
        if (pDFObj instanceof PDFInteger) {
            return ((PDFInteger)pDFObj).integerValue();
        }
        throw new UnexpectedTypeException(2);
    }

    public String popName() throws UnexpectedTypeException {
        PDFObj pDFObj = (PDFObj)this.stack.pop();
        if (pDFObj instanceof PDFName) {
            return ((PDFName)pDFObj).nameValue();
        }
        throw new UnexpectedTypeException(5);
    }

    public PDFString popPDFString() throws UnexpectedTypeException {
        PDFObj pDFObj = (PDFObj)this.stack.pop();
        if (pDFObj instanceof PDFString) {
            return (PDFString)pDFObj;
        }
        throw new UnexpectedTypeException(4);
    }

    public PDFReference popRef() throws Exception {
        PDFObj pDFObj = (PDFObj)this.stack.pop();
        return pDFObj.pdfReferenceValue(this.requester);
    }

    public String popString() throws UnexpectedTypeException {
        PDFObj pDFObj = (PDFObj)this.stack.pop();
        if (pDFObj instanceof PDFString) {
            return ((PDFString)pDFObj).stringValue();
        }
        throw new UnexpectedTypeException(4);
    }

    void pushAndAdvance(PDFObj pDFObj) throws Exception {
        this.stack.push(pDFObj);
        this.tokenizer.nextToken();
    }

    public GState restoreGState() throws PageException {
        if (this.gStateStack.isEmpty()) {
            throw new PageException(16);
        }
        GState gState = (GState)this.gStateStack.pop();
        this.setGState(GState.getGStateRestore(this.gState, gState));
        return gState;
    }

    public void saveGState() {
        this.gStateStack.push(this.gState);
        this.setGState(GState.getGStateSave(this.gState));
    }

    public void setClipStyle(int n) {
        this.clipStyle = n;
    }

    private void setDone() {
        this.done = true;
    }

    public void setGState(GState gState) {
        this.gState = gState;
    }

    public void setGStateForText() throws PageException, AffineException {
        this.setGState(this.gState.setTransform(this.getRenderMatrix()));
    }

    public void setLineMatrix(AffineTransform affineTransform) throws PageException {
        if (this.level != 2) {
            throw new PageException(15);
        }
        this.lineMatrix = affineTransform;
    }

    public void setTextBaseMatrix(AffineTransform affineTransform) throws AffineException {
        Assert.notFalse(this.level == 2);
        this.textBaseMatrix = affineTransform;
        this.setGState(this.gState.appendTransform(affineTransform));
    }

    public void setTextMatrix(AffineTransform affineTransform) throws PageException {
        if (this.level != 2) {
            throw new PageException(15, "Tm");
        }
        this.textMatrix = affineTransform;
        this.p.x = 0.0;
        this.p.y = 1.0;
        this.textMatrix.transformPoint(this.p, this.p);
        this.textMatrixVScale = Math.sqrt(this.p.x * this.p.x + this.p.y * this.p.y);
        this.p.x = 1.0;
        this.p.y = 0.0;
        this.textMatrix.transformPoint(this.p, this.p);
        this.textMatrixHScale = Math.sqrt(this.p.x * this.p.x + this.p.y * this.p.y);
    }
}

