/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.VValue;
import com.adobe.util.Assert;
import java.util.Enumeration;
import java.util.Hashtable;

public class VAdditionalAction
extends VValue {
    static final String VAdditionalActionTable_K = "VAdditionalActionTable";
    private static ExtensionDataProvider provider = null;
    private static final String Parent_K = "Parent";
    private static final String AA_K = "AA";
    PDFReference dictRef;
    Hashtable actions;

    protected VAdditionalAction(PDFReference pDFReference) {
        this.dictRef = pDFReference;
    }

    protected void compute(Requester requester) throws Exception {
        if (this.dictRef.type(requester) == 6) {
            PDFDict pDFDict = this.dictRef.dictValue(requester);
            this.actions = new Hashtable(9);
            if (pDFDict.hasKey(AA_K)) {
                pDFDict = pDFDict.get(AA_K).pdfReferenceValue(requester).dictValue(requester);
                Enumeration enumeration = pDFDict.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    this.actions.put(string, pDFDict.get(string).pdfReferenceValue(requester));
                }
            }
        }
    }

    protected PDFReference getActionRef(String string, Requester requester) throws Exception {
        return (PDFReference)this.getActions(requester).get(string);
    }

    protected Hashtable getActions(Requester requester) throws Exception {
        this.handleRequest(requester);
        return this.actions;
    }

    public static PDFReference getAdditionalAction(String string, PDFReference pDFReference, Requester requester) throws Exception {
        VAdditionalAction.initProvider();
        VAdditionalAction vAdditionalAction = (VAdditionalAction)pDFReference.getExtensionData(VAdditionalActionTable_K);
        return vAdditionalAction.getActionRef(string, requester);
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new ExtensionDataProvider(){

                public Object provide(String string, Extensible extensible) {
                    Assert.notFalse(extensible instanceof PDFReference);
                    PDFReference pDFReference = (PDFReference)extensible;
                    if (string.equals(VAdditionalAction.VAdditionalActionTable_K)) {
                        return new VAdditionalAction(pDFReference);
                    }
                    throw new ProviderNotFoundException(string);
                }
            };
            Extension.registerProvider(VAdditionalActionTable_K, provider);
        }
    }
}

