/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.pdf.Function;
import com.adobe.acrobat.pdf.VFunction;
import com.adobe.acrobat.pdf.VPDFColorModelImageMultiplexer;
import com.adobe.acrobat.pdf.VPDFColorModelInlineImageMultiplexer;
import com.adobe.acrobat.pdf.VPDFColorModelMultiplexer;
import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.pdf.image.PDFColorParams;
import com.adobe.acrobat.pdfobjstore.PDFArray;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.VValue;
import com.adobe.util.Assert;
import com.adobe.util.MemUtil;
import java.io.InputStream;
import java.util.Hashtable;

public class VPDFColorModel
extends VValue {
    static final String VPDFColorModelTable_K = "VPDFColorModelTable";
    static final String VPDFColorModelMultiplexer_K = "VPDFColorModelMultiplexer";
    static final String VPDFColorModelImageMultiplexer_K = "VPDFColorModelImageMultiplexer";
    static final String VPDFColorModelInlineImageMultiplexer_K = "VPDFColorModelInlineImageMultiplexer";
    private static ExtensionDataProvider provider = null;
    static final String BPC_K = "BPC";
    static final String BitsPerComponent_K = "BitsPerComponent";
    static final String D_K = "D";
    static final String Decode_K = "Decode";
    static final String CS_K = "CS";
    static final String ColorSpace_K = "ColorSpace";
    static final String IM_K = "IM";
    static final String ImageMask_K = "ImageMask";
    static final String Mask_K = "Mask";
    static final String WhitePt_K = "WhitePt";
    static final String BlackPt_K = "BlackPt";
    static final String Gamma_K = "Gamma";
    static final String Matrix_K = "Matrix";
    static final String Range_K = "Range";
    static final String CMYK_K = "CMYK";
    static final String DeviceCMYK_K = "DeviceCMYK";
    static final String DefaultCMYK_K = "DefaultCMYK";
    static final String RGB_K = "RGB";
    static final String DeviceRGB_K = "DeviceRGB";
    static final String DefaultRGB_K = "DefaultRGB";
    static final String CalRGB_K = "CalRGB";
    static final String G_K = "G";
    static final String DeviceGray_K = "DeviceGray";
    static final String DefaultGray_K = "DefaultGray";
    static final String CalGray_K = "CalGray";
    static final String Lab_K = "Lab";
    static final String I_K = "I";
    static final String Indexed_K = "Indexed";
    static final String Pattern_K = "Pattern";
    static final String Separation_K = "Separation";
    static final String DeviceN_K = "DeviceN";
    static final String ICCBased_K = "ICCBased";
    static final String N_K = "N";
    static final String Alternate_K = "Alternate";
    private PDFColorParams colorParams;
    private PDFColorModel colorModel;
    private PDFReference resRef;
    private String csName;
    private PDFReference colorDict;
    private boolean isImage;
    private boolean inline;
    private boolean inDefault;

    protected VPDFColorModel(String string, PDFReference pDFReference, boolean bl, boolean bl2, PDFReference pDFReference2) {
        this.resRef = pDFReference2;
        this.colorDict = pDFReference;
        this.isImage = bl;
        this.inline = bl2;
        this.csName = string;
        this.colorModel = null;
    }

    private PDFColorParams colorFromKey(String string, Requester requester) throws Exception {
        PDFColorParams pDFColorParams = this.simpleColorFromKey(string, this.inline);
        if (pDFColorParams == null) {
            pDFColorParams = this.inline && string.equals(RGB_K) || string.equals(DeviceRGB_K) ? this.resourceColorFromKey(DefaultRGB_K, requester) : (this.inline && string.equals(G_K) || string.equals(DeviceGray_K) ? this.resourceColorFromKey(DefaultGray_K, requester) : (this.inline && string.equals(CMYK_K) || string.equals(DeviceCMYK_K) ? this.resourceColorFromKey(DefaultCMYK_K, requester) : this.resourceColorFromKey(string, requester)));
        }
        return pDFColorParams;
    }

    public PDFColorModel colorModel(Requester requester) throws Exception {
        this.handleRequest(requester);
        return this.colorModel;
    }

    protected final void compute(Requester requester) throws Exception {
        this.colorModel = this.computeColorParams(requester).getColorModel();
    }

    protected PDFColorParams computeColorParams(Requester requester) throws Exception {
        PDFColorParams pDFColorParams = null;
        this.inDefault = false;
        if (this.isImage) {
            PDFObj pDFObj;
            PDFDict pDFDict = this.colorDict.dictValue(requester);
            if (this.inline && pDFDict.hasKey(CS_K)) {
                pDFColorParams = this.getColorParams(pDFDict.get(CS_K), requester);
            } else if (pDFDict.hasKey(ColorSpace_K)) {
                pDFColorParams = this.getColorParams(pDFDict.get(ColorSpace_K), requester);
            } else if (pDFDict.hasKey(IM_K) || pDFDict.hasKey(ImageMask_K)) {
                pDFColorParams = new PDFColorParams(7);
            } else {
                throw new Exception("Missing ColorSpace in Image");
            }
            if (this.inline && pDFDict.hasKey(BPC_K)) {
                pDFColorParams.setBitsPerComponent(pDFDict.get(BPC_K).integerValue(requester));
            } else if (pDFDict.hasKey(BitsPerComponent_K)) {
                pDFColorParams.setBitsPerComponent(pDFDict.get(BitsPerComponent_K).integerValue(requester));
            }
            if (this.inline && pDFDict.hasKey(D_K)) {
                pDFColorParams.setDecode(this.getFloatVector(pDFDict.get(D_K), requester));
            } else if (pDFDict.hasKey(Decode_K)) {
                pDFColorParams.setDecode(this.getFloatVector(pDFDict.get(Decode_K), requester));
            }
            if (pDFDict.hasKey(Mask_K) && (pDFObj = pDFDict.get(Mask_K)).type(requester) == 7) {
                pDFColorParams.setAlphaMask(this.getIntVector(pDFObj, requester));
            }
        } else if (this.colorDict != null) {
            PDFDict pDFDict = this.colorDict.dictValue(requester);
            pDFColorParams = this.getColorParams(pDFDict.get(ColorSpace_K), requester);
        } else if (this.csName != null) {
            pDFColorParams = this.colorFromKey(this.csName, requester);
        }
        return pDFColorParams;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PDFColorParams getColorParams(PDFObj pDFObj, Requester requester) throws Exception {
        PDFColorParams pDFColorParams = null;
        if (pDFObj.type(requester) == 7) {
            PDFArray pDFArray = pDFObj.arrayValue(requester);
            pDFColorParams = this.getColorParams(pDFArray.get(0), requester);
            if (pDFColorParams.getPDFColorSpace() == 20) {
                PDFColorModel pDFColorModel = this.getColorParams(pDFArray.get(1), requester).getColorModel();
                int n = pDFColorModel.getNumComponents();
                int n2 = pDFArray.get(2).integerValue(requester);
                byte[] byArray = this.getSetup(n * (n2 + 1), pDFArray.get(3), requester);
                pDFColorParams.setIndexed(pDFColorModel, n2, byArray);
                return pDFColorParams;
            } else if (pDFColorParams.getPDFColorSpace() == 21) {
                if (pDFArray.size() <= 1) return pDFColorParams;
                PDFColorModel pDFColorModel = this.getColorParams(pDFArray.get(1), requester).getColorModel();
                pDFColorParams.setBaseModel(pDFColorModel);
                return pDFColorParams;
            } else if (pDFColorParams.getPDFColorSpace() == 10) {
                int n = 1;
                PDFObj pDFObj2 = pDFArray.get(1);
                if (pDFObj2.type(requester) == 7) {
                    n = pDFObj2.arrayValue(requester).size();
                }
                pDFColorParams.setNumComponents(n);
                PDFColorModel pDFColorModel = this.getColorParams(pDFArray.get(2), requester).getColorModel();
                Function function = VFunction.function(pDFArray.get(3), requester);
                pDFColorParams.setBaseModel(pDFColorModel);
                pDFColorParams.setTintTransform(function);
                return pDFColorParams;
            } else {
                if (pDFColorParams.getPDFColorSpace() == 11) {
                    int n = 1;
                    PDFDict pDFDict = pDFArray.get(1).dictValue(requester);
                    if (pDFDict.hasKey(N_K)) {
                        n = pDFDict.get(N_K).integerValue(requester);
                    }
                    if (pDFDict.hasKey(Alternate_K)) {
                        return this.getColorParams(pDFDict.get(Alternate_K), requester);
                    }
                    switch (n) {
                        case 1: {
                            return new PDFColorParams(5);
                        }
                        case 3: {
                            return new PDFColorParams(0);
                        }
                        case 4: {
                            return new PDFColorParams(2);
                        }
                        default: {
                            return pDFColorParams;
                        }
                    }
                }
                PDFDict pDFDict = pDFArray.get(1).dictValue(requester);
                if (pDFDict.hasKey(WhitePt_K)) {
                    pDFColorParams.setWhitePt(this.getFloatVector(pDFDict.get(WhitePt_K), requester));
                }
                if (pDFDict.hasKey(BlackPt_K)) {
                    pDFColorParams.setBlackPt(this.getFloatVector(pDFDict.get(BlackPt_K), requester));
                }
                if (pDFDict.hasKey(Gamma_K)) {
                    pDFColorParams.setGamma(this.getFloatVector(pDFDict.get(Gamma_K), requester));
                }
                if (pDFDict.hasKey(Matrix_K)) {
                    pDFColorParams.setMatrix(this.getFloatVector(pDFDict.get(Matrix_K), requester));
                }
                if (!pDFDict.hasKey(Range_K)) return pDFColorParams;
                pDFColorParams.setRange(this.getFloatVector(pDFDict.get(Range_K), requester));
            }
            return pDFColorParams;
        } else {
            String string = pDFObj.nameValue(requester);
            pDFColorParams = this.simpleColorFromKey(string, this.inline);
            if (pDFColorParams != null) return pDFColorParams;
            VPDFColorModel vPDFColorModel = new VPDFColorModel(pDFObj.nameValue(requester), null, false, this.inline, this.resRef);
            return vPDFColorModel.colorModel(requester).getParams();
        }
    }

    private float[] getFloatVector(PDFObj pDFObj, Requester requester) throws Exception {
        float[] fArray = null;
        if (pDFObj != null) {
            if (pDFObj.type(requester) == 7) {
                PDFArray pDFArray = pDFObj.arrayValue(requester);
                int n = pDFArray.size();
                fArray = MemUtil.allocFloat(n);
                int n2 = 0;
                while (n2 < n) {
                    fArray[n2] = pDFArray.get(n2).floatValue(requester);
                    ++n2;
                }
            } else {
                fArray = new float[]{pDFObj.floatValue(requester)};
            }
        }
        return fArray;
    }

    private int[] getIntVector(PDFObj pDFObj, Requester requester) throws Exception {
        int[] nArray = null;
        if (pDFObj != null) {
            if (pDFObj.type(requester) == 7) {
                PDFArray pDFArray = pDFObj.arrayValue(requester);
                int n = pDFArray.size();
                nArray = MemUtil.allocInt(n);
                int n2 = 0;
                while (n2 < n) {
                    nArray[n2] = pDFArray.get(n2).integerValue(requester);
                    ++n2;
                }
            } else {
                nArray = new int[]{pDFObj.integerValue(requester)};
            }
        }
        return nArray;
    }

    private byte[] getSetup(int n, PDFObj pDFObj, Requester requester) throws Exception {
        byte[] byArray = MemUtil.allocByte(n);
        if (pDFObj != null) {
            if (pDFObj.type(requester) == 4) {
                String string = pDFObj.stringValue(requester);
                byte[] byArray2 = Util.rawBytesFromString(string);
                System.arraycopy(byArray2, 0, byArray, 0, Math.min(n, string.length()));
            } else {
                InputStream inputStream = pDFObj.pdfReferenceValue(requester).getFilteredVStreamFactory().streamFactoryValue(requester).getInputStream();
                inputStream.read(byArray);
            }
        }
        return byArray;
    }

    public static VPDFColorModel getVPDFColorModel(PDFReference pDFReference, PDFReference pDFReference2) throws Exception {
        VPDFColorModel.initProvider();
        VPDFColorModelMultiplexer vPDFColorModelMultiplexer = (VPDFColorModelMultiplexer)pDFReference.getExtensionData(VPDFColorModelMultiplexer_K);
        return (VPDFColorModel)vPDFColorModelMultiplexer.getVObjectForResources(pDFReference2);
    }

    public static VPDFColorModel getVPDFColorModel(PDFReference pDFReference, boolean bl, PDFReference pDFReference2) throws Exception {
        VPDFColorModel.initProvider();
        if (bl) {
            VPDFColorModelInlineImageMultiplexer vPDFColorModelInlineImageMultiplexer = (VPDFColorModelInlineImageMultiplexer)pDFReference.getExtensionData(VPDFColorModelInlineImageMultiplexer_K);
            return (VPDFColorModel)vPDFColorModelInlineImageMultiplexer.getVObjectForResources(pDFReference2);
        }
        VPDFColorModelImageMultiplexer vPDFColorModelImageMultiplexer = (VPDFColorModelImageMultiplexer)pDFReference.getExtensionData(VPDFColorModelImageMultiplexer_K);
        return (VPDFColorModel)vPDFColorModelImageMultiplexer.getVObjectForResources(pDFReference2);
    }

    public static VPDFColorModel getVPDFColorModel(String string, PDFReference pDFReference) throws Exception {
        VPDFColorModel.initProvider();
        Hashtable hashtable = (Hashtable)pDFReference.getExtensionData(VPDFColorModelTable_K);
        VPDFColorModel vPDFColorModel = (VPDFColorModel)hashtable.get(string);
        if (vPDFColorModel == null) {
            vPDFColorModel = new VPDFColorModel(string, null, false, false, pDFReference);
            hashtable.put(string, vPDFColorModel);
        }
        return vPDFColorModel;
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new ExtensionDataProvider(){

                public Object provide(String string, Extensible extensible) {
                    Assert.notFalse(extensible instanceof PDFReference);
                    if (string.equals(VPDFColorModel.VPDFColorModelInlineImageMultiplexer_K)) {
                        return new VPDFColorModelInlineImageMultiplexer((PDFReference)extensible);
                    }
                    if (string.equals(VPDFColorModel.VPDFColorModelImageMultiplexer_K)) {
                        return new VPDFColorModelImageMultiplexer((PDFReference)extensible);
                    }
                    if (string.equals(VPDFColorModel.VPDFColorModelMultiplexer_K)) {
                        return new VPDFColorModelMultiplexer((PDFReference)extensible);
                    }
                    if (string.equals(VPDFColorModel.VPDFColorModelTable_K)) {
                        return new Hashtable(19);
                    }
                    throw new ProviderNotFoundException(string);
                }
            };
            Extension.registerProvider(VPDFColorModelInlineImageMultiplexer_K, provider);
            Extension.registerProvider(VPDFColorModelImageMultiplexer_K, provider);
            Extension.registerProvider(VPDFColorModelMultiplexer_K, provider);
            Extension.registerProvider(VPDFColorModelTable_K, provider);
        }
    }

    private PDFColorParams resourceColorFromKey(String string, Requester requester) throws Exception {
        PDFDict pDFDict;
        PDFObj pDFObj = null;
        PDFColorParams pDFColorParams = null;
        if (this.resRef != null && (pDFDict = this.resRef.dictValue(requester)).hasKey(ColorSpace_K) && (pDFDict = pDFDict.get(ColorSpace_K).dictValue(requester)).hasKey(string)) {
            pDFObj = pDFDict.get(string);
        }
        if (string.equals(DefaultRGB_K)) {
            if (this.inDefault || pDFObj == null || pDFObj.type(requester) == 5 && pDFObj.nameValue(requester).equals(DeviceRGB_K)) {
                pDFColorParams = new PDFColorParams(0);
            } else {
                this.inDefault = true;
            }
        } else if (string.equals(DefaultGray_K)) {
            if (this.inDefault || pDFObj == null || pDFObj.type(requester) == 5 && pDFObj.nameValue(requester).equals(DeviceGray_K)) {
                pDFColorParams = new PDFColorParams(5);
            } else {
                this.inDefault = true;
            }
        } else if (string.equals(DefaultCMYK_K)) {
            if (this.inDefault || pDFObj == null || pDFObj.type(requester) == 5 && pDFObj.nameValue(requester).equals(DeviceCMYK_K)) {
                pDFColorParams = new PDFColorParams(2);
            } else {
                this.inDefault = true;
            }
        }
        if (pDFColorParams == null && pDFObj != null) {
            pDFColorParams = this.getColorParams(pDFObj, requester);
        }
        return pDFColorParams;
    }

    private PDFColorParams simpleColorFromKey(String string, boolean bl) throws Exception {
        PDFColorParams pDFColorParams = null;
        if (string.equals(CalRGB_K)) {
            pDFColorParams = new PDFColorParams(1);
        } else if (string.equals(CalGray_K)) {
            pDFColorParams = new PDFColorParams(6);
        } else if (bl && string.equals(I_K) || string.equals(Indexed_K)) {
            pDFColorParams = new PDFColorParams(20);
        } else if (string.equals(Lab_K)) {
            pDFColorParams = new PDFColorParams(4);
        } else if (string.equals(Pattern_K)) {
            pDFColorParams = new PDFColorParams(21);
        } else if (string.equals(Separation_K) || string.equals(DeviceN_K)) {
            pDFColorParams = new PDFColorParams(10);
        } else if (string.equals(ICCBased_K)) {
            pDFColorParams = new PDFColorParams(11);
        } else if (this.inDefault) {
            if (bl && string.equals(RGB_K) || string.equals(DeviceRGB_K)) {
                pDFColorParams = new PDFColorParams(0);
            } else if (bl && string.equals(G_K) || string.equals(DeviceGray_K)) {
                pDFColorParams = new PDFColorParams(5);
            } else if (bl && string.equals(CMYK_K) || string.equals(DeviceCMYK_K)) {
                pDFColorParams = new PDFColorParams(2);
            }
        }
        return pDFColorParams;
    }
}

