/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.pdf.Document;
import com.adobe.acrobat.pdf.VPageRefByNumProvider;
import com.adobe.acrobat.pdf.VPageTreeNodeProps;
import com.adobe.acrobat.pdfobjstore.LinearizerInfo;
import com.adobe.acrobat.pdfobjstore.PDFArray;
import com.adobe.acrobat.pdfobjstore.PDFNullRef;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.VPDFObjStore;
import com.adobe.acrobat.pdfobjstore.VPDFReference;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.ExtensibleProxy;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.notify.Requester;
import java.util.Hashtable;

public class VPageRefByNum
extends VPDFReference {
    static final String VPageRefByNumTable_K = "VPageRefByNumTable";
    private static VPageRefByNumProvider provider = null;
    private ExtensibleProxy exProxy = new ExtensibleProxy(this);
    private static final String Kids_K = "Kids";
    int pageNum;
    Object store;

    VPageRefByNum(Object object, int n) {
        this.pageNum = n;
        this.store = object;
    }

    protected PDFReference computeReference(Requester requester) throws Exception {
        PDFObjStore pDFObjStore = this.store instanceof PDFObjStore ? (PDFObjStore)this.store : ((VPDFObjStore)this.store).pdfObjStoreValue(requester);
        LinearizerInfo linearizerInfo = pDFObjStore.getVLinearizerInfo().linearizerInfoValue(requester);
        if (linearizerInfo.isLinearized() && this.pageNum == linearizerInfo.getFirstPageNum()) {
            return pDFObjStore.getPDFIndirectObj(linearizerInfo.getFirstPageID(), (short)0);
        }
        PDFReference pDFReference = Document.getPageTreeRoot(pDFObjStore).pdfReferenceValue(requester);
        VPageTreeNodeProps vPageTreeNodeProps = VPageTreeNodeProps.getVPageTreeNodeProps(pDFReference);
        PDFReference pDFReference2 = this.findNthChildIn(pDFReference, vPageTreeNodeProps, this.pageNum, requester);
        return pDFReference2;
    }

    private PDFReference findNthChildIn(PDFReference pDFReference, VPageTreeNodeProps vPageTreeNodeProps, int n, Requester requester) throws Exception {
        if (vPageTreeNodeProps.isPage(requester)) {
            if (n == 0) {
                return pDFReference;
            }
            return PDFNullRef.getPDFNullRef();
        }
        if (vPageTreeNodeProps.isPageNode(requester)) {
            if (n < vPageTreeNodeProps.numChildren(requester)) {
                PDFArray pDFArray = pDFReference.dictValue(requester).get(Kids_K).arrayValue(requester);
                int n2 = 0;
                while (n2 < pDFArray.size()) {
                    PDFReference pDFReference2 = pDFArray.get(n2).pdfReferenceValue(requester);
                    VPageTreeNodeProps vPageTreeNodeProps2 = VPageTreeNodeProps.getVPageTreeNodeProps(pDFReference2);
                    int n3 = vPageTreeNodeProps2.numChildren(requester);
                    if (n < n3) {
                        return this.findNthChildIn(pDFReference2, vPageTreeNodeProps2, n, requester);
                    }
                    n -= n3;
                    ++n2;
                }
                return PDFNullRef.getPDFNullRef();
            }
            return PDFNullRef.getPDFNullRef();
        }
        return PDFNullRef.getPDFNullRef();
    }

    public String getInfo(int n) {
        String string = super.getInfo(n);
        if (n == 1) {
            string = String.valueOf(string) + " [" + this.pageNum + "]";
        }
        return string;
    }

    public static VPDFReference getVPageRefByNum(PDFObjStore pDFObjStore, int n) {
        return VPageRefByNum.getVPageRefByNum((Extensible)pDFObjStore, n);
    }

    public static VPDFReference getVPageRefByNum(VPDFObjStore vPDFObjStore, int n) {
        return VPageRefByNum.getVPageRefByNum((Extensible)vPDFObjStore, n);
    }

    private static VPDFReference getVPageRefByNum(Extensible extensible, int n) {
        Hashtable hashtable;
        VPageRefByNum.initProvider();
        Hashtable hashtable2 = hashtable = (Hashtable)extensible.getExtensionData(VPageRefByNumTable_K);
        synchronized (hashtable2) {
            Integer n2 = new Integer(n);
            if (hashtable.containsKey(n2)) {
                VPDFReference vPDFReference = (VPDFReference)hashtable.get(n2);
                Object var5_7 = null;
                return vPDFReference;
            }
            VPageRefByNum vPageRefByNum = new VPageRefByNum(extensible, n);
            hashtable.put(n2, vPageRefByNum);
            VPageRefByNum vPageRefByNum2 = vPageRefByNum;
            Object var5_8 = null;
            return vPageRefByNum2;
        }
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new VPageRefByNumProvider();
            Extension.registerProvider(VPageRefByNumTable_K, provider);
        }
    }
}

