/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf.image;

import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.pdf.image.PDFColorParams;
import com.adobe.util.MemUtil;
import java.awt.image.ColorModel;

public class DeviceCMYKColorModel
extends PDFColorModel {
    private byte[] c_decode;
    private byte[] m_decode;
    private byte[] y_decode;
    private byte[] k_decode;

    public DeviceCMYKColorModel() {
        this(new PDFColorParams(2));
    }

    public DeviceCMYKColorModel(PDFColorParams pDFColorParams) {
        super(pDFColorParams);
        float[] fArray = pDFColorParams.getDecode();
        if (fArray != null && fArray.length >= 8 && (fArray[0] != 0.0f || fArray[1] != 1.0f || fArray[2] != 0.0f || fArray[3] != 1.0f || fArray[4] != 0.0f || fArray[5] != 1.0f || fArray[6] != 0.0f || fArray[7] != 1.0f)) {
            this.c_decode = MemUtil.allocByte(256);
            float f = fArray[0];
            float f2 = fArray[1] - f;
            int n = 0;
            while (n < 256) {
                this.c_decode[n] = (byte)Math.max(0, Math.min(255, Math.round(f + (float)n * f2)));
                ++n;
            }
            this.m_decode = MemUtil.allocByte(256);
            f = fArray[2];
            f2 = fArray[3] - f;
            int n2 = 0;
            while (n2 < 256) {
                this.m_decode[n2] = (byte)Math.max(0, Math.min(255, Math.round(f + (float)n2 * f2)));
                ++n2;
            }
            this.y_decode = MemUtil.allocByte(256);
            f = fArray[4];
            f2 = fArray[5] - f;
            int n3 = 0;
            while (n3 < 256) {
                this.y_decode[n3] = (byte)Math.max(0, Math.min(255, Math.round(f + (float)n3 * f2)));
                ++n3;
            }
            this.k_decode = MemUtil.allocByte(256);
            f = fArray[6];
            f2 = fArray[7] - f;
            int n4 = 0;
            while (n4 < 256) {
                this.k_decode[n4] = (byte)Math.max(0, Math.min(255, Math.round(f + (float)n4 * f2)));
                ++n4;
            }
        }
    }

    public int getAlpha(int n) {
        return 255;
    }

    public float[] getBlack() {
        float[] fArray = new float[4];
        fArray[2] = 0.0f;
        fArray[1] = 0.0f;
        fArray[0] = 0.0f;
        fArray[3] = 1.0f;
        return fArray;
    }

    public int getBlue(int n) {
        return this.getRGB(n) & 0xFF;
    }

    public int getGreen(int n) {
        return this.getRGB(n) >>> 8 & 0xFF;
    }

    public ColorModel getJavaColorModel() {
        return ColorModel.getRGBdefault();
    }

    public int getRGB(float f, float f2, float f3, float f4) {
        int n = 255 - Math.max(0, Math.min(255, Math.round(255.0f * (f + f4))));
        int n2 = 255 - Math.max(0, Math.min(255, Math.round(255.0f * (f2 + f4))));
        int n3 = 255 - Math.max(0, Math.min(255, Math.round(255.0f * (f3 + f4))));
        return -16777216 + (n << 16) + (n2 << 8) + n3;
    }

    public int getRGB(int n) {
        return this.getRGB((float)(n >>> 24 & 0xFF) / 255.0f, (float)(n >>> 16 & 0xFF) / 255.0f, (float)(n >>> 8 & 0xFF) / 255.0f, (float)(n & 0xFF) / 255.0f);
    }

    public int getRGB(float[] fArray) {
        if (fArray.length >= 4) {
            return this.getRGB(fArray[0], fArray[1], fArray[2], fArray[3]);
        }
        throw new RuntimeException("DeviceCMYKColorModel.getRGB(c[]) -- arrayToShort");
    }

    public int getRed(int n) {
        return this.getRGB(n) >>> 16 & 0xFF;
    }

    public void toRGB(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        float[] fArray = this.params.getDecode();
        int[] nArray2 = this.params.getAlphaMask();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        int n13 = 0;
        while (n13 < n3) {
            n4 = byArray[n] & 0xFF;
            n5 = byArray[n + 1] & 0xFF;
            n6 = byArray[n + 2] & 0xFF;
            n7 = byArray[n + 3] & 0xFF;
            n += 4;
            if (n4 == n9 && n5 == n10 && n6 == n11 && n7 == n12) {
                nArray[n2 + n13] = n8;
            } else if (nArray2 != null && nArray2[0] <= n4 && n4 <= nArray2[1] && nArray2[2] <= n5 && n5 <= nArray2[3] && nArray2[4] <= n6 && n6 <= nArray2[5] && nArray2[6] <= n7 && n7 <= nArray2[7]) {
                n9 = n4;
                n10 = n5;
                n11 = n6;
                n12 = n7;
                n8 = 0;
                nArray[n2 + n13] = 0;
            } else {
                n9 = n4;
                n10 = n5;
                n11 = n6;
                n12 = n7;
                if (this.k_decode != null) {
                    n4 = this.c_decode[n4] & 0xFF;
                    n5 = this.m_decode[n5] & 0xFF;
                    n6 = this.y_decode[n6] & 0xFF;
                    n7 = this.k_decode[n7] & 0xFF;
                }
                nArray[n2 + n13] = n8 = ~((Math.min(255, n4 + n7) << 16) + (Math.min(255, n5 + n7) << 8) + Math.min(255, n6 + n7));
            }
            ++n13;
        }
    }

    public String toString() {
        return "DeviceCMYK";
    }
}

