/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf.image;

import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.pdf.image.PDFColorParams;
import com.adobe.util.MemUtil;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class IndexedColorModel
extends PDFColorModel {
    private int map_size;
    private byte[] alpha;
    private byte[] red;
    private byte[] green;
    private byte[] blue;
    private int[] rgb;
    private ColorModel javaColorModel;

    public IndexedColorModel() {
        this(new PDFColorParams(20));
    }

    public IndexedColorModel(PDFColorParams pDFColorParams) {
        super(pDFColorParams);
        int n = pDFColorParams.getBitsPerComponent();
        float[] fArray = pDFColorParams.getDecode();
        int n2 = pDFColorParams.getHiVal();
        PDFColorModel pDFColorModel = pDFColorParams.getBaseModel();
        byte[] byArray = pDFColorParams.getLookup();
        int[] nArray = pDFColorParams.getAlphaMask();
        if (nArray != null && n != 8) {
            int n3 = 0;
            while (n3 < 2) {
                int n4 = n3++;
                nArray[n4] = nArray[n4] >>> 8 - n;
            }
        }
        if (pDFColorModel != null) {
            if (++n2 > 256) {
                n2 = 256;
            }
            byte[] byArray2 = MemUtil.allocByte(n2);
            byte[] byArray3 = MemUtil.allocByte(n2);
            byte[] byArray4 = MemUtil.allocByte(n2);
            byte[] byArray5 = MemUtil.allocByte(n2);
            int[] nArray2 = MemUtil.allocInt(n2);
            int n5 = pDFColorModel.getNumComponents();
            int n6 = 0;
            int n7 = 0;
            while (n7 < n2) {
                int n8 = 255;
                int n9 = 0;
                while (n9 < n5) {
                    n8 <<= 8;
                    if (n6 < byArray.length) {
                        n8 += byArray[n6++] & 0xFF;
                    }
                    ++n9;
                }
                if (nArray != null && nArray[0] <= n7 && n7 <= nArray[1]) {
                    nArray2[n7] = 0;
                    byArray5[n7] = 0;
                    byArray4[n7] = 0;
                    byArray3[n7] = 0;
                    byArray2[n7] = 0;
                } else {
                    nArray2[n7] = pDFColorModel.getRGB(n8);
                    byArray2[n7] = (byte)(nArray2[n7] >>> 24);
                    byArray3[n7] = (byte)(nArray2[n7] >>> 16);
                    byArray4[n7] = (byte)(nArray2[n7] >>> 8);
                    byArray5[n7] = (byte)nArray2[n7];
                }
                ++n7;
            }
            this.map_size = n < 8 ? 1 << n : 256;
            if (this.map_size >= n2 && (fArray == null || fArray.length < 2 || fArray[0] == 0.0f && fArray[1] == (float)(this.map_size - 1))) {
                while (this.map_size >= n2 + n2) {
                    this.map_size >>= 1;
                }
                if (this.map_size == n2) {
                    this.alpha = byArray2;
                    this.red = byArray3;
                    this.green = byArray4;
                    this.blue = byArray5;
                    this.rgb = nArray2;
                } else {
                    this.alpha = MemUtil.allocByte(this.map_size);
                    this.red = MemUtil.allocByte(this.map_size);
                    this.green = MemUtil.allocByte(this.map_size);
                    this.blue = MemUtil.allocByte(this.map_size);
                    this.rgb = MemUtil.allocInt(this.map_size);
                    System.arraycopy(byArray2, 0, this.alpha, 0, n2);
                    System.arraycopy(byArray3, 0, this.red, 0, n2);
                    System.arraycopy(byArray4, 0, this.green, 0, n2);
                    System.arraycopy(byArray5, 0, this.blue, 0, n2);
                    System.arraycopy(nArray2, 0, this.rgb, 0, n2);
                }
            } else {
                this.alpha = MemUtil.allocByte(this.map_size);
                this.red = MemUtil.allocByte(this.map_size);
                this.green = MemUtil.allocByte(this.map_size);
                this.blue = MemUtil.allocByte(this.map_size);
                this.rgb = MemUtil.allocInt(this.map_size);
                float f = 0.0f;
                float f2 = this.map_size - 1;
                if (fArray != null) {
                    f = fArray[0];
                    f2 = fArray[1] - fArray[0];
                }
                int n10 = 0;
                while (n10 < this.map_size) {
                    int n11 = Math.max(0, Math.min(n2 - 1, Math.round(f + (float)n10 * f2 / (float)(this.map_size - 1))));
                    this.alpha[n10] = byArray2[n11];
                    this.red[n10] = byArray3[n11];
                    this.green[n10] = byArray4[n11];
                    this.blue[n10] = byArray5[n11];
                    this.rgb[n10] = nArray2[n11];
                    ++n10;
                }
            }
        }
    }

    public static IndexedColorModel fromJavaColorModel(ColorModel colorModel) {
        IndexedColorModel indexedColorModel = new IndexedColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            indexedColorModel.map_size = indexColorModel.getMapSize();
            indexedColorModel.alpha = MemUtil.allocByte(indexedColorModel.map_size);
            indexedColorModel.red = MemUtil.allocByte(indexedColorModel.map_size);
            indexedColorModel.green = MemUtil.allocByte(indexedColorModel.map_size);
            indexedColorModel.blue = MemUtil.allocByte(indexedColorModel.map_size);
            indexColorModel.getAlphas(indexedColorModel.alpha);
            indexColorModel.getReds(indexedColorModel.red);
            indexColorModel.getGreens(indexedColorModel.green);
            indexColorModel.getBlues(indexedColorModel.blue);
            indexedColorModel.rgb = MemUtil.allocInt(indexedColorModel.map_size);
            int n = 0;
            while (n < indexedColorModel.map_size) {
                indexedColorModel.rgb[n] = (indexedColorModel.alpha[n] << 24) + (indexedColorModel.red[n] << 16) + (indexedColorModel.green[n] << 8) + indexedColorModel.blue[n];
                ++n;
            }
        }
        return indexedColorModel;
    }

    public int getAlpha(int n) {
        int n2 = this.map_size - 1;
        return this.alpha[n & n2] & 0xFF;
    }

    public float[] getBaseColor(float f) {
        int n;
        PDFColorModel pDFColorModel = this.params.getBaseModel();
        int n2 = (int)f;
        byte[] byArray = this.params.getLookup();
        if (n2 >= byArray.length / (n = pDFColorModel.getNumComponents())) {
            n2 = byArray.length / n - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        float[] fArray = new float[n];
        n2 *= n;
        int n3 = 0;
        while (n3 < n) {
            fArray[n3] = (float)((double)(byArray[n2++] & 0xFF) / 255.0);
            ++n3;
        }
        return fArray;
    }

    public PDFColorModel getBaseColorModel() {
        return this.params.getBaseModel();
    }

    public float[] getBlack() {
        float[] fArray = new float[]{0.0f};
        return fArray;
    }

    public int getBlue(int n) {
        int n2 = this.map_size - 1;
        return this.blue[n & n2] & 0xFF;
    }

    public int getGreen(int n) {
        int n2 = this.map_size - 1;
        return this.green[n & n2] & 0xFF;
    }

    public ColorModel getJavaColorModel() {
        if (this.javaColorModel == null) {
            this.javaColorModel = new IndexColorModel(this.params.getBitsPerComponent(), this.map_size, this.red, this.green, this.blue, this.alpha);
        }
        return this.javaColorModel;
    }

    public int getRGB(float f) {
        int n = Math.max(0, Math.min(this.map_size - 1, (int)f));
        return ((this.alpha[n] & 0xFF) << 24) + ((this.red[n] & 0xFF) << 16) + ((this.green[n] & 0xFF) << 8) + (this.blue[n] & 0xFF);
    }

    public int getRGB(int n) {
        int n2 = this.map_size - 1;
        return this.rgb[n & n2];
    }

    public int getRGB(float[] fArray) {
        if (fArray.length >= 1) {
            return this.getRGB(fArray[0]);
        }
        throw new RuntimeException("IndexedColorModel.getRGB(c[]) -- arrayToShort");
    }

    public int getRed(int n) {
        int n2 = this.map_size - 1;
        return this.red[n & n2] & 0xFF;
    }

    public String toString() {
        return "Indexed";
    }
}

