/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf.image;

import com.adobe.acrobat.pdf.Function;
import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.pdf.image.ShadeEdge;
import com.adobe.acrobat.pdf.image.Shading;
import com.adobe.acrobat.pdf.image.TPatch;
import com.adobe.acrobat.pdf.image.TriShade;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.sidecar.SidecarImage;
import com.adobe.pe.util.StreamFactory;
import com.adobe.util.MemUtil;
import java.awt.Rectangle;
import java.io.InputStream;
import java.util.Enumeration;

public class MeshShading
extends Shading {
    protected int bpCoord;
    protected int bpComp;
    protected int bpFlag;
    protected int vpRow;
    protected float[] decode;
    protected Function[] funcs;
    protected StreamFactory pestm;

    public MeshShading(int n, PDFColorModel pDFColorModel, float[] fArray, FloatRect floatRect, boolean bl, int n2, int n3, int n4, int n5, float[] fArray2, Function[] functionArray, StreamFactory streamFactory) {
        super(n, pDFColorModel, fArray, floatRect, bl);
        this.bpCoord = n2;
        this.bpComp = n3;
        this.bpFlag = n4;
        this.vpRow = n5;
        this.decode = fArray2;
        this.funcs = functionArray;
        this.pestm = streamFactory;
    }

    public SidecarImage shadingImage(AffineTransform affineTransform, Rectangle rectangle) throws Exception {
        Object object;
        int n = 0;
        int n2 = 0;
        int[] nArray = null;
        if (!rectangle.isEmpty()) {
            object = this.pestm.getInputStream();
            FloatRect floatRect = null;
            Enumeration enumeration = null;
            switch (this.subtype) {
                case 4: {
                    this.vpRow = 0;
                }
                case 5: {
                    Object object2 = TriShade.ReadTriangleList((InputStream)object, this.bpCoord, this.bpComp, this.bpFlag, this.decode, this.colorModel, this.vpRow);
                    floatRect = ((TriShade)object2).getBoundingBox();
                    enumeration = ((TriShade)object2).elements(affineTransform);
                    break;
                }
                case 6: {
                    Object object2 = TPatch.ReadPatchList((InputStream)object, this.bpCoord, this.bpComp, this.bpFlag, this.decode, this.colorModel, false);
                    floatRect = ((TPatch)object2).getBoundingBox();
                    enumeration = ((TPatch)object2).elements(affineTransform);
                    break;
                }
                case 7: {
                    Object object2 = TPatch.ReadPatchList((InputStream)object, this.bpCoord, this.bpComp, this.bpFlag, this.decode, this.colorModel, true);
                    floatRect = ((TPatch)object2).getBoundingBox();
                    enumeration = ((TPatch)object2).elements(affineTransform);
                    break;
                }
            }
            rectangle = floatRect.transformRect(affineTransform).toEnclosingRect().intersection(rectangle);
            if (!rectangle.isEmpty()) {
                int n3;
                n = rectangle.height;
                n2 = rectangle.width;
                int n4 = n * n2;
                nArray = MemUtil.allocInt(n4);
                if (this.background != null && (n3 = this.colorModel.getRGB(this.background)) != 0) {
                    MemUtil.arraySet(nArray, 0, n4, new Integer(n3));
                }
                ShadeEdge.fillRGBrect(nArray, rectangle, enumeration, this.colorModel, this.funcs);
            }
        }
        if (nArray == null) {
            nArray = new int[1];
        }
        object = new SidecarImage(n2, n, nArray, 0, n2);
        ((SidecarImage)object).setOrigin(rectangle.x, rectangle.y);
        return object;
    }
}

