/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdfobjstore;

import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.filters.RC4Engine;
import com.adobe.acrobat.pdfobjstore.PDFArray;
import com.adobe.acrobat.pdfobjstore.PDFBoolean;
import com.adobe.acrobat.pdfobjstore.PDFContainer;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFDirectObj;
import com.adobe.acrobat.pdfobjstore.PDFIndirectObj;
import com.adobe.acrobat.pdfobjstore.PDFInteger;
import com.adobe.acrobat.pdfobjstore.PDFName;
import com.adobe.acrobat.pdfobjstore.PDFNull;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReal;
import com.adobe.acrobat.pdfobjstore.PDFString;
import com.adobe.acrobat.pdfobjstore.PEMark;
import com.adobe.acrobat.pdfobjstore.UnexpectedTokenException;
import com.adobe.acrobat.pdfobjstore.UnexpectedTypeException;
import com.adobe.acrobat.pdfobjstore.security.PDFObjCryptKey;
import com.adobe.acrobat.tokenize.Tokenizer;
import com.adobe.util.Assert;
import com.adobe.util.MemUtil;
import java.util.Stack;

class PDFObjParser {
    private Stack stack;
    private PEMark topMark;
    private boolean isInlineImage;
    private PDFObjStore store;
    private PDFObjCryptKey cryptKey;
    private Tokenizer t;
    private ByteArray ba;
    private int start;
    private boolean makeRef;
    private static final String BI_K = "BI";
    private static final String endstream_K = "endstream";
    private static final String ID_K = "ID";
    private static final String R_K = "R";
    private static final String stream_K = "stream";
    private static final String _CloseBracket_K = "]";
    private static final String _CloseDoubleAngleBracket_K = ">>";
    private static final String _OpenBracket_K = "[";
    private static final String _OpenDoubleAngleBracket_K = "<<";
    private static final String true_K = "true";
    private static final String false_K = "false";
    private static final String null_K = "null";
    private static final String Length_K = "Length";

    public PDFObjParser(PDFObjStore pDFObjStore, Tokenizer tokenizer, ByteArray byteArray, int n, boolean bl) {
        this(pDFObjStore, tokenizer, byteArray, n, false, bl);
    }

    public PDFObjParser(PDFObjStore pDFObjStore, Tokenizer tokenizer, ByteArray byteArray, int n, boolean bl, PDFObjCryptKey pDFObjCryptKey) {
        this(pDFObjStore, tokenizer, byteArray, n, false, bl, pDFObjCryptKey);
    }

    public PDFObjParser(PDFObjStore pDFObjStore, Tokenizer tokenizer, ByteArray byteArray, int n, boolean bl, boolean bl2) {
        this(pDFObjStore, tokenizer, byteArray, n, bl, bl2, null);
    }

    public PDFObjParser(PDFObjStore pDFObjStore, Tokenizer tokenizer, ByteArray byteArray, int n, boolean bl, boolean bl2, PDFObjCryptKey pDFObjCryptKey) {
        this.store = pDFObjStore;
        this.t = tokenizer;
        this.ba = byteArray;
        this.start = n;
        this.isInlineImage = bl;
        this.makeRef = bl2;
        this.cryptKey = pDFObjCryptKey;
        this.stack = new Stack();
    }

    public PDFObjParser(Tokenizer tokenizer, boolean bl, boolean bl2) {
        this(null, tokenizer, null, 0, bl, bl2);
    }

    private void executeArray() throws Exception {
        PDFObj pDFObj;
        if (this.topMark == null || this.topMark.markType != 2) {
            throw new UnexpectedTokenException(_CloseBracket_K);
        }
        this.t.nextToken();
        int n = this.stack.size() - this.topMark.stackPos - 1;
        PDFObj[] pDFObjArray = new PDFObj[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            pDFObj = (PDFObj)this.stack.pop();
            Assert.notFalse(pDFObj instanceof PDFContainer ^ true);
            pDFObjArray[n2] = pDFObj;
            --n2;
        }
        this.stack.pop();
        this.topMark = this.topMark.nextMark;
        PDFObj pDFObj2 = pDFObj = new PDFArray(pDFObjArray);
        if (this.stack.size() > 0 || this.makeRef) {
            pDFObj2 = new PDFDirectObj(this.store, (PDFContainer)pDFObj);
        }
        this.stack.push(pDFObj2);
    }

    private void executeDict(int n) throws Exception {
        PDFDict pDFDict;
        if (this.topMark == null || this.topMark.markType != n) {
            throw new UnexpectedTokenException(n == 1 ? _CloseDoubleAngleBracket_K : ID_K);
        }
        if ((this.stack.size() - this.topMark.stackPos - 1) % 2 != 0) {
            throw new UnexpectedTokenException(n == 1 ? _CloseDoubleAngleBracket_K : ID_K);
        }
        int n2 = (this.stack.size() - this.topMark.stackPos - 1) / 2;
        String[] stringArray = new String[n2];
        PDFObj[] pDFObjArray = new PDFObj[n2];
        int n3 = n2;
        while (n3-- > 0) {
            PDFObj pDFObj = (PDFObj)this.stack.pop();
            Assert.notFalse(pDFObj instanceof PDFContainer ^ true);
            pDFObjArray[n3] = pDFObj;
            pDFObj = (PDFObj)this.stack.pop();
            if (!(pDFObj instanceof PDFName)) {
                throw new UnexpectedTypeException(5);
            }
            stringArray[n3] = ((PDFName)pDFObj).nameValue(null);
        }
        this.stack.pop();
        this.topMark = this.topMark.nextMark;
        int n4 = -1;
        if (n != 3) {
            this.t.nextToken();
        }
        if (!this.isInlineImage && this.t.type() == 5 && this.t.literalValue().equals(stream_K)) {
            int n5 = this.start + this.t.numBytesConsumed();
            int n6 = 0;
            byte[] byArray = new byte[2];
            this.ba.getBytes(n5, byArray);
            if (byArray[0] == 10) {
                n6 = 1;
            } else if (byArray[0] == 13) {
                n6 = byArray[1] == 10 ? 2 : 1;
            } else {
                throw new Exception("Malformed stream clause");
            }
            Object var10_13 = null;
            n4 = n5 + n6;
        }
        PDFObj pDFObj = pDFDict = n4 == -1 ? new PDFDict(stringArray, pDFObjArray) : new PDFDict(stringArray, pDFObjArray, this.ba, n4);
        if (this.stack.size() > 0 || this.makeRef) {
            pDFObj = new PDFDirectObj(this.store, pDFDict);
        }
        this.stack.push(pDFObj);
    }

    private void executeRef() throws Exception {
        if (this.stack.size() < 2 || this.store == null) {
            throw new UnexpectedTokenException(R_K);
        }
        PDFObj pDFObj = (PDFObj)this.stack.pop();
        PDFObj pDFObj2 = (PDFObj)this.stack.pop();
        if (!(pDFObj instanceof PDFInteger) || !(pDFObj2 instanceof PDFInteger)) {
            throw new UnexpectedTypeException(2);
        }
        this.t.nextToken();
        PDFIndirectObj pDFIndirectObj = this.store.getPDFIndirectObj(((PDFInteger)pDFObj2).integerValue(), (short)((PDFInteger)pDFObj).integerValue());
        this.stack.push(pDFIndirectObj);
    }

    private void handleLiteral(String string) throws Exception {
        if (string.equals(true_K)) {
            this.pushAndAdvance(PDFBoolean.getPDFBoolean(true));
        } else if (string.equals(false_K)) {
            this.pushAndAdvance(PDFBoolean.getPDFBoolean(false));
        } else if (string.equals(null_K)) {
            this.pushAndAdvance(PDFNull.getPDFNull());
        } else if (string.equals(_OpenBracket_K)) {
            this.topMark = new PEMark(2, this.stack.size(), this.topMark);
            this.pushAndAdvance(this.topMark);
        } else if (string.equals(_OpenDoubleAngleBracket_K)) {
            this.topMark = new PEMark(1, this.stack.size(), this.topMark);
            this.pushAndAdvance(this.topMark);
        } else if (string.equals(BI_K)) {
            this.topMark = new PEMark(3, this.stack.size(), this.topMark);
            this.pushAndAdvance(this.topMark);
        } else if (string.equals(_CloseBracket_K)) {
            this.executeArray();
        } else if (string.equals(_CloseDoubleAngleBracket_K)) {
            this.executeDict(1);
        } else if (string.equals(ID_K)) {
            this.executeDict(3);
        } else if (string.equals(R_K)) {
            this.executeRef();
        } else {
            throw new UnexpectedTokenException(string);
        }
    }

    private void pushAndAdvance(PDFObj pDFObj) throws Exception {
        this.stack.push(pDFObj);
        this.t.nextToken();
    }

    public PDFObj read() throws Exception {
        this.topMark = null;
        this.stack.setSize(0);
        do {
            switch (this.t.type()) {
                case 4: {
                    this.pushAndAdvance(new PDFName(this.t.nameValue()));
                    break;
                }
                case 1: {
                    Object var1_1 = null;
                    byte[] byArray = this.t.bytesValue();
                    if (this.cryptKey != null) {
                        RC4Engine rC4Engine = new RC4Engine(this.cryptKey.bytes, 0, 10);
                        byte[] byArray2 = MemUtil.allocByte(byArray.length);
                        rC4Engine.cipher(byArray, byArray2);
                        byArray = byArray2;
                    }
                    this.pushAndAdvance(new PDFString(byArray));
                    break;
                }
                case 2: {
                    this.pushAndAdvance(new PDFInteger(this.t.integerValue()));
                    break;
                }
                case 3: {
                    this.pushAndAdvance(new PDFReal(this.t.realValue()));
                    break;
                }
                case 5: {
                    this.handleLiteral(this.t.literalValue());
                    break;
                }
                default: {
                    throw new UnexpectedTokenException(this.t.stringValue());
                }
            }
        } while (this.stack.size() != 1 || this.topMark != null);
        return (PDFObj)this.stack.pop();
    }
}

