/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdfobjstore.security;

import com.adobe.acrobat.filters.MD5;
import com.adobe.acrobat.filters.RC4Engine;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.security.PDFObjStoreCryptKey;
import com.adobe.acrobat.pdfobjstore.security.PDFObjStorePerms;
import com.adobe.acrobat.pdfobjstore.security.SecurityHandler;
import com.adobe.pe.notify.Requester;

class StandardSecurityHandler
extends SecurityHandler {
    private static final String U_K = "U";
    private static final String O_K = "O";
    private static final String P_K = "P";
    private static final int MAX_PW_LEN = 32;
    private static final byte[] padding;

    static {
        byte[] byArray = new byte[32];
        byArray[0] = 40;
        byArray[1] = -65;
        byArray[2] = 78;
        byArray[3] = 94;
        byArray[4] = 78;
        byArray[5] = 117;
        byArray[6] = -118;
        byArray[7] = 65;
        byArray[8] = 100;
        byArray[10] = 78;
        byArray[11] = 86;
        byArray[12] = -1;
        byArray[13] = -6;
        byArray[14] = 1;
        byArray[15] = 8;
        byArray[16] = 46;
        byArray[17] = 46;
        byArray[19] = -74;
        byArray[20] = -48;
        byArray[21] = 104;
        byArray[22] = 62;
        byArray[23] = -128;
        byArray[24] = 47;
        byArray[25] = 12;
        byArray[26] = -87;
        byArray[27] = -2;
        byArray[28] = 100;
        byArray[29] = 83;
        byArray[30] = 105;
        byArray[31] = 122;
        padding = byArray;
    }

    StandardSecurityHandler() {
    }

    public PDFObjStorePerms computePerms(Object object, PDFObjStore pDFObjStore, Requester requester) throws Exception {
        PDFObjStorePerms pDFObjStorePerms;
        boolean bl;
        MD5 mD5 = (MD5)this.getPasswordHash(new byte[0]);
        PDFObjStoreCryptKey pDFObjStoreCryptKey = this.testOwnerKey(mD5, pDFObjStore, requester);
        PDFObjStoreCryptKey pDFObjStoreCryptKey2 = this.testUserKey(mD5, pDFObjStore, requester);
        PDFObjStoreCryptKey pDFObjStoreCryptKey3 = pDFObjStoreCryptKey;
        PDFObjStoreCryptKey pDFObjStoreCryptKey4 = pDFObjStoreCryptKey2;
        if (object != null) {
            pDFObjStoreCryptKey3 = this.testOwnerKey((MD5)object, pDFObjStore, requester);
            pDFObjStoreCryptKey4 = this.testUserKey((MD5)object, pDFObjStore, requester);
        }
        boolean bl2 = pDFObjStoreCryptKey == null;
        boolean bl3 = pDFObjStoreCryptKey2 == null;
        boolean bl4 = pDFObjStoreCryptKey3 != null;
        boolean bl5 = bl = pDFObjStoreCryptKey4 != null;
        if (bl4 && bl) {
            bl2 = false;
        }
        if (bl) {
            PDFDict pDFDict = SecurityHandler.getEncryptDict(pDFObjStore).pdfReferenceValue(requester).dictValue(requester);
            int n = pDFDict.get(P_K).integerValue(requester);
            pDFObjStorePerms = new PDFObjStorePerms(n, pDFObjStoreCryptKey4, bl2, bl3);
        } else {
            pDFObjStorePerms = bl4 ? PDFObjStorePerms.getFullPDFObjStorePerms(pDFObjStoreCryptKey3, bl2, bl3) : PDFObjStorePerms.getZeroPDFObjStorePerms();
        }
        return pDFObjStorePerms;
    }

    private PDFObjStoreCryptKey getCryptKey(MD5 mD5, PDFObjStore pDFObjStore, Requester requester) throws Exception {
        MD5 mD52 = (MD5)mD5.clone();
        PDFDict pDFDict = SecurityHandler.getEncryptDict(pDFObjStore).pdfReferenceValue(requester).dictValue(requester);
        byte[] byArray = pDFDict.get(O_K).bytesValue(requester);
        mD52.update(byArray);
        int n = pDFDict.get(P_K).integerValue(requester);
        int n2 = 0;
        while (n2 < 4) {
            mD52.update((byte)n);
            n >>>= 8;
            ++n2;
        }
        byte[] byArray2 = pDFObjStore.getPermanentFileID().bytesValue(requester);
        mD52.update(byArray2);
        return new PDFObjStoreCryptKey(mD52.digest());
    }

    public Object getPasswordHash(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        MD5 mD5 = new MD5();
        int n = Math.min(32, byArray.length);
        mD5.update(byArray, 0, n);
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = 0;
            ++n2;
        }
        mD5.update(padding, 0, 32 - n);
        return mD5;
    }

    private PDFObjStoreCryptKey testOwnerKey(MD5 mD5, PDFObjStore pDFObjStore, Requester requester) throws Exception {
        PDFDict pDFDict = SecurityHandler.getEncryptDict(pDFObjStore).pdfReferenceValue(requester).dictValue(requester);
        byte[] byArray = pDFDict.get(O_K).bytesValue(requester);
        byte[] byArray2 = new byte[byArray.length];
        MD5 mD52 = (MD5)mD5.clone();
        byte[] byArray3 = mD52.digest();
        RC4Engine rC4Engine = new RC4Engine(byArray3, 0, 5);
        rC4Engine.cipher(byArray, byArray2);
        MD5 mD53 = (MD5)this.getPasswordHash(byArray2);
        return this.testUserKey(mD53, pDFObjStore, requester);
    }

    private PDFObjStoreCryptKey testUserKey(MD5 mD5, PDFObjStore pDFObjStore, Requester requester) throws Exception {
        PDFDict pDFDict = SecurityHandler.getEncryptDict(pDFObjStore).pdfReferenceValue(requester).dictValue(requester);
        byte[] byArray = pDFDict.get(U_K).bytesValue(requester);
        byte[] byArray2 = new byte[byArray.length];
        PDFObjStoreCryptKey pDFObjStoreCryptKey = this.getCryptKey(mD5, pDFObjStore, requester);
        RC4Engine rC4Engine = new RC4Engine(pDFObjStoreCryptKey.bytes, 0, 5);
        rC4Engine.cipher(byArray, byArray2);
        int n = 0;
        while (n < 32) {
            if (byArray2[n] != padding[n]) {
                return null;
            }
            ++n;
        }
        return pDFObjStoreCryptKey;
    }
}

