/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.sidecar.AffineException;
import com.adobe.acrobat.sidecar.BezierPath;
import com.adobe.acrobat.sidecar.FloatPoint;
import java.awt.Rectangle;

public class AffineTransform
implements Cloneable {
    protected double a;
    protected double b;
    protected double c;
    protected double d;
    protected double x;
    protected double y;
    protected AffineTransform inverseTransform;
    private static AffineTransform gIdentityMatrix = new AffineTransform();
    private static double Deg2Rad = Math.PI / 180;

    protected AffineTransform() {
        this.d = 1.0;
        this.a = 1.0;
        this.y = 0.0;
        this.x = 0.0;
        this.c = 0.0;
        this.b = 0.0;
        this.inverseTransform = this;
    }

    public AffineTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.x = d5;
        this.y = d6;
        this.inverseTransform = null;
    }

    protected AffineTransform(AffineTransform affineTransform) {
        this.a = affineTransform.a;
        this.b = affineTransform.b;
        this.c = affineTransform.c;
        this.d = affineTransform.d;
        this.x = affineTransform.x;
        this.y = affineTransform.y;
        this.inverseTransform = affineTransform.inverseTransform;
    }

    public AffineTransform appendTransform(AffineTransform affineTransform) {
        double d = this.a * affineTransform.a + this.b * affineTransform.c;
        double d2 = this.c * affineTransform.a + this.d * affineTransform.c;
        double d3 = this.x * affineTransform.a + this.y * affineTransform.c + affineTransform.x;
        double d4 = this.a * affineTransform.b + this.b * affineTransform.d;
        double d5 = this.c * affineTransform.b + this.d * affineTransform.d;
        double d6 = this.x * affineTransform.b + this.y * affineTransform.d + affineTransform.y;
        return new AffineTransform(d, d4, d2, d5, d3, d6);
    }

    public Object clone() {
        return new AffineTransform(this);
    }

    public boolean equals(AffineTransform affineTransform) {
        return affineTransform != null && this.a == affineTransform.a && this.b == affineTransform.b && this.c == affineTransform.c && this.d == affineTransform.d && this.x == affineTransform.x && this.y == affineTransform.y;
    }

    public static AffineTransform getIdentityMatrix() {
        return gIdentityMatrix;
    }

    public AffineTransform getInverse() throws AffineException {
        if (this.inverseTransform == null) {
            double d = 1.0 / (this.b * this.c - this.a * this.d);
            double d2 = -this.d * d;
            double d3 = this.b * d;
            double d4 = this.c * d;
            double d5 = -this.a * d;
            double d6 = -(this.x * d2 + this.y * d4);
            double d7 = -(this.x * d3 + this.y * d5);
            if (Double.isNaN(d2) || Double.isInfinite(d2) || Double.isNaN(d3) || Double.isInfinite(d3) || Double.isNaN(d4) || Double.isInfinite(d4) || Double.isNaN(d5) || Double.isInfinite(d5) || Double.isNaN(d6) || Double.isInfinite(d6) || Double.isNaN(d7) || Double.isInfinite(d7)) {
                throw new AffineException("Singular matrix passed to invert: " + this.a + " " + this.b + " " + this.c + " " + this.d + " " + this.x + " " + this.y);
            }
            this.inverseTransform = new AffineTransform(d2, d3, d4, d5, d6, d7);
            this.inverseTransform.inverseTransform = this;
        }
        return this.inverseTransform;
    }

    public double geta() {
        return this.a;
    }

    public double getb() {
        return this.b;
    }

    public double getc() {
        return this.c;
    }

    public double getd() {
        return this.d;
    }

    public double getx() {
        return this.x;
    }

    public double gety() {
        return this.y;
    }

    public int hashCode() {
        double d = this.a + this.b + this.c + this.d + this.x + this.y;
        return (int)d;
    }

    public boolean isIdentity() {
        return this.a == 1.0 && this.d == 1.0 && this.b == 0.0 && this.c == 0.0;
    }

    public boolean isInvertable() {
        double d = this.b * this.c - this.a * this.d;
        return !Double.isNaN(d) && !Double.isInfinite(d) && d != 0.0;
    }

    public void mult(double d, double d2, double[] dArray) {
        dArray[0] = this.a * d + this.c * d2 + this.x;
        dArray[1] = this.b * d + this.d * d2 + this.y;
    }

    public AffineTransform preScale(double d) {
        return this.preScale(d, d);
    }

    public AffineTransform preScale(double d, double d2) {
        return new AffineTransform(this.a * d, this.b * d, this.c * d2, this.d * d2, this.x, this.y);
    }

    public AffineTransform preTranslate(double d, double d2) {
        return new AffineTransform(this.a, this.b, this.c, this.d, this.x + this.a * d + this.c * d2, this.y + this.b * d + this.d * d2);
    }

    public AffineTransform rotate(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        return this.appendTransform(new AffineTransform(d2, d3, -d3, d2, 0.0, 0.0));
    }

    private static String roundedValue(double d) {
        return Double.toString((double)Math.round(d * 1000000.0) / 1000000.0);
    }

    public AffineTransform scale(double d) {
        return this.scale(d, d);
    }

    public AffineTransform scale(double d, double d2) {
        return new AffineTransform(this.a * d, this.b * d2, this.c * d, this.d * d2, this.x * d, this.y * d2);
    }

    public AffineTransform setItalicDegrees(double d) {
        if (d == 0.0) {
            return this;
        }
        return new AffineTransform(this.a, this.b, Math.sin(d * Deg2Rad) * this.a + this.c, this.d, this.x, this.y);
    }

    public AffineTransform setTranslate(double d, double d2) {
        return new AffineTransform(this.a, this.b, this.c, this.d, d, d2);
    }

    public String toString() {
        return "[ " + AffineTransform.roundedValue(this.a) + " " + AffineTransform.roundedValue(this.b) + " " + AffineTransform.roundedValue(this.c) + " " + AffineTransform.roundedValue(this.d) + " " + AffineTransform.roundedValue(this.x) + " " + AffineTransform.roundedValue(this.y) + " ]";
    }

    public BezierPath transformPath(BezierPath bezierPath) {
        return bezierPath.transform(this);
    }

    public void transformPoint(FloatPoint floatPoint) {
        this.transformPoint(floatPoint, floatPoint);
    }

    public void transformPoint(FloatPoint floatPoint, FloatPoint floatPoint2) {
        double d = this.a * floatPoint.x + this.c * floatPoint.y + this.x;
        double d2 = this.b * floatPoint.x + this.d * floatPoint.y + this.y;
        floatPoint2.x = d;
        floatPoint2.y = d2;
    }

    public void transformPoints(double[] dArray, double[] dArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            double d2 = dArray2[n2];
            dArray[n2] = this.a * d + this.c * d2 + this.x;
            dArray2[n2] = this.b * d + this.d * d2 + this.y;
            ++n2;
        }
    }

    public void transformRectangle(Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        double d = this.a * (double)n + this.c * (double)n3 + this.x;
        double d2 = this.b * (double)n + this.d * (double)n3 + this.y;
        double d3 = this.a * (double)n + this.c * (double)n4 + this.x;
        double d4 = this.b * (double)n + this.d * (double)n4 + this.y;
        double d5 = this.a * (double)n2 + this.c * (double)n3 + this.x;
        double d6 = this.b * (double)n2 + this.d * (double)n3 + this.y;
        double d7 = this.a * (double)n2 + this.c * (double)n4 + this.x;
        double d8 = this.b * (double)n2 + this.d * (double)n4 + this.y;
        double d9 = Math.min(Math.min(d, d3), Math.min(d5, d7));
        double d10 = Math.max(Math.max(d, d3), Math.max(d5, d7));
        double d11 = Math.min(Math.min(d2, d4), Math.min(d6, d8));
        double d12 = Math.max(Math.max(d2, d4), Math.max(d6, d8));
        rectangle.x = (int)Math.round(d9);
        rectangle.y = (int)Math.round(d11);
        rectangle.width = (int)Math.round(d10) - rectangle.x;
        rectangle.height = (int)Math.round(d12) - rectangle.y;
    }

    public AffineTransform translate(double d, double d2) {
        return new AffineTransform(this.a, this.b, this.c, this.d, this.x + d, this.y + d2);
    }
}

