/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.ComplexPolygon;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.sidecar.PolygonADV;
import com.adobe.acrobat.util.Log;
import com.adobe.util.MemUtil;

public class BezierPath
implements Cloneable {
    public static final byte TYPE_MOVETO = 1;
    public static final byte TYPE_LINETO = 2;
    public static final byte TYPE_CURVETO_BEZ = 3;
    public static final byte TYPE_CLOSE = 4;
    public static final byte TYPE_CURVETO_QBEZ = 5;
    public static final byte TYPE_HIDDEN = -1;
    public static final int FILL_STYLE_NONE = 0;
    public static final int FILL_STYLE_WIND = 1;
    public static final int FILL_STYLE_EO = 2;
    protected byte[] strip_type = null;
    protected double[] strip_x = null;
    protected double[] strip_y = null;
    int append_position;
    int fill_style;
    int clip_style;
    private static final double ctlMag = 4.0 * (Math.sqrt(2.0) - 1.0) / 3.0;
    static final double FLATTEN_PRECISION = 2.0;

    public BezierPath(int n) {
        this.strip_x = MemUtil.allocDouble(n);
        this.strip_y = MemUtil.allocDouble(n);
        this.strip_type = MemUtil.allocByte(n);
        this.clip_style = 0;
        this.fill_style = 0;
        this.append_position = 0;
    }

    public BezierPath(FloatRect floatRect) {
        this(6);
        double d = floatRect.getxMin();
        double d2 = floatRect.getxMax();
        double d3 = floatRect.getyMin();
        double d4 = floatRect.getyMax();
        this.moveTo(d, d3);
        this.lineTo(d2, d3);
        this.lineTo(d2, d4);
        this.lineTo(d, d4);
        this.closePath();
        this.fill_style = 2;
    }

    public BezierPath(FloatRect floatRect, double d, double d2) {
        this(18);
        d = Math.min(d, floatRect.width() / 2.0);
        d2 = Math.min(d2, floatRect.height() / 2.0);
        this.fill_style = 2;
        double d3 = floatRect.getxMin();
        double d4 = floatRect.getxMax();
        double d5 = floatRect.getyMin();
        double d6 = floatRect.getyMax();
        if (d == 0.0 || d2 == 0.0) {
            this.moveTo(d3, d5);
            this.lineTo(d4, d5);
            this.lineTo(d4, d6);
            this.lineTo(d3, d6);
            this.closePath();
        } else {
            double d7 = (1.0 - ctlMag) * d;
            double d8 = (1.0 - ctlMag) * d2;
            this.moveTo(d4 - d, d5);
            this.curveTo(d4 - d7, d5, d4, d5 + d8, d4, d5 + d2);
            this.lineTo(d4, d6 - d2);
            this.curveTo(d4, d6 - d8, d4 - d7, d6, d4 - d, d6);
            this.lineTo(d3 + d, d6);
            this.curveTo(d3 + d7, d6, d3, d6 - d8, d3, d6 - d2);
            this.lineTo(d3, d5 + d2);
            this.curveTo(d3, d5 + d8, d3 + d7, d5, d3 + d, d5);
            this.closePath();
        }
    }

    public void addPoint(double d, double d2, byte by) {
        this.extend(d, d2, by);
    }

    public Object clone() {
        BezierPath bezierPath = null;
        try {
            bezierPath = (BezierPath)super.clone();
            bezierPath.strip_x = MemUtil.allocDouble(this.append_position);
            bezierPath.strip_y = MemUtil.allocDouble(this.append_position);
            bezierPath.strip_type = MemUtil.allocByte(this.append_position);
            System.arraycopy(this.strip_x, 0, bezierPath.strip_x, 0, this.append_position);
            System.arraycopy(this.strip_y, 0, bezierPath.strip_y, 0, this.append_position);
            System.arraycopy(this.strip_type, 0, bezierPath.strip_type, 0, this.append_position);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return bezierPath;
    }

    public void closePath() {
        if (this.append_position > 0 && this.strip_type[this.append_position - 1] != 4) {
            this.addPoint(0.0, 0.0, (byte)4);
        }
    }

    public BezierPath compact() {
        if (this.strip_type.length - this.append_position > 16) {
            double[] dArray = MemUtil.allocDouble(this.append_position);
            System.arraycopy(this.strip_x, 0, dArray, 0, this.append_position);
            this.strip_x = dArray;
            double[] dArray2 = MemUtil.allocDouble(this.append_position);
            System.arraycopy(this.strip_y, 0, dArray2, 0, this.append_position);
            this.strip_y = dArray2;
            byte[] byArray = MemUtil.allocByte(this.append_position);
            System.arraycopy(this.strip_type, 0, byArray, 0, this.append_position);
            this.strip_type = byArray;
        }
        return this;
    }

    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        this.addPoint(d, d2, (byte)3);
        this.addPoint(d3, d4, (byte)3);
        this.addPoint(d5, d6, (byte)3);
    }

    public void curveToQ(double d, double d2, double d3, double d4) {
        this.addPoint(d, d2, (byte)5);
        this.addPoint(d3, d4, (byte)5);
    }

    public void curveToV(double d, double d2, double d3, double d4) {
        this.addPoint(this.strip_x[this.append_position - 1], this.strip_y[this.append_position - 1], (byte)3);
        this.addPoint(d, d2, (byte)3);
        this.addPoint(d3, d4, (byte)3);
    }

    public void dump() {
        Log.clog("Path has " + this.append_position + " (x,y) positions.");
        int n = 0;
        while (n < this.append_position) {
            Log.clogn("Point " + n + " : ");
            switch (this.strip_type[n]) {
                case 1: {
                    Log.clogn("TYPE_MOVETO");
                    Log.clog(" : " + this.strip_x[n] + "," + this.strip_y[n] + " ");
                    break;
                }
                case 2: {
                    Log.clogn("TYPE_LINETO");
                    Log.clog(" : " + this.strip_x[n] + "," + this.strip_y[n] + " ");
                    break;
                }
                case 3: {
                    Log.clogn("TYPE_CURVETO_BEZ");
                    Log.clog(" : " + this.strip_x[n] + "," + this.strip_y[n] + " ");
                    break;
                }
                case 4: {
                    Log.clogn("TYPE_CLOSE");
                    break;
                }
                case 5: {
                    Log.clogn("TYPE_CURVETO_QBEZ");
                    Log.clog(" : " + this.strip_x[n] + "," + this.strip_y[n] + " ");
                    break;
                }
            }
            ++n;
        }
        Log.clog(" X components ");
        int n2 = 0;
        while (n2 < this.append_position) {
            switch (this.strip_type[n2]) {
                case 1: {
                    Log.clog(Double.toString(this.strip_x[n2]));
                    break;
                }
                case 2: {
                    Log.clog(Double.toString(this.strip_x[n2]));
                    break;
                }
                case 3: {
                    Log.clog(Double.toString(this.strip_x[n2 += 2]));
                    break;
                }
                case 5: {
                    Log.clog(Double.toString(this.strip_x[++n2]));
                    break;
                }
            }
            ++n2;
        }
        Log.clog(" Y components ");
        int n3 = 0;
        while (n3 < this.append_position) {
            switch (this.strip_type[n3]) {
                case 1: {
                    Log.clog(Double.toString(this.strip_y[n3]));
                    break;
                }
                case 2: {
                    Log.clog(Double.toString(this.strip_y[n3]));
                    break;
                }
                case 3: {
                    Log.clog(Double.toString(this.strip_y[n3 += 2]));
                    break;
                }
                case 5: {
                    Log.clog(Double.toString(this.strip_y[++n3]));
                    break;
                }
            }
            ++n3;
        }
    }

    protected void extend(double d, double d2, byte by) {
        if (this.append_position == this.strip_type.length - 1) {
            this.extend(0);
        }
        this.strip_x[this.append_position] = d;
        this.strip_y[this.append_position] = d2;
        this.strip_type[this.append_position] = by;
        ++this.append_position;
    }

    protected void extend(int n) {
        int n2 = this.strip_type.length + (n += 512);
        double[] dArray = MemUtil.allocDouble(n2);
        System.arraycopy(this.strip_x, 0, dArray, 0, this.append_position);
        this.strip_x = dArray;
        double[] dArray2 = MemUtil.allocDouble(n2);
        System.arraycopy(this.strip_y, 0, dArray2, 0, this.append_position);
        this.strip_y = dArray2;
        byte[] byArray = MemUtil.allocByte(n2);
        System.arraycopy(this.strip_type, 0, byArray, 0, this.append_position);
        this.strip_type = byArray;
    }

    public ComplexPolygon flattenBezierPath() {
        ComplexPolygon complexPolygon = new ComplexPolygon();
        int n = this.numPoints();
        int n2 = 0;
        PolygonADV polygonADV = null;
        while (n2 < n) {
            switch (this.strip_type[n2]) {
                case 1: {
                    if (this.isValidPolygon(polygonADV)) {
                        complexPolygon.addElement(polygonADV);
                    }
                    polygonADV = new PolygonADV();
                    polygonADV.addPoint(this.strip_x[n2], this.strip_y[n2]);
                    ++n2;
                    break;
                }
                case 2: {
                    if (polygonADV == null) {
                        polygonADV = new PolygonADV();
                    }
                    polygonADV.addPoint(this.strip_x[n2], this.strip_y[n2]);
                    ++n2;
                    break;
                }
                case 3: {
                    if (polygonADV == null) {
                        polygonADV = new PolygonADV();
                    }
                    this.flattenBezierSeg(polygonADV, this.strip_x[n2 - 1], this.strip_y[n2 - 1], this.strip_x[n2], this.strip_y[n2], this.strip_x[n2 + 1], this.strip_y[n2 + 1], this.strip_x[n2 + 2], this.strip_y[n2 + 2]);
                    n2 += 3;
                    break;
                }
                case 5: {
                    if (polygonADV == null) {
                        polygonADV = new PolygonADV();
                    }
                    this.flattenQBezierSeg(polygonADV, this.strip_x[n2 - 1], this.strip_y[n2 - 1], this.strip_x[n2], this.strip_y[n2], this.strip_x[n2 + 1], this.strip_y[n2 + 1]);
                    n2 += 2;
                    break;
                }
                case 4: {
                    if (polygonADV != null && !polygonADV.isClosed()) {
                        polygonADV.addPoint(polygonADV.xpoints[0], polygonADV.ypoints[0]);
                    }
                    if (this.isValidPolygon(polygonADV)) {
                        complexPolygon.addElement(polygonADV);
                    }
                    polygonADV = null;
                    ++n2;
                    break;
                }
                default: {
                    ++n2;
                    break;
                }
            }
        }
        if (this.isValidPolygon(polygonADV)) {
            complexPolygon.addElement(polygonADV.compact());
        }
        return complexPolygon;
    }

    private void flattenBezierSeg(PolygonADV polygonADV, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        if (!this.shouldSubDivide(d, d2, d3, d4, d5, d6, d7, d8)) {
            polygonADV.addPoint(d7, d8);
            return;
        }
        double d9 = (d3 + d5) / 2.0;
        double d10 = (d4 + d6) / 2.0;
        double d11 = (d5 + d7) / 2.0;
        double d12 = (d6 + d8) / 2.0;
        d3 = (d + d3) / 2.0;
        d4 = (d2 + d4) / 2.0;
        d5 = (d3 + d9) / 2.0;
        d6 = (d4 + d10) / 2.0;
        double d13 = (d9 + d11) / 2.0;
        double d14 = (d10 + d12) / 2.0;
        double d15 = (d5 + d13) / 2.0;
        double d16 = (d6 + d14) / 2.0;
        this.flattenBezierSeg(polygonADV, d, d2, d3, d4, d5, d6, d15, d16);
        this.flattenBezierSeg(polygonADV, d15, d16, d13, d14, d11, d12, d7, d8);
    }

    private void flattenQBezierSeg(PolygonADV polygonADV, double d, double d2, double d3, double d4, double d5, double d6) {
        if (!this.shouldSubDivideQ(d, d2, d3, d4, d5, d6)) {
            polygonADV.addPoint(d5, d6);
            return;
        }
        double d7 = (d3 + d5) / 2.0;
        double d8 = (d4 + d6) / 2.0;
        d3 = (d + d3) / 2.0;
        d4 = (d2 + d4) / 2.0;
        double d9 = (d7 + d3) / 2.0;
        double d10 = (d8 + d4) / 2.0;
        this.flattenQBezierSeg(polygonADV, d, d2, d3, d4, d9, d10);
        this.flattenQBezierSeg(polygonADV, d9, d10, d7, d8, d5, d6);
    }

    public FloatRect getBoundingBox() {
        if (this.append_position > 0) {
            double d;
            double d2;
            double d3 = d2 = this.strip_x[0];
            double d4 = d = this.strip_y[0];
            int n = 1;
            while (n < this.append_position) {
                switch (this.strip_type[n]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: {
                        double d5 = this.strip_x[n];
                        if (d5 < d3) {
                            d3 = d5;
                        } else if (d5 > d2) {
                            d2 = d5;
                        }
                        double d6 = this.strip_y[n];
                        if (d6 < d4) {
                            d4 = d6;
                            break;
                        }
                        if (!(d6 > d)) break;
                        d = d6;
                        break;
                    }
                }
                ++n;
            }
            return new FloatRect(d3, d4, d2, d);
        }
        return FloatRect.getEmptyRect();
    }

    public int getClipWinding() {
        return this.clip_style;
    }

    public int getWinding() {
        return this.fill_style;
    }

    private boolean isValidPolygon(PolygonADV polygonADV) {
        return polygonADV != null && polygonADV.npoints >= 2 && (!polygonADV.isClosed() || polygonADV.npoints >= 3);
    }

    public void lineTo(double d, double d2) {
        this.addPoint(d, d2, (byte)2);
    }

    public void moveTo(double d, double d2) {
        this.addPoint(d, d2, (byte)1);
    }

    public int numPoints() {
        return this.append_position;
    }

    public void reset() {
        this.clip_style = 0;
        this.fill_style = 0;
        this.append_position = 0;
    }

    public void setClipEvenOdd() {
        this.clip_style = 2;
    }

    public void setClipWinding() {
        this.clip_style = 1;
    }

    public void setEvenOdd() {
        this.fill_style = 2;
    }

    public void setWinding() {
        this.fill_style = 1;
    }

    private boolean shouldSubDivide(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = d7 - d;
        double d10 = d8 - d2;
        if (d9 == 0.0 && d10 == 0.0) {
            d9 = d3 - d;
            d10 = d4 - d2;
            if (d9 * d9 + d10 * d10 > 2.0) {
                return true;
            }
            d9 = d7 - d5;
            d10 = d8 - d6;
            return d9 * d9 + d10 * d10 > 2.0;
        }
        double d11 = (d2 + d8) * d9;
        double d12 = d11 + (d8 + d4) * (d3 - d7) + (d4 + d2) * (d - d3);
        double d13 = (d9 * d9 + d10 * d10) * 2.0;
        if (d12 * d12 > d13) {
            return true;
        }
        d12 = d11 + (d8 + d6) * (d5 - d7) + (d6 + d2) * (d - d5);
        return d12 * d12 > d13;
    }

    private boolean shouldSubDivideQ(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d5 - d;
        double d8 = d6 - d2;
        if (d7 == 0.0 && d8 == 0.0) {
            d7 = d3 - d;
            d8 = d4 - d2;
            return d7 * d7 + d8 * d8 > 2.0;
        }
        double d9 = (d2 + d6) * d7 + (d6 + d4) * (d3 - d5) + (d4 + d2) * (d - d3);
        double d10 = (d7 * d7 + d8 * d8) * 2.0;
        return d9 * d9 > d10;
    }

    public BezierPath transform(AffineTransform affineTransform) {
        BezierPath bezierPath = (BezierPath)this.clone();
        affineTransform.transformPoints(bezierPath.strip_x, bezierPath.strip_y, this.append_position);
        return bezierPath;
    }

    public void translate(double d, double d2) {
        int n = 0;
        while (n < this.append_position) {
            int n2 = n;
            this.strip_x[n2] = this.strip_x[n2] + d;
            int n3 = n++;
            this.strip_y[n3] = this.strip_y[n3] + d2;
        }
    }
}

