/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.util.Assert;
import com.adobe.util.MemUtil;

public class FastHash {
    static final boolean debug = false;
    static final byte EMPTY = 0;
    static final byte FILLED = 1;
    static final byte DELETED = 2;
    static final int INT_TYPE = 0;
    static final int LONG_TYPE = 1;
    static final int FLOAT_TYPE = 2;
    static final int OBJECT_TYPE = 3;
    int maxCollision;
    boolean wasFound;
    int foundAtIndex;
    int resizeThreshold;
    int count;
    int size;
    byte[] state;
    int[] keyHash;
    Object keys;
    int keyType;
    Object values;
    int valueType;
    int primeIndex = 0;
    static int[] primes = new int[]{11, 23, 47, 89, 181, 359, 701, 1409, 2803, 5659, 7919, 12491, 18617, 25933, 38069, 47381, 65647, 97151};

    protected FastHash(int n, int n2, int n3) {
        this.keyType = n2;
        this.valueType = n3;
        n = (5 * n + 3) / 4;
        int n4 = primes[this.primeIndex++];
        while (n4 < n) {
            n4 = primes[this.primeIndex++];
        }
        this.initNewHash(n4);
    }

    void allocateStorage(int n) {
        this.state = MemUtil.allocByte(n);
        this.keyHash = MemUtil.allocInt(n);
        switch (this.keyType) {
            case 0: {
                this.keys = MemUtil.allocInt(n);
                break;
            }
            case 1: {
                this.keys = MemUtil.allocLong(n);
                break;
            }
            case 3: {
                this.keys = MemUtil.allocObject(n);
                break;
            }
        }
        switch (this.valueType) {
            case 0: {
                this.values = MemUtil.allocInt(n);
                break;
            }
            case 1: {
                this.values = MemUtil.allocLong(n);
                break;
            }
            case 2: {
                this.values = MemUtil.allocFloat(n);
                break;
            }
            case 3: {
                this.values = MemUtil.allocObject(n);
                break;
            }
        }
    }

    public synchronized boolean contains(int n) {
        Assert.notFalse(this.keyType == 0);
        this.getIntIndex(n);
        return this.wasFound;
    }

    public synchronized boolean contains(long l) {
        Assert.notFalse(this.keyType == 1);
        this.getLongIndex(l);
        return this.wasFound;
    }

    public synchronized boolean contains(Object object) {
        Assert.notFalse(this.keyType == 3);
        this.getObjectIndex(object);
        return this.wasFound;
    }

    void copyEntries(byte[] byArray, Object object, Object object2) {
        int n = 0;
        int n2 = byArray.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            switch (this.keyType) {
                case 0: {
                    n = this.intHash(((int[])object)[n2]);
                    break;
                }
                case 1: {
                    n = this.longHash(((long[])object)[n2]);
                    break;
                }
                case 3: {
                    n = this.objectHash(((Object[])object)[n2]);
                    break;
                }
            }
            int n3 = this.getFreeEntry(n);
            System.arraycopy(object, n2, this.keys, n3, 1);
            System.arraycopy(object2, n2, this.values, n3, 1);
        }
    }

    public synchronized float getFloat(int n) {
        Assert.notFalse(this.keyType == 0 && this.valueType == 2);
        this.getIntIndex(n);
        if (this.wasFound) {
            return ((float[])this.values)[this.foundAtIndex];
        }
        return 0.0f;
    }

    public float getFloatByIndex(int n) {
        Assert.notFalse(this.valueType == 2);
        n = this.getIndexByOrdinal(n);
        if (n >= 0) {
            return ((float[])this.values)[n];
        }
        return 0.0f;
    }

    private int getFreeEntry(int n) {
        int n2 = n;
        int n3 = 0;
        while (this.state[n2] == 1) {
            n2 = (n2 + n) % this.state.length;
            ++n3;
        }
        if (n3 > this.maxCollision) {
            this.maxCollision = n3;
        }
        this.state[n2] = 1;
        this.keyHash[n2] = n;
        ++this.count;
        return n2;
    }

    private int getFreeIndex(int n) {
        if (this.count >= this.resizeThreshold) {
            this.grow();
        }
        return this.getFreeEntry(this.intHash(n));
    }

    private int getFreeIndex(long l) {
        if (this.count >= this.resizeThreshold) {
            this.grow();
        }
        return this.getFreeEntry(this.longHash(l));
    }

    private int getFreeIndex(Object object) {
        if (this.count >= this.resizeThreshold) {
            this.grow();
        }
        return this.getFreeEntry(this.objectHash(object));
    }

    private int getIndexByOrdinal(int n) {
        int n2 = 0;
        if (n < this.count) {
            int n3 = 0;
            while (n3 < this.state.length) {
                if (this.state[n3] == 1) {
                    if (n2 == n) {
                        return n3;
                    }
                    ++n2;
                }
                ++n3;
            }
        }
        return -1;
    }

    public synchronized int getInt(int n) {
        Assert.notFalse(this.keyType == 0 && this.valueType == 0);
        this.getIntIndex(n);
        if (this.wasFound) {
            return ((int[])this.values)[this.foundAtIndex];
        }
        return 0;
    }

    public synchronized int getInt(long l) {
        Assert.notFalse(this.keyType == 1 && this.valueType == 0);
        this.getLongIndex(l);
        if (this.wasFound) {
            return ((int[])this.values)[this.foundAtIndex];
        }
        return 0;
    }

    public synchronized int getInt(Object object) {
        Assert.notFalse(this.keyType == 3 && this.valueType == 0);
        this.getObjectIndex(object);
        if (this.wasFound) {
            return ((int[])this.values)[this.foundAtIndex];
        }
        return 0;
    }

    public int getIntByIndex(int n) {
        Assert.notFalse(this.valueType == 0);
        n = this.getIndexByOrdinal(n);
        if (n >= 0) {
            return ((int[])this.values)[n];
        }
        return 0;
    }

    private int getIntIndex(int n) {
        int n2;
        int n3 = n2 = this.intHash(n);
        int[] nArray = (int[])this.keys;
        int n4 = 0;
        do {
            if (this.state[n3] == 1 && this.keyHash[n3] == n2 && nArray[n3] == n) {
                this.wasFound = true;
                this.foundAtIndex = n3;
                return n3;
            }
            n3 = (n3 + n2) % this.state.length;
        } while (++n4 <= this.maxCollision);
        this.wasFound = false;
        return 0;
    }

    public int getIntKeyByIndex(int n) {
        Assert.notFalse(this.keyType == 0);
        n = this.getIndexByOrdinal(n);
        if (n >= 0) {
            return ((int[])this.keys)[n];
        }
        return 0;
    }

    public synchronized long getLong(int n) {
        Assert.notFalse(this.keyType == 0 && this.valueType == 1);
        this.getIntIndex(n);
        if (this.wasFound) {
            return ((long[])this.values)[this.foundAtIndex];
        }
        return 0L;
    }

    private int getLongIndex(long l) {
        int n;
        int n2 = n = this.longHash(l);
        long[] lArray = (long[])this.keys;
        int n3 = 0;
        do {
            if (this.state[n2] == 1 && this.keyHash[n2] == n && lArray[n2] == l) {
                this.wasFound = true;
                this.foundAtIndex = n2;
                return n2;
            }
            n2 = (n2 + n) % this.state.length;
        } while (++n3 <= this.maxCollision);
        this.wasFound = false;
        return 0;
    }

    public synchronized Object getObject(int n) {
        Assert.notFalse(this.keyType == 0 && this.valueType == 3);
        this.getIntIndex(n);
        if (this.wasFound) {
            return ((Object[])this.values)[this.foundAtIndex];
        }
        return null;
    }

    public synchronized Object getObject(long l) {
        Assert.notFalse(this.keyType == 1 && this.valueType == 3);
        this.getLongIndex(l);
        if (this.wasFound) {
            return ((Object[])this.values)[this.foundAtIndex];
        }
        return null;
    }

    public synchronized Object getObject(Object object) {
        Assert.notFalse(this.keyType == 3 && this.valueType == 3);
        this.getObjectIndex(object);
        if (this.wasFound) {
            return ((Object[])this.values)[this.foundAtIndex];
        }
        return null;
    }

    private int getObjectIndex(Object object) {
        int n;
        int n2 = n = this.objectHash(object);
        Object[] objectArray = (Object[])this.keys;
        int n3 = 0;
        if (object != null) {
            do {
                if (this.state[n2] == 1 && this.keyHash[n2] == n && objectArray[n2].equals(object)) {
                    this.wasFound = true;
                    this.foundAtIndex = n2;
                    return n2;
                }
                n2 = (n2 + n) % this.state.length;
            } while (++n3 <= this.maxCollision);
        }
        this.wasFound = false;
        return 0;
    }

    public Object getObjectKeyByIndex(int n) {
        Assert.notFalse(this.keyType == 3);
        n = this.getIndexByOrdinal(n);
        if (n >= 0) {
            return ((Object[])this.keys)[n];
        }
        return null;
    }

    private void grow() {
        byte[] byArray = this.state;
        Object object = this.keys;
        Object object2 = this.values;
        this.initNewHash(primes[this.primeIndex++]);
        this.copyEntries(byArray, object, object2);
    }

    private void initNewHash(int n) {
        this.count = 0;
        this.maxCollision = 0;
        this.resizeThreshold = 4 * n / 5;
        this.allocateStorage(n);
        this.size = n;
    }

    int intHash(int n) {
        return (n * 5119 & Integer.MAX_VALUE) % (this.state.length - 1) + 1;
    }

    int longHash(long l) {
        return this.intHash((int)(l ^ l >> 32));
    }

    public static FastHash newIntFloatHash(int n) {
        return new FastHash(n, 0, 2);
    }

    public static FastHash newIntIntHash(int n) {
        return new FastHash(n, 0, 0);
    }

    public static FastHash newIntLongHash(int n) {
        return new FastHash(n, 0, 1);
    }

    public static FastHash newIntObjectHash(int n) {
        return new FastHash(n, 0, 3);
    }

    public static FastHash newLongIntHash(int n) {
        return new FastHash(n, 1, 0);
    }

    public static FastHash newLongObjectHash(int n) {
        return new FastHash(n, 1, 3);
    }

    public static FastHash newObjectIntHash(int n) {
        return new FastHash(n, 3, 0);
    }

    public static FastHash newObjectObjectHash(int n) {
        return new FastHash(n, 3, 3);
    }

    int objectHash(Object object) {
        return this.intHash(object.hashCode());
    }

    public synchronized void put(int n, float f) {
        Assert.notFalse(this.keyType == 0 && this.valueType == 2);
        int n2 = this.getIntIndex(n);
        if (!this.wasFound) {
            n2 = this.getFreeIndex(n);
        }
        ((int[])this.keys)[n2] = n;
        ((float[])this.values)[n2] = f;
    }

    public synchronized void put(int n, int n2) {
        Assert.notFalse(this.keyType == 0 && this.valueType == 0);
        int n3 = this.getIntIndex(n);
        if (!this.wasFound) {
            n3 = this.getFreeIndex(n);
        }
        ((int[])this.keys)[n3] = n;
        ((int[])this.values)[n3] = n2;
    }

    public synchronized void put(int n, long l) {
        Assert.notFalse(this.keyType == 0 && this.valueType == 1);
        int n2 = this.getIntIndex(n);
        if (!this.wasFound) {
            n2 = this.getFreeIndex(n);
        }
        ((int[])this.keys)[n2] = n;
        ((long[])this.values)[n2] = l;
    }

    public synchronized void put(int n, Object object) {
        Assert.notFalse(this.keyType == 0 && this.valueType == 3);
        int n2 = this.getIntIndex(n);
        if (!this.wasFound) {
            n2 = this.getFreeIndex(n);
        }
        ((int[])this.keys)[n2] = n;
        ((Object[])this.values)[n2] = object;
    }

    public synchronized void put(long l, int n) {
        Assert.notFalse(this.keyType == 1 && this.valueType == 0);
        int n2 = this.getLongIndex(l);
        if (!this.wasFound) {
            n2 = this.getFreeIndex(l);
        }
        ((long[])this.keys)[n2] = l;
        ((int[])this.values)[n2] = n;
    }

    public synchronized void put(long l, Object object) {
        Assert.notFalse(this.keyType == 1 && this.valueType == 3);
        int n = this.getLongIndex(l);
        if (!this.wasFound) {
            n = this.getFreeIndex(l);
        }
        ((long[])this.keys)[n] = l;
        ((Object[])this.values)[n] = object;
    }

    public synchronized void put(Object object, int n) {
        Assert.notFalse(this.keyType == 3 && this.valueType == 0);
        if (object != null) {
            int n2 = this.getObjectIndex(object);
            if (!this.wasFound) {
                n2 = this.getFreeIndex(object);
            }
            ((Object[])this.keys)[n2] = object;
            ((int[])this.values)[n2] = n;
        }
    }

    public synchronized void put(Object object, Object object2) {
        Assert.notFalse(this.keyType == 3 && this.valueType == 3);
        if (object != null) {
            int n = this.getObjectIndex(object);
            if (!this.wasFound) {
                n = this.getFreeIndex(object);
            }
            ((Object[])this.keys)[n] = object;
            ((Object[])this.values)[n] = object2;
        }
    }

    public synchronized void remove(int n) {
        Assert.notFalse(this.keyType == 0);
        this.getIntIndex(n);
        if (this.wasFound) {
            --this.count;
            this.state[this.foundAtIndex] = 2;
        }
    }

    public synchronized void remove(long l) {
        Assert.notFalse(this.keyType == 1);
        this.getLongIndex(l);
        if (this.wasFound) {
            --this.count;
            this.state[this.foundAtIndex] = 2;
        }
    }

    public synchronized void remove(Object object) {
        Assert.notFalse(this.keyType == 3);
        this.getObjectIndex(object);
        if (this.wasFound) {
            --this.count;
            this.state[this.foundAtIndex] = 2;
        }
    }

    public int size() {
        return this.count;
    }

    public boolean wasFound() {
        return this.wasFound;
    }
}

