/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.sidecar.AffineTransform;
import java.awt.Point;

public class FloatPoint
implements Cloneable {
    public double x;
    public double y;
    public static final double sqrtTwo = Math.sqrt(2.0);

    public FloatPoint() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public FloatPoint(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public FloatPoint(FloatPoint floatPoint) {
        this.x = floatPoint.x;
        this.y = floatPoint.y;
    }

    public FloatPoint(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public FloatPoint add(FloatPoint floatPoint) {
        this.x += floatPoint.x;
        this.y += floatPoint.y;
        return this;
    }

    public double angle() {
        return Math.atan2(this.x, this.y);
    }

    public Object clone() {
        return new FloatPoint(this.x, this.y);
    }

    public double cross(FloatPoint floatPoint) {
        return this.x * floatPoint.y - this.y * floatPoint.x;
    }

    public FloatPoint deltaTransform(AffineTransform affineTransform) {
        return FloatPoint.deltaTransform(affineTransform, this);
    }

    public static FloatPoint deltaTransform(AffineTransform affineTransform, FloatPoint floatPoint) {
        FloatPoint floatPoint2 = new FloatPoint();
        affineTransform.transformPoint(floatPoint, floatPoint2);
        return floatPoint2;
    }

    public double distance(FloatPoint floatPoint) {
        double d = floatPoint.x - this.x;
        double d2 = floatPoint.y - this.y;
        return Math.sqrt(d * d + d2 * d2);
    }

    public double dot(FloatPoint floatPoint) {
        return this.x * floatPoint.x + this.y * floatPoint.y;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FloatPoint)) {
            return false;
        }
        FloatPoint floatPoint = (FloatPoint)object;
        return floatPoint == this || this.x == floatPoint.x && this.y == floatPoint.y;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        l = (l >>> 1) + Double.doubleToLongBits(this.y);
        return (int)(l ^ l >>> 32);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public FloatPoint negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public void normalize() {
        double d = Math.sqrt(this.x * this.x + this.y * this.y);
        if (d != 0.0) {
            this.x /= d;
            this.y /= d;
        }
    }

    public void set(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public FloatPoint subtract(FloatPoint floatPoint) {
        this.x -= floatPoint.x;
        this.x -= floatPoint.y;
        return this;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

