/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.sidecar.DecryptStream;
import com.adobe.acrobat.sidecar.FastHash;
import com.adobe.acrobat.util.Log;
import com.adobe.util.MemUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class FontVM {
    InputStream stream;
    RandomAccessFile file;
    int pos;
    int bias = 0;
    FastHash blockCache;
    byte[] block = MemUtil.allocByte(100);

    public FontVM() {
        this.initFastHash();
    }

    public FontVM(InputStream inputStream, int n) {
        this.initFastHash();
        this.stream = inputStream;
        this.bias = n;
    }

    public FontVM(RandomAccessFile randomAccessFile, int n) {
        this.initFastHash();
        this.file = randomAccessFile;
        this.bias = n;
    }

    public void addBias(int n) throws IOException {
        this.bias += n;
        this.seek(this.pos);
    }

    public Object convertObject(byte[] byArray, int n) {
        return byArray;
    }

    protected void finalize() throws Throwable {
        block2: {
            try {
                if (this.file == null) break block2;
                this.file.close();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                super.finalize();
                throw throwable;
            }
        }
        Object var2_1 = null;
        super.finalize();
    }

    public void freeBlock(int n, int n2) {
        this.blockCache.remove((long)n + ((long)n2 << 32));
    }

    public Object getBlock(int n, int n2, boolean bl) throws IOException {
        long l = (long)n + ((long)n2 << 32);
        Object object = this.blockCache.getObject(l);
        if (object == null) {
            int n3 = n2 - n;
            if (this.block.length < n3) {
                this.block = MemUtil.allocByte(n3);
            }
            this.seek(n);
            if (this.file != null) {
                this.file.read(this.block, 0, n3);
            } else {
                this.stream.read(this.block, 0, n3);
            }
            if (bl) {
                DecryptStream.charStringDecrypt(this.block, 0, n3 - 1);
            }
            Object object2 = this.convertObject(this.block, n3);
            this.blockCache.put(l, object2);
            return object2;
        }
        return object;
    }

    public int getByte(int n) throws IOException {
        if (this.pos != n) {
            this.seek(n);
        }
        return this.nextByte();
    }

    public int getReference(int n, int n2, boolean bl, int n3) throws IOException {
        Log.clog("getBlock not implemented");
        return -1;
    }

    public void initFastHash() {
        this.blockCache = FastHash.newLongObjectHash(50);
    }

    public int nextByte() throws IOException {
        int n = this.file != null ? this.file.read() : this.stream.read();
        ++this.pos;
        return n;
    }

    public int nextByteOffset() {
        return this.pos;
    }

    public void purge() {
    }

    public int read(byte[] byArray) throws IOException {
        int n = byArray.length;
        this.seek(this.pos);
        this.pos += n;
        if (this.file != null) {
            return this.file.read(byArray);
        }
        return this.stream.read(byArray, 0, n);
    }

    public void seek(int n) throws IOException {
        this.pos = n;
        if (this.file != null) {
            this.file.seek(this.bias + n);
        } else {
            this.stream.reset();
            this.stream.skip(this.bias + n);
        }
    }
}

