/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.sidecar.AffineException;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.BezierPath;
import com.adobe.acrobat.sidecar.ComplexPolygon;
import com.adobe.acrobat.sidecar.FloatPoint;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.sidecar.PolygonADV;
import com.adobe.acrobat.sidecar.Stroke;
import com.adobe.acrobat.sidecar.StrokedPolygon;
import com.adobe.util.Assert;
import com.adobe.util.MemUtil;

public class PathStroker {
    private static double Epsilon = 0.001;
    private Stroke fStrokeParams;
    private BezierPath fPath;
    private AffineTransform fTransform;
    private AffineTransform fInverseT;
    private ComplexPolygon fPolygons;
    private ComplexPolygon gPolygons;
    private double[] dashArray;
    private double dashPhase;
    private FloatPoint qstroke;
    private int capStyle;
    private int joinStyle;
    private double miterLimit;
    private double miterCos;
    private boolean fDidInvert;
    private int fCircleSegs;
    private double[] circleX;
    private double[] circleY;

    public PathStroker() {
        this.fStrokeParams = null;
        this.fPath = null;
        this.fTransform = null;
        this.fInverseT = null;
        this.fPolygons = null;
    }

    public PathStroker(Stroke stroke, BezierPath bezierPath, AffineTransform affineTransform) {
        this.fStrokeParams = stroke;
        this.fPath = bezierPath;
        this.fTransform = affineTransform;
        this.fInverseT = null;
        this.fPolygons = null;
    }

    public PathStroker(Stroke stroke, ComplexPolygon complexPolygon, BezierPath bezierPath, AffineTransform affineTransform) {
        this.fStrokeParams = stroke;
        this.fPath = bezierPath;
        this.fTransform = affineTransform;
        this.fInverseT = null;
        this.fPolygons = complexPolygon;
    }

    private ComplexPolygon dashBreaker(PolygonADV polygonADV) {
        ComplexPolygon complexPolygon = new ComplexPolygon();
        int n = this.dashArray.length;
        int n2 = 0;
        boolean bl = true;
        double d = 0.0;
        while (d != this.dashPhase && d + this.dashArray[n2] <= this.dashPhase) {
            d += this.dashArray[n2];
            if (++n2 == n) {
                n2 = 0;
            }
            bl ^= true;
        }
        double d2 = d + this.dashArray[n2] - this.dashPhase;
        if (polygonADV.npoints > 1) {
            double d3 = polygonADV.xpoints[0];
            double d4 = polygonADV.ypoints[0];
            int n3 = 1;
            while (n3 < polygonADV.npoints) {
                double d5;
                double d6;
                double d7;
                double d8;
                double d9;
                double d10;
                PolygonADV polygonADV2 = new PolygonADV();
                polygonADV2.addPoint(d3, d4);
                while (d2 > 0.0 && n3 < polygonADV.npoints) {
                    d10 = polygonADV.xpoints[n3];
                    d9 = d10 - d3;
                    d8 = polygonADV.ypoints[n3];
                    d7 = d8 - d4;
                    d6 = Math.sqrt(d9 * d9 + d7 * d7);
                    if (d6 <= d2) {
                        d3 = d10;
                        d4 = d8;
                        polygonADV2.addPoint(d3, d4);
                        d2 -= d6;
                        ++n3;
                        continue;
                    }
                    d5 = d2 / d6;
                    polygonADV2.addPoint(d3 += d9 * d5, d4 += d7 * d5);
                    d2 = 0.0;
                }
                if (this.capStyle != 1 && polygonADV2.npoints == 1) {
                    if (n3 < polygonADV.npoints) {
                        d10 = polygonADV.xpoints[n3];
                        d8 = polygonADV.ypoints[n3];
                    } else {
                        d10 = polygonADV.xpoints[n3 - 1];
                        d8 = polygonADV.ypoints[n3 - 1];
                        if (d3 == d10 && d4 == d8 && n3 > 1) {
                            d10 = polygonADV.xpoints[n3 - 2];
                            d8 = polygonADV.ypoints[n3 - 2];
                        }
                    }
                    d9 = d10 - d3;
                    d7 = d8 - d4;
                    if (d9 != 0.0 || d7 != 0.0) {
                        d6 = Math.abs(d9);
                        if (d6 < (d5 = Math.abs(d7))) {
                            d6 = d5;
                        }
                        d10 = d3 + Epsilon * (d9 / d6);
                        d8 = d4 + Epsilon * (d7 / d6);
                        polygonADV2.addPoint(d10, d8);
                    }
                }
                if (bl) {
                    complexPolygon.addElement(polygonADV2.compact());
                }
                if (++n2 == n) {
                    n2 = 0;
                }
                d2 = this.dashArray[n2];
                bl ^= true;
            }
        } else if (bl) {
            complexPolygon.addElement(polygonADV.compact());
        }
        int n4 = complexPolygon.size();
        if (n4 > 1) {
            PolygonADV polygonADV3 = (PolygonADV)complexPolygon.elementAt(0);
            PolygonADV polygonADV4 = (PolygonADV)complexPolygon.elementAt(n4 - 1);
            if (polygonADV3.xpoints[0] == polygonADV4.xpoints[polygonADV4.npoints - 1] && polygonADV3.ypoints[0] == polygonADV4.ypoints[polygonADV4.npoints - 1]) {
                int n5 = 1;
                while (n5 < polygonADV3.npoints) {
                    polygonADV4.addPoint(polygonADV3.xpoints[n5], polygonADV3.ypoints[n5]);
                    ++n5;
                }
                complexPolygon.removeElementAt(0);
            }
        }
        return complexPolygon;
    }

    private PolygonADV drawCircle(double d, double d2) {
        PolygonADV polygonADV = new PolygonADV(4 * this.fCircleSegs - 3);
        int n = 0;
        while (n < this.fCircleSegs) {
            polygonADV.addPoint(d + this.circleX[n], d2 - this.circleY[n]);
            ++n;
        }
        --n;
        while (--n > 0) {
            polygonADV.addPoint(d - this.circleX[n], d2 - this.circleY[n]);
        }
        while (n < this.fCircleSegs) {
            polygonADV.addPoint(d - this.circleX[n], d2 + this.circleY[n]);
            ++n;
        }
        --n;
        while (--n >= 0) {
            polygonADV.addPoint(d + this.circleX[n], d2 + this.circleY[n]);
        }
        return polygonADV;
    }

    public FloatRect getBoundingBox() {
        FloatRect floatRect;
        Assert.notNull(this.fStrokeParams, "Stroke parameters is NULL");
        if (this.fTransform == null) {
            this.fTransform = AffineTransform.getIdentityMatrix();
        }
        if (this.fPolygons != null) {
            floatRect = this.fPolygons.getBoundingBox();
            FloatPoint floatPoint = this.getTransformedStrokeWidths();
            floatRect = floatRect.grow(floatPoint.x, floatPoint.y);
        } else {
            Assert.notNull(this.fPath, "Cant stroke a NULL path");
            floatRect = this.fPath.getBoundingBox();
            double d = this.fStrokeParams.getWidth() / 2.0;
            floatRect = floatRect.grow(d, d);
            floatRect = floatRect.transformRect(this.fTransform);
        }
        return floatRect;
    }

    public Stroke getStroke() {
        return this.fStrokeParams;
    }

    private FloatPoint getTransformedStrokeWidths() {
        FloatPoint floatPoint;
        double d = this.fStrokeParams.getWidth() / 2.0;
        if (d == 0.0) {
            return new FloatPoint(0.0, 0.0);
        }
        if (this.hasInverseTransform()) {
            FloatPoint floatPoint2 = new FloatPoint(0.0, 0.0).deltaTransform(this.fInverseT);
            FloatPoint floatPoint3 = new FloatPoint(1.0, 0.0).deltaTransform(this.fInverseT);
            FloatPoint floatPoint4 = new FloatPoint(0.0, 1.0).deltaTransform(this.fInverseT);
            double d2 = floatPoint2.distance(floatPoint3);
            double d3 = floatPoint2.distance(floatPoint4);
            floatPoint = new FloatPoint(d / d2, d / d3);
        } else {
            FloatPoint floatPoint5 = new FloatPoint(0.0, 0.0).deltaTransform(this.fTransform);
            FloatPoint floatPoint6 = new FloatPoint(d, 0.0).deltaTransform(this.fTransform);
            FloatPoint floatPoint7 = new FloatPoint(0.0, d).deltaTransform(this.fTransform);
            floatPoint = new FloatPoint(floatPoint5.distance(floatPoint6), floatPoint5.distance(floatPoint7));
        }
        return floatPoint;
    }

    private boolean hasInverseTransform() {
        try {
            if (this.fInverseT == null) {
                this.fInverseT = this.fTransform.getInverse();
            }
        }
        catch (AffineException affineException) {}
        return this.fInverseT != null;
    }

    private boolean isDashed() {
        this.dashArray = this.fStrokeParams.getDashArray();
        double d = 0.0;
        if (this.dashArray != null) {
            this.dashPhase = this.fStrokeParams.getDashPhase();
            int n = this.dashArray.length;
            while (n-- > 0) {
                if (this.dashArray[n] < 0.0) {
                    this.dashArray = null;
                    break;
                }
                d += this.dashArray[n];
            }
            if (d <= 0.0) {
                this.dashArray = null;
            }
        }
        return this.dashArray != null;
    }

    private void makeCircle() {
        int n = (int)Math.ceil(Math.max(this.qstroke.x, this.qstroke.y));
        this.fCircleSegs = 1 + n;
        this.circleX = MemUtil.allocDouble(this.fCircleSegs);
        this.circleY = MemUtil.allocDouble(this.fCircleSegs);
        if (n == 0) {
            return;
        }
        double d = Math.PI / (double)(n + n);
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = d2;
        double d5 = d3;
        this.circleX[0] = this.qstroke.x;
        this.circleY[0] = 0.0;
        this.circleX[this.fCircleSegs - 1] = 0.0;
        this.circleY[this.fCircleSegs - 1] = this.qstroke.y;
        int n2 = 1;
        while (n2 < this.fCircleSegs - 1) {
            this.circleX[n2] = this.qstroke.x * d4;
            this.circleY[n2] = this.qstroke.y * d5;
            double d6 = d4 * d2 - d5 * d3;
            d5 = d5 * d2 + d4 * d3;
            d4 = d6;
            ++n2;
        }
    }

    public void setPath(BezierPath bezierPath) {
        this.fPath = bezierPath;
        this.fPolygons = null;
    }

    private ComplexPolygon strokeOnePolygon(PolygonADV polygonADV) {
        PolygonADV polygonADV2;
        boolean bl = false;
        int n = polygonADV.npoints;
        double[] dArray = MemUtil.allocDouble(n + 1);
        double[] dArray2 = MemUtil.allocDouble(n + 1);
        System.arraycopy(polygonADV.xpoints, 0, dArray, 0, n);
        System.arraycopy(polygonADV.ypoints, 0, dArray2, 0, n);
        int n2 = 0;
        int n3 = 1;
        while (n3 < n) {
            if ((dArray[n2] != dArray[n3] || dArray2[n2] != dArray2[n3]) && n3 != ++n2) {
                dArray[n2] = dArray[n3];
                dArray2[n2] = dArray2[n3];
            }
            ++n3;
        }
        if (n2 > 0 && dArray[n2] == dArray[0] && dArray2[n2] == dArray2[0]) {
            bl = true;
            dArray[n2 + 1] = dArray[1];
            dArray2[n2 + 1] = dArray2[1];
        }
        n = n2 + 1;
        ComplexPolygon complexPolygon = this.joinStyle == 1 ? new ComplexPolygon(n * 2 + 1) : new ComplexPolygon(n + 1);
        if (n == 0) {
            return complexPolygon;
        }
        if (n == 1) {
            if (this.capStyle == 1) {
                PolygonADV polygonADV3 = this.drawCircle(dArray[0], dArray2[0]);
                complexPolygon.addElement(polygonADV3);
            }
            return complexPolygon;
        }
        double d = dArray[0];
        double d2 = dArray2[0];
        double d3 = dArray[1];
        double d4 = dArray2[1];
        double d5 = d3 - d;
        double d6 = d4 - d2;
        double d7 = Math.sqrt(d5 * d5 + d6 * d6);
        double d8 = d5 / d7;
        double d9 = d6 / d7;
        double d10 = this.qstroke.x * d9;
        double d11 = this.qstroke.y * d8;
        if (!bl) {
            switch (this.capStyle) {
                case 1: {
                    polygonADV2 = this.drawCircle(d, d2);
                    complexPolygon.addElement(polygonADV2);
                    break;
                }
                case 2: {
                    d -= this.qstroke.x * d8;
                    d2 -= this.qstroke.y * d9;
                    break;
                }
            }
        }
        double[] dArray3 = new double[5];
        double[] dArray4 = new double[5];
        double[] dArray5 = new double[2];
        double[] dArray6 = new double[2];
        int n4 = 1;
        while (n4 < n) {
            boolean bl2;
            boolean bl3 = bl2 = n4 == n - 1;
            if (bl2 && !bl) {
                switch (this.capStyle) {
                    case 1: {
                        polygonADV2 = this.drawCircle(d3, d4);
                        complexPolygon.addElement(polygonADV2);
                        break;
                    }
                    case 2: {
                        d3 += this.qstroke.x * d8;
                        d4 += this.qstroke.y * d9;
                        break;
                    }
                }
            }
            dArray3[4] = dArray3[0] = d - d10;
            dArray4[4] = dArray4[0] = d2 + d11;
            dArray3[1] = d3 - d10;
            dArray4[1] = d4 + d11;
            dArray3[2] = d3 + d10;
            dArray4[2] = d4 - d11;
            dArray3[3] = d + d10;
            dArray4[3] = d2 - d11;
            polygonADV2 = new PolygonADV(dArray3, dArray4, 5, 7);
            complexPolygon.addElement(polygonADV2);
            if (!bl2 || bl) {
                double d12 = dArray[n4 + 1];
                double d13 = dArray2[n4 + 1];
                double d14 = d12 - d3;
                double d15 = d13 - d4;
                double d16 = Math.sqrt(d14 * d14 + d15 * d15);
                double d17 = d14 / d16;
                double d18 = d15 / d16;
                double d19 = this.qstroke.x * d18;
                double d20 = this.qstroke.y * d17;
                if (d17 != d8 || d18 != d9) {
                    double d21 = d18 * d8 - d17 * d9;
                    switch (this.joinStyle) {
                        case 1: {
                            polygonADV2 = this.drawCircle(d3, d4);
                            complexPolygon.addElement(polygonADV2);
                            break;
                        }
                        case 0: {
                            double d22 = d17 * d8 + d18 * d9;
                            if (d22 >= this.miterCos) {
                                double d23;
                                double d24 = d17 + d8;
                                double d25 = d18 + d9;
                                if (d21 < 0.0) {
                                    dArray5[0] = d3 - d19;
                                    dArray6[0] = d4 + d20;
                                    dArray5[1] = d3;
                                    dArray6[1] = d4;
                                    d23 = Math.abs(d24) >= Math.abs(d25) ? (dArray5[0] - dArray3[1]) / d24 : (dArray6[0] - dArray4[1]) / d25;
                                    polygonADV2.replacePoint(1, dArray3[1] + d23 * d8, dArray4[1] + d23 * d9);
                                    polygonADV2.insertPoints(1, dArray5, dArray6, 2);
                                    break;
                                }
                                dArray5[0] = d3;
                                dArray6[0] = d4;
                                dArray5[1] = d3 + d19;
                                dArray6[1] = d4 - d20;
                                d23 = Math.abs(d24) >= Math.abs(d25) ? (dArray5[1] - dArray3[2]) / d24 : (dArray6[1] - dArray4[2]) / d25;
                                polygonADV2.replacePoint(2, dArray3[2] + d23 * d8, dArray4[2] + d23 * d9);
                                polygonADV2.insertPoints(1, dArray5, dArray6, 2);
                                break;
                            }
                        }
                        default: {
                            if (d21 < 0.0) {
                                dArray5[0] = d3 - d19;
                                dArray6[0] = d4 + d20;
                                dArray5[1] = d3;
                                dArray6[1] = d4;
                            } else {
                                dArray5[0] = d3;
                                dArray6[0] = d4;
                                dArray5[1] = d3 + d19;
                                dArray6[1] = d4 - d20;
                            }
                            polygonADV2.insertPoints(1, dArray5, dArray6, 2);
                            break;
                        }
                    }
                }
                d = d3;
                d2 = d4;
                d3 = d12;
                d4 = d13;
                d5 = d14;
                d6 = d15;
                d7 = d16;
                d8 = d17;
                d9 = d18;
                d10 = d19;
                d11 = d20;
            }
            ++n4;
        }
        return complexPolygon;
    }

    public StrokedPolygon strokePath(boolean bl, boolean bl2) {
        Assert.notNull(this.fStrokeParams, "Stroke parameters is NULL");
        if (this.fTransform == null) {
            this.fTransform = AffineTransform.getIdentityMatrix();
        }
        if (this.fPolygons == null) {
            Assert.notNull(this.fPath, "Cant stroke a NULL path");
            BezierPath bezierPath = this.fPath.transform(this.fTransform);
            this.fPolygons = bezierPath.flattenBezierPath();
        }
        this.gPolygons = this.fPolygons;
        this.capStyle = this.fStrokeParams.getCapStyle();
        this.joinStyle = this.fStrokeParams.getJoinStyle();
        this.miterLimit = this.fStrokeParams.getMiterLimit();
        if (this.miterLimit <= 1.0) {
            this.miterLimit = 1.0;
            this.miterCos = 1.1;
        } else {
            this.miterCos = 2.0 / (this.miterLimit * this.miterLimit) - 1.0;
        }
        this.qstroke = this.getTransformedStrokeWidths();
        if (this.capStyle == 1 || this.joinStyle == 1) {
            this.makeCircle();
        }
        if (this.isDashed() && this.hasInverseTransform()) {
            this.gPolygons = (ComplexPolygon)this.gPolygons.clone();
            this.transformPolygons(this.gPolygons, this.fInverseT);
            int n = this.gPolygons.size();
            ComplexPolygon complexPolygon = new ComplexPolygon(n);
            int n2 = 0;
            while (n2 < n) {
                ComplexPolygon complexPolygon2 = this.dashBreaker((PolygonADV)this.gPolygons.elementAt(n2));
                int n3 = complexPolygon2.size();
                int n4 = 0;
                while (n4 < n3) {
                    complexPolygon.addElement(complexPolygon2.elementAt(n4));
                    ++n4;
                }
                ++n2;
            }
            this.gPolygons = complexPolygon;
            this.transformPolygons(this.gPolygons, this.fTransform);
        }
        return this.strokeSimplePath(this.gPolygons, bl, bl2);
    }

    private ComplexPolygon strokePolygons(ComplexPolygon complexPolygon) {
        int n = complexPolygon.size();
        ComplexPolygon complexPolygon2 = new ComplexPolygon(n, 20);
        int n2 = 0;
        while (n2 < n) {
            PolygonADV polygonADV = (PolygonADV)complexPolygon.elementAt(n2);
            complexPolygon2.append(this.strokeOnePolygon(polygonADV));
            ++n2;
        }
        return complexPolygon2;
    }

    private StrokedPolygon strokeSimplePath(ComplexPolygon complexPolygon, boolean bl, boolean bl2) {
        if (!bl2 && this.qstroke.x < 1.0 && this.qstroke.y < 1.0) {
            StrokedPolygon strokedPolygon = new StrokedPolygon(complexPolygon, false);
            return strokedPolygon;
        }
        ComplexPolygon complexPolygon2 = this.strokePolygons(complexPolygon);
        StrokedPolygon strokedPolygon = new StrokedPolygon(complexPolygon2, true);
        return strokedPolygon;
    }

    private void transformPolygons(ComplexPolygon complexPolygon, AffineTransform affineTransform) {
        int n = complexPolygon.size();
        int n2 = 0;
        while (n2 < n) {
            PolygonADV polygonADV = (PolygonADV)complexPolygon.elementAt(n2);
            affineTransform.transformPoints(polygonADV.xpoints, polygonADV.ypoints, polygonADV.npoints);
            ++n2;
        }
    }
}

