/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.sidecar.ComplexPolygon;
import com.adobe.acrobat.sidecar.PolygonADV;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class Region
extends Vector {
    private static Region gUniversalRegion = null;
    private Rectangle bounds = null;

    public Region() {
    }

    public Region(int n) {
        super(n);
    }

    public Region(int n, int n2) {
        super(n, n2);
    }

    private Region(Region region) {
        int n = 0;
        while (n < region.elementCount) {
            Object object = region.elementData[n];
            if (object != null && object instanceof Rectangle && !((Rectangle)object).isEmpty()) {
                this.addElement(object);
            }
            ++n;
        }
    }

    public Region(Rectangle rectangle) {
        if (rectangle != null && !rectangle.isEmpty()) {
            this.addElement(rectangle);
        }
    }

    public Region add(Rectangle rectangle) {
        if (rectangle == null || rectangle.isEmpty()) {
            return this;
        }
        Region region = new Region(this);
        int n = 0;
        while (n < this.elementCount) {
            Rectangle rectangle2 = (Rectangle)region.elementData[n];
            if (Region.contains(rectangle2, rectangle)) {
                return region;
            }
            if (Region.contains(rectangle, rectangle2)) {
                region.elementData[n] = rectangle;
                return region;
            }
            ++n;
        }
        region.addElement(rectangle);
        return region;
    }

    public boolean contains(int n, int n2) {
        int n3 = 0;
        while (n3 < this.elementCount) {
            Rectangle rectangle = (Rectangle)this.elementData[n3];
            if (rectangle.contains(n, n2)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    private static boolean contains(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle.contains(rectangle2.x, rectangle2.y) && rectangle.contains(rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 1);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Region)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Region region = (Region)object;
        if (this.elementCount != region.elementCount) {
            return false;
        }
        int n = 0;
        while (n < this.elementCount) {
            if (!this.elementData[n].equals(region.elementData[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public synchronized Rectangle getBounds() {
        if (this.bounds == null && this.elementCount != 0) {
            Rectangle rectangle = (Rectangle)this.elementData[0];
            if (this.elementCount == 1) {
                this.bounds = rectangle;
            } else {
                int n = rectangle.x;
                int n2 = n + rectangle.width;
                int n3 = rectangle.y;
                int n4 = n3 + rectangle.height;
                int n5 = 1;
                while (n5 < this.elementCount) {
                    rectangle = (Rectangle)this.elementData[n5];
                    n = Math.min(n, rectangle.x);
                    n2 = Math.max(n2, rectangle.x + rectangle.width);
                    n3 = Math.min(n3, rectangle.y);
                    n4 = Math.max(n4, rectangle.y + rectangle.height);
                    ++n5;
                }
                this.bounds = new Rectangle(n, n3, n2 - n, n4 - n3);
            }
        }
        if (this.bounds == null) {
            this.bounds = new Rectangle();
        }
        return this.bounds;
    }

    ComplexPolygon getPolys() {
        ComplexPolygon complexPolygon = new ComplexPolygon(this.elementCount);
        int n = 0;
        while (n < this.elementCount) {
            complexPolygon.addElement(new PolygonADV((Rectangle)this.elementData[n]));
            ++n;
        }
        return complexPolygon;
    }

    public Rectangle[] getRects() {
        Rectangle[] rectangleArray = new Rectangle[this.elementCount];
        int n = 0;
        while (n < this.elementCount) {
            rectangleArray[n] = (Rectangle)this.elementData[n];
            ++n;
        }
        return rectangleArray;
    }

    public static Region getUniversalRegion() {
        if (gUniversalRegion == null) {
            gUniversalRegion = new Region(new Rectangle(-1073741824, -1073741824, Integer.MAX_VALUE, Integer.MAX_VALUE));
        }
        return gUniversalRegion;
    }

    public Region intersect(Rectangle rectangle) {
        Region region = new Region();
        int n = 0;
        while (n < this.elementCount) {
            Rectangle rectangle2 = (Rectangle)this.elementData[n];
            if (rectangle2.intersects(rectangle)) {
                region.addElement(rectangle2.intersection(rectangle));
            }
            ++n;
        }
        return region;
    }

    public Region subtract(Rectangle rectangle) {
        if (rectangle == null || rectangle.isEmpty()) {
            return this;
        }
        Region region = new Region();
        int n = 0;
        while (n < this.elementCount) {
            Rectangle rectangle2 = (Rectangle)this.elementData[n];
            if (rectangle2.intersects(rectangle)) {
                Rectangle rectangle3 = rectangle2.intersection(rectangle);
                if (rectangle2.y < rectangle3.y) {
                    region.addElement(new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle3.y - rectangle2.y));
                }
                if (rectangle2.y + rectangle2.height > rectangle3.y + rectangle3.height) {
                    region.addElement(new Rectangle(rectangle2.x, rectangle3.y + rectangle3.height, rectangle2.width, rectangle2.y + rectangle2.height - (rectangle3.y + rectangle3.height)));
                }
                if (rectangle2.x < rectangle3.x) {
                    region.addElement(new Rectangle(rectangle2.x, rectangle2.y, rectangle3.x - rectangle2.x, rectangle2.height));
                }
                if (rectangle2.x + rectangle2.width > rectangle3.x + rectangle3.width) {
                    region.addElement(new Rectangle(rectangle3.x + rectangle3.width, rectangle2.y, rectangle2.x + rectangle2.width - (rectangle3.x + rectangle3.width), rectangle2.height));
                }
            } else {
                region.addElement(rectangle2);
            }
            ++n;
        }
        return region;
    }

    public String toString2() {
        Rectangle rectangle = this.getBounds();
        return "Region, bbox = (" + rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height + ")";
    }

    public Region union(Rectangle rectangle) {
        return this.add(rectangle);
    }
}

