/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.pdf.ColorValue;
import com.adobe.acrobat.sidecar.AffineException;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.ClipShape;
import com.adobe.acrobat.sidecar.Stroke;
import java.util.Vector;

public class State
implements Cloneable {
    State fPrevState = null;
    AffineTransform ctm = null;
    public Stroke stroke = new Stroke();
    public ColorValue strokeColor = ColorValue.black;
    public ColorValue fillColor = ColorValue.black;
    public Vector xforms = null;
    public ClipShape fClipShape = null;
    public boolean xor = false;
    double a;
    double b;
    double c;
    double d;
    double x;
    double y;

    public void appendXform(AffineTransform affineTransform) {
        if (this.xforms == null) {
            this.xforms = new Vector(10);
        }
        this.xforms.addElement(affineTransform);
        this.ctm = null;
    }

    public AffineTransform getCurrentTransform() {
        if (this.ctm == null) {
            if (this.xforms != null) {
                int n = this.xforms.size();
                this.ctm = (AffineTransform)this.xforms.elementAt(--n);
                while (--n >= 0) {
                    this.ctm = this.ctm.appendTransform((AffineTransform)this.xforms.elementAt(n));
                }
            } else {
                this.ctm = AffineTransform.getIdentityMatrix();
            }
        }
        return this.ctm;
    }

    public AffineTransform getInverseTransform() {
        AffineTransform affineTransform = null;
        try {
            affineTransform = this.getCurrentTransform().getInverse();
        }
        catch (AffineException affineException) {}
        return affineTransform;
    }

    public void prePendXform(AffineTransform affineTransform) {
        if (this.xforms == null) {
            this.xforms = new Vector(10);
        }
        this.xforms.insertElementAt(affineTransform, 0);
        this.ctm = null;
    }

    public void removeFirstTransform() {
        this.xforms.removeElementAt(0);
        this.ctm = null;
    }

    public void removeLastTransform() {
        this.xforms.removeElementAt(this.xforms.size() - 1);
        this.ctm = null;
    }

    public State restore() {
        if (this.fPrevState != null) {
            return this.fPrevState;
        }
        this.ctm = null;
        return this;
    }

    public State restoreAll() {
        State state = this;
        while (state.fPrevState != null) {
            state = state.fPrevState;
        }
        this.ctm = null;
        return state;
    }

    public State save() {
        State state = new State();
        state.fPrevState = this;
        state.stroke = this.stroke;
        state.strokeColor = this.strokeColor;
        state.fillColor = this.fillColor;
        state.fClipShape = (ClipShape)this.fClipShape.clone();
        state.xor = this.xor;
        state.xforms = this.xforms == null ? null : (Vector)this.xforms.clone();
        return state;
    }

    public void setXform(AffineTransform affineTransform) {
        this.xforms = null;
        this.appendXform(affineTransform);
    }
}

