#
# This file is part of Zaplet
# Copyright 1999 - 2001 Adam Feuer <adamf@pobox.com>
#
# Zaplet is free software; you can redistribute it and/or modify
# it under the terms of the Python License as published by the
# Python Software Foundation, or GNU General Public License as published
# by the Free Software Foundation (either version 2 of the License, or
# (at your option) any later version).
#
# Zaplet is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Zaplet; see the file COPYING-Zaplet. If not, write to the
# Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
#
# You should have received a copy of the Python License along
# with Zaplet; see the file COPYING.
#
#
# ui/process_dtml.py
# adzapper experimental User Interface handler
#
# for use with adzapper filtering proxy

# standard modules
import re
import string
import StringIO
import sys
import os

# adzapper modules
from debug import debug
import ui

RCS_ID =  '$Id: dtml.py,v 1.4 2001/09/02 04:47:16 adamf Exp $'


ERROR_FILE_NOT_FOUND = "Error: DTML file not found.<p>"


def process_dtml(dtmlfilename,args,restofpath=None):
    """process the DTML page referred to by uimodule

    dtmlfilename is a string
    args is a dictionary of query (name,value) tuples
    restofpath is a string"""

    dtmlfilepath = os.path.join(ui.DTMLDIR,dtmlfilename)

#    debug.debug(1,"process_dtml- dtmlfilename: %s" % dtmlfilename)
#    debug.debug(1,"process_dtml- DTMLDIR: %s" % ui.DTMLDIR)
#    debug.debug(1,"process_dtml- dtmlfilepath: %s" % dtmlfilepath)
    
    try:
        file = open(dtmlfilepath)
        contents = file.read()
        file.close()
    except:
        contents = ERROR_FILE_NOT_FOUND

    html = replace_dtml_vars(contents,args)

    return html


def replace_dtml_vars(dtml_page,args=None):
    for key in ui.vars.keys():
        dtmlvar = "<dtml-var %s>" % key
        debug.debug(1,"replace_dtml_vars- dtmlvar: %s" % dtmlvar)
        dtml_page=string.replace(dtml_page,dtmlvar,ui.vars[key])

    for key in args.keys():
        dtmlvar = "<dtml-var %s>" % key
        debug.debug(1,"replace_dtml_vars- dtmlvar: %s" % dtmlvar)
        dtml_page=string.replace(dtml_page,dtmlvar,args[key])

    return dtml_page



def process_file(filename):
    """get a file and return it"""

    content_type='text/plain'

    # set content-type depending on file extension
    if len(filename) > 4:
        if filename[-4:] == '.gif':
            content_type='image/gif'
        elif filename[-4:] == '.jpg':
            content_type='image/jpg'
        elif filename[-4:] == '.png':
            content_type='image/png'
        elif filename[-4:] == '.htm':
            content_type='text/html'

    if len(filename) > 5:
        if filename[-5:] == '.html':
            content_type='text/html'
        if filename[-5:] == '.dtml':
            content_type='text/html'
            
    filepath = os.path.join(ui.DTMLDIR,filename)

    debug.debug(1,"process_file- filename: %s" % filename)
    debug.debug(1,"process_file- DTMLDIR: %s" % ui.DTMLDIR)
    debug.debug(1,"process_file- filepath: %s" % filepath)
    
    try:
        file = open(filepath, 'rb') # open for binary read - we need this for Windows!
        contents = file.read()
        file.close()
    except:
        contents = ERROR_FILE_NOT_FOUND

    return [content_type,contents]




