#
# This file is part of Zaplet
# Copyright 1999 - 2001 Adam Feuer <adamf@pobox.com>
#
# Zaplet is free software; you can redistribute it and/or modify
# it under the terms of the Python License as published by the
# Python Software Foundation, or GNU General Public License as published
# by the Free Software Foundation (either version 2 of the License, or
# (at your option) any later version).
#
# Zaplet is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Zaplet; see the file COPYING-Zaplet. If not, write to the
# Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
#
# You should have received a copy of the Python License along
# with Zaplet; see the file COPYING.
#
#
# ui/html_table.py
# for use with adzapper filtering proxy

# standard modules
import re
import string

RCS_ID =  '$Id: html_table.py,v 1.3 2001/09/02 04:47:16 adamf Exp $'

#BG_SHADE_COLOR='#F7F6CD'
BG_SHADE_COLOR='#F9F9ED'
NO_SHADE_COLOR='#FFFFFF'

####################################################################


class html_table:
    """build and maintain an html table as a list of lists
    there is a list of rows, and each row has list of cell elements
    __repr__ returns the html string"""

    def __init__(self, shade=None, fontspec=''):
        self.rows = []
        self.current_row = None
        self.current_cell = None

        self.border = '0'
        self.cellpadding = '6'
        self.cellspacing = '0'
        self.width = '100%'
        
        if shade == None:
            self.shade_on = 0
        else:
            self.shade_on = 1
            
        self.shade = shade

        self.fontspec = fontspec
        
        self.noshade_color = NO_SHADE_COLOR  # override these to change the table colors 
        self.shade_color = BG_SHADE_COLOR

        self.color = [self.noshade_color,self.shade_color]

    def __repr__(self):
        s = ''
        s = s + '<table border="%s" cellpadding="%s" cellspacing="%s" width="%s">\n' % (self.border, self.cellpadding, self.cellspacing, self.width)

        for row in self.rows:
            if self.shade_on != None:
                self._toggle_shade_color()
            s = s + '    <tr>\n'
            hr = ''
            for cell in row:
                hr = hr + '      '
                hr = hr + '<td bgcolor="%s">' % self.color[self.shade]
                hr = hr + self.fontspec
                hr = hr + cell
                hr = hr + '</td>\n'
            s = s + hr
            s = s + '    </tr>\n'
            
        s = s + '</table>\n'
        return s

    def string(self):
        return self.__repr__()

    def new_row(self):
        self.rows.append([])
        self._incr_row()
        return self.current_row

    def new_cell(self,s):
        self.rows[self.current_row].append(s)
        self._incr_cell()
        return self.current_cell

    def current_row(self):
        return self.current_row

    def current_cell(self):
        return self.current_cell

    def _toggle_shade_color(self):
        self.shade = not self.shade

    def _incr_row(self):
        if self.current_row == None:
            self.current_row = 0
        else:
            self.current_row = self.current_row + 1

    def _incr_cell(self):
        if self.current_cell == None:
            self.current_cell = 0
        else:
            self.current_cell = self.current_cell + 1



if __name__ == "__main__":
    t = html_table()
    t.new_row()
    t.new_cell("first cell")
    t.new_cell("second cell")
    t.new_row()
    t.new_cell("third cell")
    t.new_cell("fourth cell")
    print t

    t = html_table(1)
    t.new_row()
    t.new_cell("cell 1")
    t.new_cell("cell 2")
    t.new_row()
    t.new_cell("cell 3")
    t.new_cell("cell 4")
    print t.string()

