#
# This file is part of Zaplet
# Copyright 1999 - 2001 Adam Feuer <adamf@pobox.com>
#
# Zaplet is free software; you can redistribute it and/or modify
# it under the terms of the Python License as published by the
# Python Software Foundation, or GNU General Public License as published
# by the Free Software Foundation (either version 2 of the License, or
# (at your option) any later version).
#
# Zaplet is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Zaplet; see the file COPYING-Zaplet. If not, write to the
# Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
#
# You should have received a copy of the Python License along
# with Zaplet; see the file COPYING.
#

# zaplet filter_object class
# for use with adzapper filtering proxy

RCS_ID =  '$Id: filter_object.py,v 1.2 2001/09/02 04:47:17 adamf Exp $'

# standard modules
import re
import string

# adzapper modules
from debug import debug
import zaplet

##################################################################
#
# filter object- list of these contained in zaplet object
#
class filter_obj:
    """data structure object to hold filter"""
    def __init__(self):
        self.filter_match_url_type = ''
        self.filter_match_url = ''
        self.filter_match_url_re = None
        self.filter_match_url_everything = 0  # we do this for convenience in the adzapper filter core code

        self.filter_match_text_type = ''
        self.filter_match_text = ''
        self.filter_match_text_re = None

        self.filter_replace_text = ''

    


    def compile(self):

        mustr = ''
        if self.filter_match_url_type == "everything":
            mustr = "."
            self.filter_match_url_everything = 1
        elif self.filter_match_url_type == "regex":
            mustr = self.filter_match_url
        elif self.filter_match_url_type == "literal":
            mustr = re.escape(self.filter_match_url)
        else:
            # unknown type, treat as literal
            mustr = re.escape(self.filter_match_url)
        self.filter_match_url_re = re.compile(mustr,re.DOTALL)  # means that '.' matches newlines

        mtstr = ''
        if self.filter_match_text_type == "regex":
            mtstr = self.filter_match_text
        elif self.filter_match_text_type == "literal":
            mtstr = re.escape(self.filter_match_text)
        self.filter_match_text_re = re.compile(mtstr,re.DOTALL)  # means that '.' matches newlines



    def xml_repr(self,indent=None):
        """return an xml fragment representation of ourself"""

        if indent:
            findent = indent
        else:
            findent = ''

        fpindent = findent + "  "
        
        s1 = '\n'
        s1 = s1 + findent + '<filter>\n'


        s1 = s1 + fpindent + '<filter_match_url type="' + self.filter_match_url_type + '"'
        if (self.filter_match_url_type == 'everything'):
            s1 = s1 + '/>\n'
        else:
            s1 = s1 + '>' + self.filter_match_url + '</filter_match_url>\n'

        s1 = s1 + fpindent + '<filter_match_text type="' + self.filter_match_text_type + '"><![CDATA[' + self.filter_match_text + ']]></filter_match_text>\n'
        
        s1 = s1 + fpindent + '<filter_replace_text><![CDATA[' + self.filter_replace_text + ']]></filter_replace_text>\n'

        s1 = s1 + findent + '</filter>\n'

        return s1


    def printself(self):
        debug.debug(7,"filter")
        debug.debug(7," filter match URL type: %s" % self.filter_match_url_type)
        debug.debug(7," filter match URL: %s" % self.filter_match_url)
        debug.debug(7," filter match URL everything: %d" % self.filter_match_url_everything)
        debug.debug(7," filter match text type: %s" % self.filter_match_text_type)
        debug.debug(7," filter match_text: %s" % self.filter_match_text)
        debug.debug(7," filter replace text: %s" % self.filter_replace_text)
