#
# This file is part of Zaplet
# Copyright 1999 - 2001 Adam Feuer <adamf@pobox.com>
#
# Zaplet is free software; you can redistribute it and/or modify
# it under the terms of the Python License as published by the
# Python Software Foundation, or GNU General Public License as published
# by the Free Software Foundation (either version 2 of the License, or
# (at your option) any later version).
#
# Zaplet is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Zaplet; see the file COPYING-Zaplet. If not, write to the
# Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
#
# You should have received a copy of the Python License along
# with Zaplet; see the file COPYING.
#

# zaplet classes
# for use with adzapper filtering proxy

RCS_ID =  '$Id: zaplet_sax_handler.py,v 1.6 2001/09/02 04:47:17 adamf Exp $'

# standard modules
import os
import re
import string
import sys
import urlparse
import socket

# XML modules
from xml.sax import saxexts, saxlib, saxutils

# adzapper modules
from debug import debug
from filter_object import filter_obj


##################################################################
#
# ZapletDocHandler
#
class ZapletDocHandler(saxlib.HandlerBase):
    """SAX document handler for parsing new format zaplets-

    needs to be passed a zaplet to fill up with data.
    note: does not compile zaplet.
    """
    
    def __init__(self,zaplet):
        # Initialize the flags to false
        self.intext = 0
        self.inallowurl = 0
        self.inblockurl = 0
        self.infilter = 0
        self.text = ''

        self.current_filter = None
        
        self.zaplet = zaplet

            
    def characters(self, ch, start, length):
        if self.intext:
            self.text = self.text + ch[start:start+length]


    def startElement(self, name, attrs):
        if name == 'zaplet':
            pass
        elif name == 'version':
            self.intext = 1
        elif name == 'host':
            self.intext = 1
        elif name == 'comment':
            self.intext = 1
        elif name == 'allow_url':
            self.intext = 1
            self.allow_url_type = attrs.get('type',None)
            if self.allow_url_type == "everything":
                self.zaplet.allow_everything = 1
                debug.debug(7,'zaplet_sax_handler allow_everything: %s %s' % (self.zaplet.host, self.zaplet.allow_everything))
        elif name == 'block_url':
            self.intext = 1
            self.block_url_type = attrs.get('type',None)
            if self.block_url_type == "everything":
                self.zaplet.block_everything = 1
                debug.debug(7,'zaplet_sax_handler, block_everything: %s %s' % (self.zaplet.host, self.zaplet.block_everything))
        elif name == 'block_popups':
            self.intext = 1
            self.block_popups_type = attrs.get('type',None)
            if self.block_popups_type == "everything":
                self.zaplet.block_popups_everything = 1
        elif name == 'filter':
            self.infilter = 1
            self.current_filter = filter_obj()
        elif name == 'filter_match_url':
            self.intext = 1
            self.current_filter.filter_match_url_type = attrs.get('type',None)
            debug.debug(7,"zaplet_sax_handler: filter_match_url_type: %s" % self.current_filter.filter_match_url_type)
        elif name == 'filter_match_text':
            self.intext = 1
            self.current_filter.filter_match_text_type = attrs.get('type',None)
            debug.debug(7,"zaplet_sax_handler: filter_match_text_type: %s" % self.current_filter.filter_match_text_type)
        elif name == 'filter_replace_text':
            self.intext = 1


    def endElement(self, name):
        if name == 'zaplet':
            pass
        elif name == 'version':
            self.intext = 0
            self.zaplet.version = self.text[:]
            self.text = ''
        elif name == 'host':
            self.intext = 0
            self.zaplet.host = self.text[:]
            self.text = ''
        elif name == 'comment':
            self.intext = 0
            self.zaplet.comments.append(self.text[:])
            self.text = ''
        elif name == 'allow_url':
            self.intext = 0
            if self.allow_url_type == "literal":
                self.zaplet.allow_literal.append(self.text[:])
            elif self.allow_url_type == "regex":
                self.zaplet.allow_regex.append(self.text[:])
            self.text = ''
        elif name == 'block_url':
            self.intext = 0
            if self.block_url_type == "literal":
                self.zaplet.block_literal.append(self.text[:])
            elif self.block_url_type == "regex":
                self.zaplet.block_regex.append(self.text[:])
            self.text = ''
        elif name == 'block_popups':
            self.intext = 0
            if self.block_popups_type == "literal":
                self.zaplet.block_popups_literal.append(self.text[:])
            elif self.block_popups_type == "regex":
                self.zaplet.block_popups_regex.append(self.text[:])
            self.text = ''
        elif name == 'filter':
            self.infilter = 0
            debug.debug(7,"zaplet_sax_handler: filter_match_url: %s" % self.current_filter.filter_match_url)
            debug.debug(7,"zaplet_sax_handler: filter_match_text: %s" % self.current_filter.filter_match_text)
            debug.debug(7,"zaplet_sax_handler: filter_replace_text: %s" % self.current_filter.filter_replace_text)
            self.zaplet.filters.append(self.current_filter)
            self.current_filter.printself()
            self.current_filter = None
            self.text = ''
        elif name == 'filter_match_url':
            self.intext = 0
            self.current_filter.filter_match_url = self.text[:]
            debug.debug(7,"zaplet_sax_handler: filter_match_url: %s" % self.current_filter.filter_match_url)
            self.text = ''
        elif name == 'filter_match_text':
            self.intext = 0
            self.current_filter.filter_match_text = self.text[:]
            debug.debug(7,"zaplet_sax_handler: filter_match_text: %s" % self.current_filter.filter_match_text)
            self.text = ''
        elif name == 'filter_replace_text':
            self.intext = 0
            self.current_filter.filter_replace_text = self.text[:]
            debug.debug(7,"zaplet_sax_handler: filter_replace_text: %s" % self.current_filter.filter_replace_text)
            self.text = ''

