/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.FontUIResource;
import snmp.SNMPInteger;
import snmp.SNMPObject;
import snmp.SNMPOctetString;
import snmp.SNMPSequence;
import snmp.SNMPVarBindList;
import snmp.SNMPv1CommunicationInterface;

public class LinkMonitor
extends JFrame
implements ActionListener,
Runnable {
    JButton newHostButton;
    JButton newCommunityButton;
    JButton newWirelessHostButton;
    JButton scanButton;
    JTextArea messagesArea;
    JScrollPane messagesScroll;
    JTextField hostIDField;
    JTextField communityField;
    JTextField wirelessHostField;
    JTextField wirelessHostMACField;
    JLabel authorLabel;
    JLabel hostIDLabel;
    JLabel communityLabel;
    JLabel wirelessHostLabel;
    JLabel wirelessHostMACLabel;
    JProgressBar localSignalBar;
    JProgressBar localSNRBar;
    JProgressBar localNoiseBar;
    JProgressBar remoteSignalBar;
    JProgressBar remoteSNRBar;
    JProgressBar remoteNoiseBar;
    JLabel localSignalTextField;
    JLabel localSNRTextField;
    JLabel localNoiseTextField;
    JLabel remoteSignalTextField;
    JLabel remoteSNRTextField;
    JLabel remoteNoiseTextField;
    MenuBar theMenubar;
    Menu fileMenu;
    MenuItem quitItem;
    MenuItem aboutItem;
    SNMPv1CommunicationInterface comInterface;
    String community;
    InetAddress hostAddress;
    int version;
    int wirelessHostNum = 1;
    Thread statusThread;

    public LinkMonitor() {
        this.setUpDisplay();
        try {
            this.community = "public";
            this.version = 0;
            this.hostAddress = InetAddress.getByName(this.hostIDField.getText());
            this.comInterface = new SNMPv1CommunicationInterface(this.version, this.hostAddress, this.community);
            this.comInterface.setSocketTimeout(5000);
            this.statusThread = new Thread(this);
        }
        catch (Exception exception) {
            this.messagesArea.setText("Exception during connection status polling startup:  " + exception + "\n");
        }
    }

    private void setUpDisplay() {
        Object object;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {}
        this.getRootPane().setBorder(new BevelBorder(0));
        UIManager uIManager = new UIManager();
        FontUIResource fontUIResource = new FontUIResource("SansSerif", 0, 10);
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (((String)object).indexOf("font") <= -1 && ((String)object).indexOf("Font") <= -1) continue;
            UIManager.put(object, fontUIResource);
        }
        this.addWindowListener(new WindowCloseAdapter());
        this.theMenubar = new MenuBar();
        this.setMenuBar(this.theMenubar);
        this.fileMenu = new Menu("File");
        this.aboutItem = new MenuItem("About...");
        this.aboutItem.setActionCommand("about");
        this.aboutItem.addActionListener(this);
        this.fileMenu.add(this.aboutItem);
        this.fileMenu.addSeparator();
        this.quitItem = new MenuItem("Quit");
        this.quitItem.setActionCommand("quit");
        this.quitItem.addActionListener(this);
        this.fileMenu.add(this.quitItem);
        this.theMenubar.add(this.fileMenu);
        this.hostIDLabel = new JLabel("Base station address:");
        this.hostIDField = new JTextField(20);
        this.hostIDField.setText("10.0.1.1");
        this.hostIDField.setEditable(false);
        this.communityLabel = new JLabel("Community (password):");
        this.communityField = new JTextField(20);
        this.communityField.setText("");
        this.communityField.setEditable(false);
        this.wirelessHostLabel = new JLabel("Wireless host name:");
        this.wirelessHostField = new JTextField(20);
        this.wirelessHostField.setText("");
        this.wirelessHostField.setEditable(false);
        this.wirelessHostMACLabel = new JLabel("Wireless host MAC:");
        this.wirelessHostMACField = new JTextField(20);
        this.wirelessHostMACField.setText("");
        this.wirelessHostMACField.setEditable(false);
        this.authorLabel = new JLabel(" Version 1.1        J. Sevy, May 2001");
        this.authorLabel.setFont(new Font("SansSerif", 2, 8));
        this.newHostButton = new JButton("   Set address  ");
        this.newHostButton.setActionCommand("new host");
        this.newHostButton.addActionListener(this);
        this.newCommunityButton = new JButton(" Set community ");
        this.newCommunityButton.setActionCommand("new community");
        this.newCommunityButton.addActionListener(this);
        this.newWirelessHostButton = new JButton("Select new host");
        this.newWirelessHostButton.setActionCommand("new wireless host");
        this.newWirelessHostButton.addActionListener(this);
        this.scanButton = new JButton("Test wireless link");
        this.scanButton.setActionCommand("test link");
        this.scanButton.addActionListener(this);
        this.localSignalBar = new JProgressBar(0, 100);
        this.localSignalBar.setValue(0);
        this.localSNRBar = new JProgressBar(0, 100);
        this.localSNRBar.setValue(0);
        this.localNoiseBar = new JProgressBar(0, 100);
        this.localNoiseBar.setValue(0);
        this.remoteSignalBar = new JProgressBar(0, 100);
        this.remoteSignalBar.setValue(0);
        this.remoteSNRBar = new JProgressBar(0, 100);
        this.remoteSNRBar.setValue(0);
        this.remoteNoiseBar = new JProgressBar(0, 100);
        this.remoteNoiseBar.setValue(0);
        object = new Dimension(20, 20);
        this.localSignalTextField = new JLabel();
        this.localSignalTextField.setPreferredSize((Dimension)object);
        this.localSNRTextField = new JLabel();
        this.localSNRTextField.setPreferredSize((Dimension)object);
        this.localNoiseTextField = new JLabel();
        this.localNoiseTextField.setPreferredSize((Dimension)object);
        this.remoteSignalTextField = new JLabel();
        this.remoteSignalTextField.setPreferredSize((Dimension)object);
        this.remoteSNRTextField = new JLabel();
        this.remoteSNRTextField.setPreferredSize((Dimension)object);
        this.remoteNoiseTextField = new JLabel();
        this.remoteNoiseTextField.setPreferredSize((Dimension)object);
        this.messagesArea = new JTextArea(5, 50);
        this.messagesScroll = new JScrollPane(this.messagesArea);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.setTitle("Access Point Wireless Link Quality Monitoring Utility");
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.hostIDLabel, gridBagConstraints);
        panel.add(this.hostIDLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.hostIDField, gridBagConstraints);
        panel.add(this.hostIDField);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.newHostButton, gridBagConstraints);
        panel.add(this.newHostButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.communityLabel, gridBagConstraints);
        panel.add(this.communityLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.communityField, gridBagConstraints);
        panel.add(this.communityField);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.newCommunityButton, gridBagConstraints);
        panel.add(this.newCommunityButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.wirelessHostLabel, gridBagConstraints);
        panel.add(this.wirelessHostLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.wirelessHostField, gridBagConstraints);
        panel.add(this.wirelessHostField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.wirelessHostMACLabel, gridBagConstraints);
        panel.add(this.wirelessHostMACLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.wirelessHostMACField, gridBagConstraints);
        panel.add(this.wirelessHostMACField);
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.newWirelessHostButton, gridBagConstraints);
        panel.add(this.newWirelessHostButton);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.scanButton, gridBagConstraints);
        panel.add(this.scanButton);
        gridBagConstraints.gridwidth = 1;
        Panel panel2 = new Panel();
        panel2.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        JLabel jLabel = new JLabel("Local signal level");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        panel2.add(jLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.localSignalBar, gridBagConstraints);
        panel2.add(this.localSignalBar);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.localSignalTextField, gridBagConstraints);
        panel2.add(this.localSignalTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        jLabel = new JLabel("Local SNR");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        panel2.add(jLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.localSNRBar, gridBagConstraints);
        panel2.add(this.localSNRBar);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.localSNRTextField, gridBagConstraints);
        panel2.add(this.localSNRTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        jLabel = new JLabel("Local noise level");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        panel2.add(jLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.localNoiseBar, gridBagConstraints);
        panel2.add(this.localNoiseBar);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.localNoiseTextField, gridBagConstraints);
        panel2.add(this.localNoiseTextField);
        Panel panel3 = new Panel();
        panel3.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jLabel = new JLabel("Remote signal level");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        panel3.add(jLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.remoteSignalBar, gridBagConstraints);
        panel3.add(this.remoteSignalBar);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.remoteSignalTextField, gridBagConstraints);
        panel3.add(this.remoteSignalTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        jLabel = new JLabel("Remote SNR");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        panel3.add(jLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.remoteSNRBar, gridBagConstraints);
        panel3.add(this.remoteSNRBar);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.remoteSNRTextField, gridBagConstraints);
        panel3.add(this.remoteSNRTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        jLabel = new JLabel("Remote noise level");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        panel3.add(jLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.remoteNoiseBar, gridBagConstraints);
        panel3.add(this.remoteNoiseBar);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.remoteNoiseTextField, gridBagConstraints);
        panel3.add(this.remoteNoiseTextField);
        Panel panel4 = new Panel();
        panel4.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        panel4.add(panel2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(panel3, gridBagConstraints);
        panel4.add(panel3);
        this.getContentPane().setLayout(gridBagLayout);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.getContentPane().add(panel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(panel4, gridBagConstraints);
        this.getContentPane().add(panel4);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        JLabel jLabel2 = new JLabel("Messages:");
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        this.getContentPane().add(jLabel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.messagesScroll, gridBagConstraints);
        this.getContentPane().add(this.messagesScroll);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.authorLabel, gridBagConstraints);
        this.getContentPane().add(this.authorLabel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string = actionEvent.getActionCommand();
        if (string == "quit") {
            this.stopLinkTest();
            System.exit(0);
        }
        if (string == "about") {
            object = new AboutDialog(this);
        }
        if (string == "new host" && (object = JOptionPane.showInputDialog("Input access point address:")) != null) {
            try {
                this.version = 0;
                this.hostAddress = InetAddress.getByName((String)object);
                this.stopLinkTest();
                this.comInterface = new SNMPv1CommunicationInterface(this.version, this.hostAddress, this.community);
                this.comInterface.setSocketTimeout(5000);
                this.hostIDField.setText((String)object);
            }
            catch (UnknownHostException unknownHostException) {
                JOptionPane.showMessageDialog(this, "Unknown host supplied.");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Error setting new access point address: " + exception);
            }
        }
        if (string == "new community" && (object = JOptionPane.showInputDialog("Input new community:")) != null) {
            try {
                this.version = 0;
                this.community = object;
                this.stopLinkTest();
                this.comInterface = new SNMPv1CommunicationInterface(this.version, this.hostAddress, this.community);
                this.comInterface.setSocketTimeout(5000);
                this.communityField.setText((String)object);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Error setting new community: " + exception);
            }
        }
        if (string == "new wireless host") {
            try {
                this.stopLinkTest();
                this.messagesArea.setText("");
                int n = 0;
                while (n < 10) {
                    String string2;
                    int n2 = 1;
                    while (n2 <= 3) {
                        string2 = "1.3.6.1.4.1.762.2.5.5." + n2;
                        this.comInterface.setMIBEntry(string2, new SNMPInteger(50L));
                        string2 = "1.3.6.1.4.1.762.2.5.4." + n2;
                        this.comInterface.setMIBEntry(string2, new SNMPInteger(3L));
                        ++n2;
                    }
                    string2 = "1.3.6.1.4.1.762.2.5.1.0";
                    SNMPVarBindList sNMPVarBindList = this.comInterface.getMIBEntry(string2);
                    SNMPSequence sNMPSequence = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
                    SNMPInteger sNMPInteger = (SNMPInteger)sNMPSequence.getSNMPObjectAt(1);
                    int n3 = Integer.parseInt(sNMPInteger.toString());
                    if (n3 > 0) {
                        SNMPObject sNMPObject;
                        Object[] objectArray = new String[n3];
                        int n4 = 0;
                        while (n4 < n3) {
                            string2 = "1.3.6.1.4.1.762.2.5.2.1.3." + (n4 + 1);
                            sNMPVarBindList = this.comInterface.getMIBEntry(string2);
                            sNMPSequence = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
                            sNMPObject = sNMPSequence.getSNMPObjectAt(1);
                            objectArray[n4] = sNMPObject.toString();
                            ++n4;
                        }
                        String string3 = (String)JOptionPane.showInputDialog(null, "Select new wireless host:", "", -1, null, objectArray, objectArray[0]);
                        if (string3 == null) break;
                        int n5 = 0;
                        while (n5 < n3) {
                            if (string3.equals(objectArray[n5])) {
                                this.wirelessHostNum = n5 + 1;
                            }
                            ++n5;
                        }
                        this.wirelessHostField.setText(string3);
                        string2 = "1.3.6.1.4.1.762.2.5.2.1.11." + this.wirelessHostNum;
                        sNMPVarBindList = this.comInterface.getMIBEntry(string2);
                        sNMPSequence = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
                        sNMPObject = sNMPSequence.getSNMPObjectAt(1);
                        this.wirelessHostMACField.setText(((SNMPOctetString)sNMPObject).toHexString());
                        break;
                    }
                    ++n;
                }
                if (n >= 10) {
                    this.messagesArea.setText("Try again... no wireless hosts currently available");
                }
            }
            catch (Exception exception) {
                this.messagesArea.setText("Error selecting new wireless host: " + exception);
            }
        }
        if (string == "test link") {
            this.startLinkTest();
        }
        if (string == "stop link test") {
            this.stopLinkTest();
        }
    }

    private void stopLinkTest() {
        if (this.statusThread.isAlive()) {
            try {
                this.statusThread.interrupt();
                this.statusThread.join();
            }
            catch (InterruptedException interruptedException) {
                this.messagesArea.setText("Exception during link test thread exit:  " + interruptedException + "\n");
            }
            this.scanButton.setText("Test wireless link");
            this.scanButton.setActionCommand("test link");
        }
    }

    private void startLinkTest() {
        if (!this.statusThread.isAlive()) {
            this.scanButton.setText("Stop link test");
            this.scanButton.setActionCommand("stop link test");
            this.statusThread = new Thread(this);
            this.statusThread.start();
        }
    }

    private String hexByte(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        String string = new String();
        string = String.valueOf(string) + Integer.toHexString(n2 / 16);
        string = String.valueOf(string) + Integer.toHexString(n2 % 16);
        return string;
    }

    public void run() {
        String string;
        while (!Thread.interrupted()) {
            try {
                this.messagesArea.setText("");
                string = "1.3.6.1.4.1.762.2.5.2.1.27." + this.wirelessHostNum;
                SNMPVarBindList sNMPVarBindList = this.comInterface.setMIBEntry(string, new SNMPInteger(1500L));
                string = "1.3.6.1.4.1.762.2.5.2.1.26." + this.wirelessHostNum;
                sNMPVarBindList = this.comInterface.setMIBEntry(string, new SNMPInteger(25L));
                string = "1.3.6.1.4.1.762.2.5.2.1.25." + this.wirelessHostNum;
                sNMPVarBindList = this.comInterface.setMIBEntry(string, new SNMPInteger(88L));
                string = "1.3.6.1.4.1.762.2.5.2.1.3." + this.wirelessHostNum;
                sNMPVarBindList = this.comInterface.getMIBEntry(string);
                SNMPSequence sNMPSequence = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
                SNMPObject sNMPObject = sNMPSequence.getSNMPObjectAt(1);
                this.wirelessHostMACField.setText(sNMPObject.toString());
                string = "1.3.6.1.4.1.762.2.5.2.1.11." + this.wirelessHostNum;
                sNMPVarBindList = this.comInterface.getMIBEntry(string);
                sNMPSequence = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
                sNMPObject = sNMPSequence.getSNMPObjectAt(1);
                this.wirelessHostMACField.setText(((SNMPOctetString)sNMPObject).toHexString());
                string = "1.3.6.1.4.1.762.2.5.1.0";
                sNMPVarBindList = this.comInterface.getMIBEntry(string);
                sNMPSequence = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
                SNMPInteger sNMPInteger = (SNMPInteger)sNMPSequence.getSNMPObjectAt(1);
                int n = Integer.parseInt(sNMPInteger.toString());
                if (n >= this.wirelessHostNum) {
                    string = "1.3.6.1.4.1.762.2.5.2.1.32." + this.wirelessHostNum;
                    sNMPVarBindList = this.comInterface.getMIBEntry(string);
                    sNMPSequence = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
                    sNMPInteger = (SNMPInteger)sNMPSequence.getSNMPObjectAt(1);
                    this.localSignalBar.setValue(Integer.parseInt(sNMPInteger.toString()));
                    this.localSignalTextField.setText(sNMPInteger.toString());
                    string = "1.3.6.1.4.1.762.2.5.2.1.33." + this.wirelessHostNum;
                    sNMPVarBindList = this.comInterface.getMIBEntry(string);
                    sNMPSequence = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
                    sNMPInteger = (SNMPInteger)sNMPSequence.getSNMPObjectAt(1);
                    this.localNoiseBar.setValue(Integer.parseInt(sNMPInteger.toString()));
                    this.localNoiseTextField.setText(sNMPInteger.toString());
                    string = "1.3.6.1.4.1.762.2.5.2.1.35." + this.wirelessHostNum;
                    sNMPVarBindList = this.comInterface.getMIBEntry(string);
                    sNMPSequence = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
                    sNMPInteger = (SNMPInteger)sNMPSequence.getSNMPObjectAt(1);
                    this.localSNRBar.setValue(Integer.parseInt(sNMPInteger.toString()));
                    this.localSNRTextField.setText(sNMPInteger.toString());
                    string = "1.3.6.1.4.1.762.2.5.2.1.44." + this.wirelessHostNum;
                    sNMPVarBindList = this.comInterface.getMIBEntry(string);
                    sNMPSequence = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
                    sNMPInteger = (SNMPInteger)sNMPSequence.getSNMPObjectAt(1);
                    this.remoteSignalBar.setValue(Integer.parseInt(sNMPInteger.toString()));
                    this.remoteSignalTextField.setText(sNMPInteger.toString());
                    string = "1.3.6.1.4.1.762.2.5.2.1.45." + this.wirelessHostNum;
                    sNMPVarBindList = this.comInterface.getMIBEntry(string);
                    sNMPSequence = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
                    sNMPInteger = (SNMPInteger)sNMPSequence.getSNMPObjectAt(1);
                    this.remoteNoiseBar.setValue(Integer.parseInt(sNMPInteger.toString()));
                    this.remoteNoiseTextField.setText(sNMPInteger.toString());
                    string = "1.3.6.1.4.1.762.2.5.2.1.47." + this.wirelessHostNum;
                    sNMPVarBindList = this.comInterface.getMIBEntry(string);
                    sNMPSequence = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
                    sNMPInteger = (SNMPInteger)sNMPSequence.getSNMPObjectAt(1);
                    this.remoteSNRBar.setValue(Integer.parseInt(sNMPInteger.toString()));
                    this.remoteSNRTextField.setText(sNMPInteger.toString());
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    this.statusThread.interrupt();
                }
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (Exception exception) {
                this.messagesArea.append("Exception during link status polling:  " + exception + "\n");
            }
        }
        try {
            string = "1.3.6.1.4.1.762.2.5.2.1.25." + this.wirelessHostNum;
            this.comInterface.setMIBEntry(string, new SNMPInteger(0L));
        }
        catch (Exception exception) {
            this.messagesArea.append("Exception during modem status polling exit:  " + exception + "\n");
        }
    }

    public static void main(String[] stringArray) {
        try {
            LinkMonitor linkMonitor = new LinkMonitor();
            linkMonitor.pack();
            Dimension dimension = linkMonitor.getSize();
            dimension.height += 20;
            dimension.width += 20;
            ((Component)linkMonitor).setSize(dimension);
            linkMonitor.show();
        }
        catch (Exception exception) {}
    }

    private class WindowCloseAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            LinkMonitor.this.stopLinkTest();
            System.exit(0);
        }

        WindowCloseAdapter() {
        }
    }
}

