/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfoRecord;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Airport2ProtocolMessage {
    public String messageTag = "acpp";
    public int unknownField1 = 1;
    public int messageChecksum = 0;
    public int payloadChecksum = 0;
    public int payloadSize;
    public byte[] unknownField2 = new byte[8];
    public int messageType;
    public byte[] unknownField3 = new byte[16];
    public byte[] password = new byte[32];
    public byte[] unknownField4 = new byte[48];
    public static final int READ = 20;
    public static final int WRITE = 21;

    public Airport2ProtocolMessage(int messageType, String password, byte[] payloadBytes, int payloadSize) {
        if (messageType == 20) {
            this.payloadSize = payloadSize;
            this.payloadChecksum = this.computeChecksum(payloadBytes, payloadSize);
        } else {
            this.payloadSize = -1;
            this.payloadChecksum = 1;
        }
        this.messageType = messageType;
        byte[] passwordBytes = password.getBytes();
        int length = passwordBytes.length;
        if (length > 32) {
            length = 32;
        }
        int i = 0;
        while (i < length) {
            this.password[i] = passwordBytes[i];
            ++i;
        }
        this.password = AirportInfoRecord.encryptBytes(AirportInfoRecord.cipherBytes, this.password);
        this.messageChecksum = this.computeChecksum(this.getBytes(), 128);
    }

    public byte[] getBytes() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(128);
        DataOutputStream outStream = new DataOutputStream(byteStream);
        try {
            outStream.writeBytes(this.messageTag);
            outStream.writeInt(this.unknownField1);
            outStream.writeInt(this.messageChecksum);
            outStream.writeInt(this.payloadChecksum);
            outStream.writeInt(this.payloadSize);
            outStream.write(this.unknownField2);
            outStream.writeInt(this.messageType);
            outStream.write(this.unknownField3);
            outStream.write(this.password);
            outStream.write(this.unknownField4);
        }
        catch (IOException iOException) {}
        return byteStream.toByteArray();
    }

    private int computeChecksum(byte[] fileBytes, int length) {
        int weightedChecksum = 0;
        int ordinaryChecksum = 0;
        int i = 0;
        while (i < length) {
            int byteValue = fileBytes[i];
            if (byteValue < 0) {
                byteValue += 256;
            }
            ordinaryChecksum += byteValue;
            weightedChecksum += byteValue * (length - i);
            ++i;
        }
        ++ordinaryChecksum;
        weightedChecksum += length;
        ordinaryChecksum &= 0xFFFF;
        while (weightedChecksum > 65535) {
            int upperHalf = (weightedChecksum & 0xFFFF0000) >> 16;
            int lowerHalf = weightedChecksum & 0xFFFF;
            weightedChecksum = lowerHalf + upperHalf * 15;
        }
        int checksum = ordinaryChecksum | weightedChecksum << 16;
        return checksum;
    }
}

