/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfo;
import airport.AirportInfoPanel;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class AirportAccessControlTable
extends AirportInfoPanel {
    private AirportInfo airportInfo;
    private Vector addressVector;
    private JTable table;
    private AbstractTableModel tableModel;

    public AirportAccessControlTable(AirportInfo airportInfo) {
        this.airportInfo = airportInfo;
        this.setUpDisplay();
    }

    private void setUpDisplay() {
        this.refreshDisplay();
    }

    public void writeValue() throws ValueFormatException {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        int numMacAddresses = 0;
        Vector<AirportInfoRecord> addressRecordVector = new Vector<AirportInfoRecord>();
        Vector<AirportInfoRecord> nameRecordVector = new Vector<AirportInfoRecord>();
        int i = 0;
        while (i < this.addressVector.size()) {
            block11: {
                try {
                    if (((String[])this.addressVector.elementAt(i))[0].equals("")) break block11;
                    AirportInfoRecord addressRecord = new AirportInfoRecord("temp", "temp", 2, 0, 6);
                    addressRecord.setBytesFromString(((String[])this.addressVector.elementAt(i))[0]);
                    addressRecordVector.add(addressRecord);
                    ++numMacAddresses;
                }
                catch (ValueFormatException e) {
                    this.table.editCellAt(i, 0);
                    throw e;
                }
                try {
                    AirportInfoRecord nameRecord = new AirportInfoRecord("temp", "temp", 0, 0, 32);
                    nameRecord.setBytesFromString(((String[])this.addressVector.elementAt(i))[1]);
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    try {
                        outStream.write(nameRecord.value);
                        byte[] padBytes = new byte[34 - nameRecord.value.length];
                        outStream.write(padBytes);
                    }
                    catch (IOException iOException) {}
                    nameRecord.value = outStream.toByteArray();
                    nameRecordVector.add(nameRecord);
                }
                catch (ValueFormatException e) {
                    this.table.editCellAt(i, 1);
                    throw e;
                }
            }
            ++i;
        }
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            byte[] zeroBytes = new byte[4];
            outStream.write(zeroBytes);
            AirportInfoRecord sizeRecord = new AirportInfoRecord("temp", "temp", 4, 0, 4);
            sizeRecord.setBytesFromString(Integer.toString(numMacAddresses));
            outStream.write(sizeRecord.value);
            zeroBytes = new byte[8];
            outStream.write(zeroBytes);
            int i2 = 0;
            while (i2 < numMacAddresses) {
                outStream.write(((AirportInfoRecord)addressRecordVector.elementAt((int)i2)).value);
                outStream.write(((AirportInfoRecord)nameRecordVector.elementAt((int)i2)).value);
                ++i2;
            }
            AirportInfoRecord accessControlRecord = this.airportInfo.get("acTa");
            accessControlRecord.setValue(outStream.toByteArray());
            String accessSwitchValue = new String();
            accessSwitchValue = numMacAddresses > 0 ? "01" : "00";
            AirportInfoRecord accessControlSwitchRecord = this.airportInfo.get("acEn");
            accessControlSwitchRecord.setBytesFromString(accessSwitchValue);
        }
        catch (IOException iOException) {}
    }

    public void refreshDisplay() {
        this.addressVector = new Vector();
        AirportInfoRecord accessControlRecord = this.airportInfo.get("acTa");
        byte[] accessControlBytes = accessControlRecord.getValue();
        DataInputStream inStream = new DataInputStream(new ByteArrayInputStream(accessControlBytes));
        try {
            inStream.skip(4L);
            int numMacAddresses = inStream.readInt();
            inStream.skip(8L);
            int i = 0;
            while (i < numMacAddresses) {
                byte[] addressBytes = new byte[6];
                inStream.read(addressBytes);
                AirportInfoRecord addressRecord = new AirportInfoRecord("temp", "temp", 2, 0, 6, addressBytes);
                byte[] nameBytes = new byte[34];
                inStream.read(nameBytes);
                AirportInfoRecord nameRecord = new AirportInfoRecord("temp", "temp", 0, 0, 34, nameBytes);
                String[] addressEntry = new String[]{addressRecord.toString(), nameRecord.toString()};
                this.addressVector.insertElementAt(addressEntry, this.addressVector.size());
                ++i;
            }
            this.removeAll();
            this.tableModel = new AccessAddressTableModel();
            this.table = new JTable(this.tableModel);
            this.table.setCellSelectionEnabled(true);
            this.table.setPreferredScrollableViewportSize(new Dimension(350, 200));
            JScrollPane scrollPane = new JScrollPane(this.table);
            this.add(scrollPane);
        }
        catch (IOException iOException) {}
    }

    private class AccessAddressTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return 256;
        }

        public boolean isCellEditable(int row, int col) {
            return row <= AirportAccessControlTable.this.addressVector.size();
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "MAC address";
            }
            return "Host name (opt)";
        }

        public Object getValueAt(int row, int col) {
            if (row < AirportAccessControlTable.this.addressVector.size()) {
                return ((String[])AirportAccessControlTable.this.addressVector.elementAt(row))[col];
            }
            return "";
        }

        public void setValueAt(Object newValue, int row, int col) {
            if (newValue instanceof String) {
                if (row < AirportAccessControlTable.this.addressVector.size()) {
                    String[] addressEntry = (String[])AirportAccessControlTable.this.addressVector.elementAt(row);
                    addressEntry[col] = (String)newValue;
                } else {
                    String[] addressEntry = new String[]{"", ""};
                    addressEntry[col] = (String)newValue;
                    AirportAccessControlTable.this.addressVector.insertElementAt(addressEntry, AirportAccessControlTable.this.addressVector.size());
                }
            }
        }

        AccessAddressTableModel() {
        }
    }
}

