/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportDHCPRangePanel;
import airport.AirportInfo;
import airport.AirportInfoCheckBox;
import airport.AirportInfoLabelledScaledValueField;
import airport.AirportInfoPanel;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

public class AirportDHCPPanel
extends AirportInfoPanel {
    private AirportInfoCheckBox dhcpCheckbox;
    private AirportDHCPRangePanel dhcpRangePanel;
    private AirportInfoPanel dhcpInfoPanel;
    private AirportInfoLabelledScaledValueField dhcpLeaseTime;
    private AirportInfo theInfo;

    public AirportDHCPPanel(AirportInfo theInfo) {
        this.theInfo = theInfo;
        this.dhcpRangePanel = new AirportDHCPRangePanel(theInfo);
        this.dhcpLeaseTime = new AirportInfoLabelledScaledValueField("DHCP lease time (minutes)", theInfo.get("dhLe"), 60);
        this.dhcpCheckbox = new AirportInfoCheckBox("Distribute addresses to wireless and wired hosts using DHCP", theInfo.get("raDS"), "01", "00");
        this.dhcpInfoPanel = new AirportInfoPanel();
        this.setUpDisplay();
    }

    private void setUpDisplay() {
        Insets theMargin;
        GridBagLayout theLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.ipadx = 0;
        c.ipady = 0;
        c.insets = theMargin = new Insets(2, 2, 2, 2);
        c.anchor = 10;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.dhcpInfoPanel.setLayout(theLayout);
        c.anchor = 17;
        c.gridx = 1;
        c.gridy = 1;
        theLayout.setConstraints(this.dhcpRangePanel, c);
        this.dhcpInfoPanel.add(this.dhcpRangePanel);
        c.gridx = 1;
        c.gridy = 2;
        theLayout.setConstraints(this.dhcpLeaseTime, c);
        this.dhcpInfoPanel.add(this.dhcpLeaseTime);
        this.setLayout(theLayout);
        c.anchor = 17;
        c.gridx = 1;
        c.gridy = 1;
        theLayout.setConstraints(this.dhcpCheckbox, c);
        this.add(this.dhcpCheckbox);
        c.gridx = 1;
        c.gridy = 2;
        theLayout.setConstraints(this.dhcpInfoPanel, c);
        this.add(this.dhcpInfoPanel);
        this.dhcpCheckbox.addItemListener(this.dhcpInfoPanel);
        this.dhcpInfoPanel.setEnabled(this.dhcpCheckbox.isSelected());
    }

    public void writeValue() throws ValueFormatException {
        super.writeValue();
        AirportInfoRecord dhcpLANRecord = this.theInfo.get("laDS");
        if (this.dhcpCheckbox.isSelected()) {
            dhcpLANRecord.setBytesFromString("01");
        } else {
            dhcpLANRecord.setBytesFromString("00");
        }
    }
}

