/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfo;
import airport.AirportInfoLabelledTextField;
import airport.AirportInfoPanel;
import airport.AirportInfoRadioButton;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;

public class AirportEncryptionPanel
extends AirportInfoPanel {
    private AirportInfoLabelledTextField encryptionKeyField;
    private AirportInfoRadioButton noEncryptionButton;
    private AirportInfoRadioButton keySize40Button;
    private AirportInfoRadioButton keySize128Button;
    private ButtonGroup buttonGroup;
    AirportInfo theInfo;

    public AirportEncryptionPanel(AirportInfo theInfo) {
        this.theInfo = theInfo;
        this.noEncryptionButton = new AirportInfoRadioButton("No encryption");
        this.noEncryptionButton.addInfoRecord(theInfo.get("raWM"), "00000000");
        this.keySize40Button = new AirportInfoRadioButton("Use 40-bit encryption");
        this.keySize40Button.addInfoRecord(theInfo.get("raWM"), "00000001");
        this.keySize128Button = new AirportInfoRadioButton("Use 128-bit encryption");
        this.keySize128Button.addInfoRecord(theInfo.get("raWM"), "00000002");
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.noEncryptionButton);
        this.buttonGroup.add(this.keySize40Button);
        this.buttonGroup.add(this.keySize128Button);
        this.encryptionKeyField = new AirportInfoLabelledTextField("Encryption key:", theInfo.get("raWE"), 20);
        this.setUpDisplay();
    }

    public void setUpDisplay() {
        GridBagLayout theLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.ipadx = 0;
        c.ipady = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 10;
        c.weightx = 0.5;
        c.weighty = 0.5;
        AirportInfoPanel encryptionPanel = new AirportInfoPanel();
        encryptionPanel.add(this.encryptionKeyField);
        this.setLayout(theLayout);
        c.anchor = 17;
        c.gridx = 1;
        c.gridy = 1;
        theLayout.setConstraints(this.noEncryptionButton, c);
        this.add(this.noEncryptionButton);
        c.anchor = 17;
        c.gridx = 1;
        c.gridy = 2;
        theLayout.setConstraints(this.keySize40Button, c);
        this.add(this.keySize40Button);
        c.anchor = 17;
        c.gridx = 1;
        c.gridy = 3;
        theLayout.setConstraints(this.keySize128Button, c);
        this.add(this.keySize128Button);
        c.anchor = 10;
        c.gridx = 1;
        c.gridy = 4;
        theLayout.setConstraints(encryptionPanel, c);
        this.add(encryptionPanel);
        this.keySize40Button.addItemListener(encryptionPanel);
        this.keySize128Button.addItemListener(encryptionPanel);
        encryptionPanel.setEnabled(this.keySize40Button.isSelected() || this.keySize128Button.isSelected());
    }

    public void writeValue() throws ValueFormatException {
        AirportInfoRecord keyRecord = this.theInfo.get("raWE");
        if (this.keySize40Button.isSelected()) {
            keyRecord.maxLength = 5;
            this.encryptionKeyField.writeValue();
        } else if (this.keySize128Button.isSelected()) {
            keyRecord.maxLength = 13;
            this.encryptionKeyField.writeValue();
        }
        super.writeValue();
    }
}

