/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfo;
import airport.AirportInfoPanel;
import airport.AirportInfoTextField;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;

public class AirportIPConfigPanel
extends AirportInfoPanel {
    private AirportInfoTextField ipAddressField;
    private AirportInfoTextField subnetMaskField;
    private AirportInfoTextField routerIPAddressField;

    public AirportIPConfigPanel(AirportInfo theInfo) {
        this.ipAddressField = new AirportInfoTextField(theInfo.get("waIP"));
        this.subnetMaskField = new AirportInfoTextField(theInfo.get("waSM"));
        this.routerIPAddressField = new AirportInfoTextField(theInfo.get("waRA"));
        this.setUpDisplay();
    }

    public AirportIPConfigPanel(AirportInfo theInfo, String defaultIPAddress, String defaultSubnetMask, String defaultRouterIPAddress) {
        this.ipAddressField = new AirportInfoTextField(theInfo.get("waIP"));
        if (!defaultIPAddress.equals("")) {
            this.ipAddressField.setText(defaultIPAddress);
        }
        this.subnetMaskField = new AirportInfoTextField(theInfo.get("waSM"));
        if (!defaultSubnetMask.equals("")) {
            this.subnetMaskField.setText(defaultSubnetMask);
        }
        this.routerIPAddressField = new AirportInfoTextField(theInfo.get("waRA"));
        if (!defaultRouterIPAddress.equals("")) {
            this.routerIPAddressField.setText(defaultRouterIPAddress);
        }
        this.setUpDisplay();
    }

    private void setUpDisplay() {
        Insets theMargin;
        GridBagLayout theLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.ipadx = 0;
        c.ipady = 0;
        c.insets = theMargin = new Insets(2, 2, 2, 2);
        c.anchor = 10;
        c.weightx = 0.5;
        c.weighty = 0.5;
        this.setLayout(theLayout);
        c.gridwidth = 1;
        c.anchor = 13;
        c.gridx = 1;
        c.gridy = 1;
        JLabel label = new JLabel("IP address");
        theLayout.setConstraints(label, c);
        this.add(label);
        c.anchor = 17;
        c.gridx = 2;
        c.gridy = 1;
        theLayout.setConstraints(this.ipAddressField, c);
        this.add(this.ipAddressField);
        c.anchor = 13;
        c.gridx = 1;
        c.gridy = 2;
        label = new JLabel("Subnet mask");
        theLayout.setConstraints(label, c);
        this.add(label);
        c.anchor = 17;
        c.gridx = 2;
        c.gridy = 2;
        theLayout.setConstraints(this.subnetMaskField, c);
        this.add(this.subnetMaskField);
        c.anchor = 13;
        c.gridx = 1;
        c.gridy = 3;
        label = new JLabel("Router address");
        theLayout.setConstraints(label, c);
        this.add(label);
        c.anchor = 17;
        c.gridx = 2;
        c.gridy = 3;
        theLayout.setConstraints(this.routerIPAddressField, c);
        this.add(this.routerIPAddressField);
    }
}

