/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfoComponent;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import javax.swing.JTextField;

public class AirportInfoScaledValueField
extends JTextField
implements AirportInfoComponent {
    private AirportInfoRecord theRecord;
    private int scalingFactor;

    public AirportInfoScaledValueField(AirportInfoRecord theRecord, int scalingFactor) {
        this.theRecord = theRecord;
        this.scalingFactor = scalingFactor;
        int fieldSize = theRecord.maxLength;
        if ((fieldSize *= 3) > 40) {
            fieldSize = 40;
        }
        this.setColumns(fieldSize);
        this.refreshDisplay();
    }

    public AirportInfoScaledValueField(AirportInfoRecord theRecord, int scalingFactor, int fieldSize) {
        this.theRecord = theRecord;
        this.scalingFactor = scalingFactor;
        this.setColumns(fieldSize);
        this.refreshDisplay();
    }

    public void refreshDisplay() {
        try {
            long storedValue = Long.parseLong(this.theRecord.toString());
            long displayValue = storedValue / (long)this.scalingFactor;
            String valueString = new String();
            valueString = String.valueOf(valueString) + displayValue;
            this.setText(valueString);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void writeValue() throws ValueFormatException {
        long displayValue = 0L;
        try {
            displayValue = Long.parseLong(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.selectAll();
            this.requestFocus();
            throw new ValueFormatException("Bad number format.");
        }
        int numBytes = this.theRecord.maxLength;
        long minValue = 0L;
        long maxValue = 1L;
        int i = 0;
        while (i < numBytes) {
            maxValue *= 256L;
            ++i;
        }
        --maxValue;
        if (displayValue < minValue || displayValue > (maxValue /= (long)this.scalingFactor)) {
            this.selectAll();
            this.requestFocus();
            throw new ValueFormatException("Value must be between " + minValue + " and " + maxValue + ".");
        }
        long storedValue = displayValue * (long)this.scalingFactor;
        String valueString = new String();
        valueString = String.valueOf(valueString) + storedValue;
        this.theRecord.setBytesFromString(valueString);
    }

    public void writeValue(String newValue) throws ValueFormatException {
        this.setText(newValue);
        this.writeValue();
        this.refreshDisplay();
    }
}

