/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfoComponent;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import javax.swing.JTextField;

public class AirportInfoTextField
extends JTextField
implements AirportInfoComponent {
    private AirportInfoRecord theRecord;

    public AirportInfoTextField(AirportInfoRecord theRecord) {
        this.theRecord = theRecord;
        int fieldSize = theRecord.maxLength;
        switch (theRecord.dataType) {
            case 3: {
                fieldSize = 20;
                break;
            }
            case 1: {
                fieldSize = 15;
                break;
            }
            default: {
                fieldSize *= 3;
            }
            case 0: 
        }
        if (fieldSize > 40) {
            fieldSize = 40;
        }
        this.setColumns(fieldSize);
        this.refreshDisplay();
    }

    public AirportInfoTextField(AirportInfoRecord theRecord, int fieldSize) {
        this.theRecord = theRecord;
        this.setColumns(fieldSize);
        this.refreshDisplay();
    }

    public void refreshDisplay() {
        this.setText(this.theRecord.toString());
    }

    public void writeValue() throws ValueFormatException {
        try {
            this.theRecord.setBytesFromString(this.getText());
        }
        catch (ValueFormatException e) {
            this.selectAll();
            this.requestFocus();
            throw e;
        }
    }

    public void writeValue(String newValue) throws ValueFormatException {
        this.setText(newValue);
        this.writeValue();
        this.refreshDisplay();
    }
}

